/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.fluidsynth;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiOutputPortProviderImpl;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiOutputPortSettings
extends MidiSettings {
    private static final int TABLE_WIDTH = 350;
    private static final int TABLE_HEIGHT = 200;

    public MidiOutputPortSettings(MidiOutputPortProviderImpl provider) {
        super(provider);
    }

    public void configure(Shell parent) {
        final Shell dialog = DialogUtils.newDialog((Shell)parent, (int)67680);
        dialog.setText(TuxGuitar.getProperty((String)"fluidsynth.settings"));
        dialog.setLayout((Layout)new GridLayout());
        dialog.setLayoutData((Object)new GridData(4, 4, true, true));
        TabFolder tabs = new TabFolder((Composite)dialog, 128);
        tabs.setLayout((Layout)new FormLayout());
        Composite cSoundfonts = new Composite((Composite)tabs, 0);
        cSoundfonts.setLayout((Layout)this.getGridLayout(2));
        cSoundfonts.setLayoutData((Object)new FormData());
        TabItem tSoundfonts = new TabItem(tabs, 0);
        tSoundfonts.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.soundfonts"));
        tSoundfonts.setControl((Control)cSoundfonts);
        Composite cSoundfontsTable = new Composite(cSoundfonts, 0);
        cSoundfontsTable.setLayout((Layout)new GridLayout());
        cSoundfontsTable.setLayoutData((Object)new GridData(4, 4, true, true));
        final Table soundfontsTable = new Table(cSoundfontsTable, 68356);
        soundfontsTable.setLayoutData((Object)this.getTableData());
        soundfontsTable.setHeaderVisible(true);
        TableColumn soundfontsTableColumn = new TableColumn(soundfontsTable, 0);
        soundfontsTableColumn.setWidth(350);
        soundfontsTableColumn.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.soundfonts.list"));
        Composite cSoundfontsButtons = new Composite(cSoundfonts, 0);
        cSoundfontsButtons.setLayout((Layout)new GridLayout());
        cSoundfontsButtons.setLayoutData((Object)new GridData(4, 4, true, true));
        Button buttonAdd = new Button(cSoundfontsButtons, 8);
        buttonAdd.setLayoutData((Object)this.getButtonData(4, 128, true, false));
        buttonAdd.setText(TuxGuitar.getProperty((String)"add"));
        buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MidiOutputPortSettings.this.addMidiPort(soundfontsTable);
            }
        });
        Button buttonDelete = new Button(cSoundfontsButtons, 8);
        buttonDelete.setText(TuxGuitar.getProperty((String)"remove"));
        buttonDelete.setLayoutData((Object)this.getButtonData(4, 128, true, false));
        buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MidiOutputPortSettings.this.removeMidiPort(soundfontsTable);
            }
        });
        this.addMidiPorts(soundfontsTable);
        Composite cAudio = new Composite((Composite)tabs, 0);
        cAudio.setLayout((Layout)new GridLayout(2, false));
        cAudio.setLayoutData((Object)new FormData());
        TabItem tAudio = new TabItem(tabs, 0);
        tAudio.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.audio"));
        tAudio.setControl((Control)cAudio);
        final List<String> audioDriverOptions = this.getAudioDriverOptions();
        Label lAudioDriver = new Label(cAudio, 0);
        lAudioDriver.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        lAudioDriver.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.audio.driver"));
        final Combo cAudioDriver = new Combo(cAudio, 12);
        cAudioDriver.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fillAudioDriverCombo(audioDriverOptions, cAudioDriver);
        final List<String> audioSampleFormatOptions = this.getAudioSampleFormatOptions();
        Label lAudioSampleFormat = new Label(cAudio, 0);
        lAudioSampleFormat.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        lAudioSampleFormat.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.audio.sample-format"));
        final Combo cAudioSampleFormat = new Combo(cAudio, 12);
        cAudioSampleFormat.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fillAudioSampleFormatCombo(audioSampleFormatOptions, cAudioSampleFormat);
        final List<Integer> audioPeriodSizeOptions = this.getAudioPeriodSizeOptions();
        Label lAudioPeriodSize = new Label(cAudio, 0);
        lAudioPeriodSize.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        lAudioPeriodSize.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.audio.period-size"));
        final Combo cAudioPeriodSize = new Combo(cAudio, 12);
        cAudioPeriodSize.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fillAudioPeriodSizeCombo(audioPeriodSizeOptions, cAudioPeriodSize);
        final List<Integer> audioPeriodCountOptions = this.getAudioPeriodCountOptions();
        Label lAudioPeriodCount = new Label(cAudio, 0);
        lAudioPeriodCount.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        lAudioPeriodCount.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.audio.periods"));
        final Combo cAudioPeriodCount = new Combo(cAudio, 12);
        cAudioPeriodCount.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fillAudioPeriodCountCombo(audioPeriodCountOptions, cAudioPeriodCount);
        Composite cSynth = new Composite((Composite)tabs, 0);
        cSynth.setLayout((Layout)new GridLayout(2, false));
        cSynth.setLayoutData((Object)new FormData());
        TabItem tSynth = new TabItem(tabs, 0);
        tSynth.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth"));
        tSynth.setControl((Control)cSynth);
        Label lSynthGain = new Label(cSynth, 0);
        lSynthGain.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        lSynthGain.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth.gain"));
        final Scale sSynthGain = new Scale(cSynth, 256);
        sSynthGain.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fillSynthGainScale(sSynthGain);
        final List<Double> synthSampleRateOptions = this.getSynthSampleRateOptions();
        Label lSynthSampleRate = new Label(cSynth, 0);
        lSynthSampleRate.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        lSynthSampleRate.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth.sample-rate"));
        final Combo cSynthSampleRate = new Combo(cSynth, 12);
        cSynthSampleRate.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fillSynthSampleRateCombo(synthSampleRateOptions, cSynthSampleRate);
        Label lSynthPolyphony = new Label(cSynth, 0);
        lSynthPolyphony.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        lSynthPolyphony.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth.polyphony"));
        final Spinner sSynthPolyphony = new Spinner(cSynth, 2048);
        sSynthPolyphony.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fillSynthPolyphonySpinner(sSynthPolyphony);
        final Button bSynthReverbActive = new Button(cSynth, 32);
        bSynthReverbActive.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        bSynthReverbActive.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth.reverb.active"));
        this.fillSynthReverbActiveCheckbox(bSynthReverbActive);
        final Button bSynthChorusActive = new Button(cSynth, 32);
        bSynthChorusActive.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        bSynthChorusActive.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth.chorus.active"));
        this.fillSynthChorusActiveCheckbox(bSynthChorusActive);
        Composite compositeButtons = new Composite((Composite)dialog, 0);
        compositeButtons.setLayout((Layout)new GridLayout(2, false));
        compositeButtons.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button buttonOK = new Button(compositeButtons, 8);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setLayoutData((Object)this.getButtonData(4, 4, true, true));
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MidiOutputPortSettings.this.updateSoundfontsSelection(soundfontsTable);
                MidiOutputPortSettings.this.updateAudioDriverSelection(audioDriverOptions, cAudioDriver.getSelectionIndex());
                MidiOutputPortSettings.this.updateAudioSampleFormatSelection(audioSampleFormatOptions, cAudioSampleFormat.getSelectionIndex());
                MidiOutputPortSettings.this.updateAudioPeriodSizeSelection(audioPeriodSizeOptions, cAudioPeriodSize.getSelectionIndex());
                MidiOutputPortSettings.this.updateAudioPeriodCountSelection(audioPeriodCountOptions, cAudioPeriodCount.getSelectionIndex());
                MidiOutputPortSettings.this.updateSynthSampleRateSelection(synthSampleRateOptions, cSynthSampleRate.getSelectionIndex());
                MidiOutputPortSettings.this.updateSynthGainSelection(sSynthGain.getSelection());
                MidiOutputPortSettings.this.updateSynthPolyphonySelection(sSynthPolyphony.getSelection());
                MidiOutputPortSettings.this.updateSynthReverbActiveSelection(bSynthReverbActive.getSelection());
                MidiOutputPortSettings.this.updateSynthChorusActiveSelection(bSynthChorusActive.getSelection());
                new Thread(new Runnable(){

                    public void run() {
                        MidiOutputPortSettings.this.update();
                    }
                }).start();
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(compositeButtons, 8);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData(4, 4, true, true));
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog((Shell)dialog, (int)11);
    }

    protected GridLayout getGridLayout(int columns) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    protected GridData getTableData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 200;
        return data;
    }

    protected GridData getButtonData(int hAlignment, int vAlignment, boolean grabExcessHSpace, boolean grabExcessVSpace) {
        GridData data = new GridData(hAlignment, vAlignment, grabExcessHSpace, grabExcessVSpace);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    protected void addMidiPorts(Table table) {
        for (String path : this.getSoundfonts()) {
            this.addMidiPort(table, path);
        }
    }

    protected void addMidiPort(Table table) {
        FileDialog chooser = new FileDialog(table.getShell());
        String path = chooser.open();
        if (path != null && path.length() > 0) {
            this.addMidiPort(table, path);
        }
    }

    protected void addMidiPort(Table table, String path) {
        TableItem item = new TableItem(table, 0);
        item.setText(path);
        item.setData((Object)path);
    }

    protected void removeMidiPort(Table table) {
        int index = table.getSelectionIndex();
        if (index >= 0 && index < table.getItemCount()) {
            table.remove(index);
        }
    }

    protected List<String> getAudioDriverOptions() {
        return this.getSynth().getPropertyOptions("audio.driver");
    }

    protected List<String> getAudioSampleFormatOptions() {
        return this.getSynth().getPropertyOptions("audio.sample-format");
    }

    protected List<Integer> getAudioPeriodSizeOptions() {
        ArrayList<Integer> options = new ArrayList<Integer>();
        int[] range = this.getSynth().getIntegerPropertyRange("audio.period-size");
        if (range.length == 2 && range[0] < range[1]) {
            for (int value = range[0]; value <= range[1]; value *= 2) {
                options.add(new Integer(value));
            }
        }
        return options;
    }

    protected List<Integer> getAudioPeriodCountOptions() {
        ArrayList<Integer> options = new ArrayList<Integer>();
        int[] range = this.getSynth().getIntegerPropertyRange("audio.periods");
        if (range.length == 2 && range[0] < range[1]) {
            for (int value = range[0]; value <= range[1]; value *= 2) {
                options.add(new Integer(value));
            }
        }
        return options;
    }

    protected List<Double> getSynthSampleRateOptions() {
        ArrayList<Double> options = new ArrayList<Double>();
        double[] range = this.getSynth().getDoublePropertyRange("synth.sample-rate");
        double[] values = new double[]{22050.0, 44100.0, 48000.0, 88200.0, 96000.0};
        if (range.length == 2 && range[0] < range[1]) {
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] >= range[0]) || !(values[i] <= range[1])) continue;
                options.add(new Double(values[i]));
            }
        }
        return options;
    }

    protected void fillAudioDriverCombo(List<String> options, Combo combo) {
        int selectedIndex = 0;
        String selectedValue = this.getStringValue("audio.driver");
        for (int i = 0; i < options.size(); ++i) {
            String currentValue = options.get(i);
            combo.add(currentValue);
            if (selectedValue == null || !selectedValue.equals(currentValue)) continue;
            selectedIndex = i;
        }
        combo.select(selectedIndex);
    }

    protected void fillAudioSampleFormatCombo(List<String> options, Combo combo) {
        int selectedIndex = 0;
        String selectedValue = this.getStringValue("audio.sample-format");
        for (int i = 0; i < options.size(); ++i) {
            String currentValue = options.get(i);
            combo.add(currentValue);
            if (selectedValue == null || !selectedValue.equals(currentValue)) continue;
            selectedIndex = i;
        }
        combo.select(selectedIndex);
    }

    protected void fillAudioPeriodSizeCombo(List<Integer> options, Combo combo) {
        int selectedIndex = 0;
        int selectedValue = this.getIntegerValue("audio.period-size");
        for (int i = 0; i < options.size(); ++i) {
            int currentValue = options.get(i);
            combo.add(Integer.toString(currentValue));
            if (selectedValue != currentValue) continue;
            selectedIndex = i;
        }
        combo.select(selectedIndex);
    }

    protected void fillAudioPeriodCountCombo(List<Integer> options, Combo combo) {
        int selectedIndex = 0;
        int selectedValue = this.getIntegerValue("audio.periods");
        for (int i = 0; i < options.size(); ++i) {
            int currentValue = options.get(i);
            combo.add(Integer.toString(currentValue));
            if (selectedValue != currentValue) continue;
            selectedIndex = i;
        }
        combo.select(selectedIndex);
    }

    protected void fillSynthGainScale(Scale scale) {
        double[] range = this.getSynth().getDoublePropertyRange("synth.gain");
        if (range.length == 2) {
            int maximum;
            int value = (int)Math.round(this.getDoubleValue("synth.gain") * 10.0);
            int minimum = (int)Math.round(range[0] * 10.0);
            if (minimum < (maximum = (int)Math.round(range[1] * 10.0))) {
                scale.setMinimum(minimum);
                scale.setMaximum(maximum);
                scale.setIncrement(1);
                scale.setPageIncrement(10);
                if (value >= minimum && value <= maximum) {
                    scale.setSelection(value);
                }
            }
        }
    }

    protected void fillSynthSampleRateCombo(List<Double> options, Combo combo) {
        int selectedIndex = 0;
        double selectedValue = this.getDoubleValue("synth.sample-rate");
        for (int i = 0; i < options.size(); ++i) {
            double currentValue = options.get(i);
            combo.add(Double.toString(currentValue));
            if (selectedValue != currentValue) continue;
            selectedIndex = i;
        }
        combo.select(selectedIndex);
    }

    protected void fillSynthPolyphonySpinner(Spinner spinner) {
        int value = this.getIntegerValue("synth.polyphony");
        int[] range = this.getSynth().getIntegerPropertyRange("synth.polyphony");
        if (range.length == 2 && range[0] < range[1]) {
            spinner.setMinimum(range[0]);
            spinner.setMaximum(range[1]);
            spinner.setIncrement(1);
            spinner.setPageIncrement(1);
            if (value >= range[0] && value <= range[1]) {
                spinner.setSelection(value);
            }
        }
    }

    protected void fillSynthReverbActiveCheckbox(Button button) {
        button.setSelection(this.getBooleanValue("synth.reverb.active"));
    }

    protected void fillSynthChorusActiveCheckbox(Button button) {
        button.setSelection(this.getBooleanValue("synth.chorus.active"));
    }

    protected void updateAudioDriverSelection(List<String> options, int index) {
        if (index >= 0 && index < options.size()) {
            this.setStringValue("audio.driver", options.get(index));
        }
    }

    protected void updateAudioSampleFormatSelection(List<String> options, int index) {
        if (index >= 0 && index < options.size()) {
            this.setStringValue("audio.sample-format", options.get(index));
        }
    }

    protected void updateAudioPeriodSizeSelection(List<Integer> options, int index) {
        if (index >= 0 && index < options.size()) {
            this.setIntegerValue("audio.period-size", options.get(index));
        }
    }

    protected void updateAudioPeriodCountSelection(List<Integer> options, int index) {
        if (index >= 0 && index < options.size()) {
            this.setIntegerValue("audio.periods", options.get(index));
        }
    }

    protected void updateSynthGainSelection(int value) {
        int maximum;
        int minimum;
        double doubleValue = (double)value / 10.0;
        double[] range = this.getSynth().getDoublePropertyRange("synth.gain");
        if (range.length == 2 && (minimum = (int)Math.round(range[0])) < (maximum = (int)Math.round(range[1])) && doubleValue >= (double)minimum && doubleValue <= (double)maximum) {
            this.setDoubleValue("synth.gain", doubleValue);
        }
    }

    protected void updateSynthSampleRateSelection(List<Double> options, int index) {
        if (index >= 0 && index < options.size()) {
            this.setDoubleValue("synth.sample-rate", options.get(index));
        }
    }

    protected void updateSynthPolyphonySelection(int value) {
        int[] range = this.getSynth().getIntegerPropertyRange("synth.polyphony");
        if (range.length == 2 && range[0] < range[1] && value >= range[0] && value <= range[1] && value >= range[0] && value <= range[1]) {
            this.setIntegerValue("synth.polyphony", value);
        }
    }

    protected void updateSynthReverbActiveSelection(boolean value) {
        this.setBooleanValue("synth.reverb.active", value);
    }

    protected void updateSynthChorusActiveSelection(boolean value) {
        this.setBooleanValue("synth.chorus.active", value);
    }

    protected void updateSoundfontsSelection(Table table) {
        ArrayList<String> soundfonts = new ArrayList<String>();
        int count = table.getItemCount();
        for (int i = 0; i < count; ++i) {
            TableItem item = table.getItem(i);
            if (!(item.getData() instanceof String)) continue;
            soundfonts.add((String)item.getData());
        }
        this.setSoundfonts(soundfonts);
    }

    protected void update() {
        this.save();
        this.apply();
    }
}

