/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.utils;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.util.TGFileChooser;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.app.view.dialog.file.TGFileChooserDialog;
import org.herac.tuxguitar.app.view.dialog.file.TGFileChooserHandler;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.configuration.TGConfigManager;

public class MidiConfigUtils {
    public static final String SOUNDBANK_KEY = "soundbank.custom.path";

    public static TGConfigManager getConfig(TGContext context) {
        return new TGConfigManager(context, "tuxguitar-jsa");
    }

    public static String getSoundbankPath(TGContext context) {
        return MidiConfigUtils.getSoundbankPath(MidiConfigUtils.getConfig(context));
    }

    public static String getSoundbankPath(TGConfigManager config) {
        return config.getStringValue(SOUNDBANK_KEY);
    }

    public static void setupDialog(TGContext context, Shell parent) {
        MidiConfigUtils.setupDialog(context, parent, MidiConfigUtils.getConfig(context));
    }

    public static void setupDialog(final TGContext context, Shell parent, final TGConfigManager config) {
        final String soundbank = MidiConfigUtils.getSoundbankPath(config);
        final Shell dialog = DialogUtils.newDialog((Shell)parent, (int)67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty((String)"jsa.settings.title"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"jsa.settings.soundbank.tip"));
        Button sbDefault = new Button((Composite)group, 16);
        sbDefault.setText(TuxGuitar.getProperty((String)"jsa.settings.soundbank.default"));
        sbDefault.setSelection(soundbank == null);
        final Button sbCustom = new Button((Composite)group, 16);
        sbCustom.setText(TuxGuitar.getProperty((String)"jsa.settings.soundbank.custom"));
        sbCustom.setSelection(soundbank != null);
        Composite chooser = new Composite((Composite)group, 0);
        chooser.setLayout((Layout)new GridLayout(2, false));
        final Text sbCustomPath = new Text(chooser, 2048);
        sbCustomPath.setLayoutData((Object)new GridData(350, -1));
        sbCustomPath.setText(soundbank == null ? new String() : soundbank);
        Button sbCustomChooser = new Button(chooser, 8);
        sbCustomChooser.setImage(TuxGuitar.getInstance().getIconManager().getFileOpen());
        sbCustomChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGFileChooser.getInstance((TGContext)context).openChooser(new TGFileChooserHandler(){

                    public void updateFileName(String fileName) {
                        sbCustomPath.setText(fileName);
                    }
                }, TGFileChooser.ALL_FORMATS, TGFileChooserDialog.STYLE_OPEN);
            }
        });
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setLayoutData((Object)data);
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String selection = sbCustom.getSelection() ? sbCustomPath.getText() : null;
                boolean changed = false;
                changed = selection == null && soundbank != null;
                changed = changed || selection != null && soundbank == null;
                boolean bl = changed = changed || selection != null && !selection.equals(soundbank);
                if (changed) {
                    if (selection != null) {
                        config.setValue(MidiConfigUtils.SOUNDBANK_KEY, selection);
                    } else {
                        config.remove(MidiConfigUtils.SOUNDBANK_KEY);
                    }
                    config.save();
                    TGMessageDialogUtil.infoMessage((TGContext)context, (String)TuxGuitar.getProperty((String)"warning"), (String)TuxGuitar.getProperty((String)"jsa.settings.soundbank-restart-message"));
                }
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.setLayoutData((Object)data);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog((Shell)dialog, (int)11);
    }
}

