/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.custom.tuner;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.app.graphics.TGColorImpl;
import org.herac.tuxguitar.app.graphics.TGPainterImpl;
import org.herac.tuxguitar.graphics.TGColor;

public class TGTunerRoughWidget
extends Composite {
    private static final int MIN_HEIGHT = 25;
    protected Composite composite = null;
    protected float currentFrequency = 0.0f;
    private final int startA = 20;
    private final int endAb = 20;
    private final int boundaryHeight = 16;
    private final int markerHeight = 12;
    private final int markerWidth = 4;
    static String[] TONESSTRING = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};

    public TGTunerRoughWidget(Composite parent) {
        super(parent, 0);
        this.init();
    }

    public void init() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.setLayoutData(new GridData(4, 4, true, true));
        ((GridData)this.getLayoutData()).widthHint = 600;
        this.composite = new Composite((Composite)this, 0x20000800);
        this.composite.setBackground(this.getDisplay().getSystemColor(1));
        this.composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TGPainterImpl painter = new TGPainterImpl(e.gc);
                TGTunerRoughWidget.this.paintWidget(painter);
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 25;
        data.grabExcessHorizontalSpace = true;
        this.composite.setLayoutData((Object)data);
    }

    private void paintWidget(TGPainterImpl painter) {
        Point compositeSize = this.composite.getSize();
        painter.setForeground((TGColor)new TGColorImpl(this.getDisplay().getSystemColor(2)));
        painter.initPath();
        ((Object)((Object)this)).getClass();
        painter.moveTo(20.0f, (float)(compositeSize.y / 2));
        int n = compositeSize.x;
        ((Object)((Object)this)).getClass();
        painter.lineTo((float)(n - 20), (float)(compositeSize.y / 2));
        painter.closePath();
        int n2 = compositeSize.x;
        ((Object)((Object)this)).getClass();
        int n3 = n2 - 20;
        ((Object)((Object)this)).getClass();
        int increment = (int)Math.round((double)(n3 - 20) / 12.0);
        int currentTone = 0;
        ((Object)((Object)this)).getClass();
        int i = 20;
        while (true) {
            int n4 = compositeSize.x + 1;
            ((Object)((Object)this)).getClass();
            if (i >= n4 - 20) break;
            painter.initPath();
            painter.moveTo((float)i, (float)(compositeSize.y / 2 - this.boundaryHeight / 2));
            painter.lineTo((float)i, (float)(compositeSize.y / 2 + this.boundaryHeight / 2));
            painter.closePath();
            painter.drawString(TONESSTRING[currentTone % 12], (float)i, (float)(compositeSize.y / 2 - this.boundaryHeight / 2 - 20));
            ++currentTone;
            i += increment;
        }
        if (this.currentFrequency > 0.0f) {
            painter.setForeground((TGColor)new TGColorImpl(this.getDisplay().getSystemColor(9)));
            painter.initPath();
            int n5 = this.markerWidth / 2;
            ((Object)((Object)this)).getClass();
            int n6 = n5 + 20;
            int n7 = compositeSize.x;
            ((Object)((Object)this)).getClass();
            int n8 = n7 - 20;
            ((Object)((Object)this)).getClass();
            int markerPos = n6 + (int)Math.round((double)(n8 - 20) / 240.0 * (double)this.getTone(this.currentFrequency));
            painter.moveTo((float)markerPos, (float)(compositeSize.y / 2 - this.markerHeight / 2));
            ((Object)((Object)this)).getClass();
            painter.setLineWidth(4.0f);
            painter.lineTo((float)markerPos, (float)(compositeSize.y / 2 + this.markerHeight / 2));
            painter.closePath();
        }
    }

    public void setCurrentFrequency(double currentFrequency) {
        this.currentFrequency = (float)currentFrequency;
        this.redraw();
    }

    public void redraw() {
        super.redraw();
        this.composite.redraw();
    }

    protected int getTone(float frequency) {
        float midiTone = (float)(45.0 + 12.0 * (Math.log(frequency / 110.0f) / Math.log(2.0)));
        return Math.round(20.0f * (midiTone % 12.0f));
    }
}

