/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.pdf;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.graphics.TGFontModel;
import org.herac.tuxguitar.graphics.TGResourceFactory;
import org.herac.tuxguitar.graphics.control.TGController;
import org.herac.tuxguitar.graphics.control.TGLayoutStyles;
import org.herac.tuxguitar.graphics.control.TGResourceBuffer;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;

public class PDFController
implements TGController {
    private static final int DEFAULT_SCORE_LINE_SPACING = 7;
    private static final int DEFAULT_STRING_SPACING = 8;
    private static final int DEFAULT_HORIZONTAL_SPACING = 15;
    private static final int MIN_SCORE_TAB_SPACING = 15;
    private static final int DEFAULT_TRACK_SPACING = 5;
    private static final int DEFAULT_FIRST_TRACK_SPACING = 5;
    private static final int DEFAULT_MIN_BUFFER_SEPARATOR = 15;
    private static final int DEFAULT_MIN_TOP_SPACING = 20;
    private static final int CHORD_FRET_INDEX_SPACING = 8;
    private static final int CHORD_STRING_SPACING = 4;
    private static final int CHORD_FRET_SPACING = 5;
    private TGSong song;
    private TGSongManager songManager;
    private TGResourceFactory resourceFactory;
    private TGResourceBuffer resourceBuffer;

    public PDFController(TGSong song, TGSongManager songManager, TGResourceFactory resourceFactory) {
        this.song = song;
        this.songManager = songManager;
        this.resourceFactory = resourceFactory;
        this.resourceBuffer = new TGResourceBuffer();
    }

    public TGSong getSong() {
        return this.song;
    }

    public TGSongManager getSongManager() {
        return this.songManager;
    }

    public TGResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public TGResourceBuffer getResourceBuffer() {
        return this.resourceBuffer;
    }

    public int getTrackSelection() {
        return -1;
    }

    public boolean isRunning(TGBeat beat) {
        return false;
    }

    public boolean isRunning(TGMeasure measure) {
        return false;
    }

    public boolean isLoopSHeader(TGMeasureHeader measureHeader) {
        return false;
    }

    public boolean isLoopEHeader(TGMeasureHeader measureHeader) {
        return false;
    }

    public void configureStyles(TGLayoutStyles styles) {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        styles.setBufferEnabled(false);
        styles.setFirstMeasureSpacing(15.0f);
        styles.setMinBufferSeparator(15.0f);
        styles.setMinTopSpacing(20.0f);
        styles.setMinScoreTabSpacing(15.0f);
        styles.setScoreLineSpacing(7.0f);
        styles.setFirstTrackSpacing(5.0f);
        styles.setTrackSpacing(5.0f);
        styles.setStringSpacing(8.0f);
        styles.setChordFretIndexSpacing(8.0f);
        styles.setChordStringSpacing(4.0f);
        styles.setChordFretSpacing(5.0f);
        styles.setChordNoteSize(3.0f);
        styles.setChordLineWidth(1.0f);
        styles.setRepeatEndingSpacing(20.0f);
        styles.setTextSpacing(15.0f);
        styles.setMarkerSpacing(15.0f);
        styles.setDivisionTypeSpacing(10.0f);
        styles.setEffectSpacing(8.0f);
        styles.setDefaultFont(new TGFontModel("Times-Roman", 8.0f, false, false));
        styles.setNoteFont(new TGFontModel("Times-Bold", 9.0f, true, false));
        styles.setTimeSignatureFont(new TGFontModel("Times-Bold", 15.0f, true, false));
        styles.setLyricFont(new TGFontModel("Times-Roman", 8.0f, false, false));
        styles.setTextFont(new TGFontModel("Times-Roman", 8.0f, false, false));
        styles.setGraceFont(new TGFontModel("Times-Roman", 8.0f, false, false));
        styles.setChordFont(new TGFontModel("Times-Roman", 8.0f, false, false));
        styles.setChordFretFont(new TGFontModel("Times-Roman", 8.0f, false, false));
        styles.setMarkerFont(new TGFontModel("Times-Roman", 8.0f, false, false));
        styles.setBackgroundColor(config.getColorModelConfigValue("color.background"));
        styles.setLineColor(config.getColorModelConfigValue("color.line"));
        styles.setScoreNoteColor(config.getColorModelConfigValue("color.score.note"));
        styles.setTabNoteColor(config.getColorModelConfigValue("color.tab.note"));
        styles.setPlayNoteColor(config.getColorModelConfigValue("color.play.note"));
        styles.setLoopSMarkerColor(config.getColorModelConfigValue("color.loop.s.marker"));
        styles.setLoopEMarkerColor(config.getColorModelConfigValue("color.loop.e.marker"));
    }
}

