/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.io;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.community.TGCommunitySingleton;
import org.herac.tuxguitar.community.auth.TGCommunityAuthDialog;
import org.herac.tuxguitar.community.io.TGShareFile;
import org.herac.tuxguitar.util.TGContext;

public class TGShareFileDialog {
    private TGContext context;
    private TGShareFile file;
    private String errors;
    private boolean accepted;

    public TGShareFileDialog(TGContext context, TGShareFile file, String errors) {
        this.context = context;
        this.file = file;
        this.errors = errors;
        this.accepted = false;
    }

    public void open() {
        this.open(TuxGuitar.getInstance().getShell());
    }

    protected void open(Shell shell) {
        this.accepted = false;
        final Shell dialog = DialogUtils.newDialog((Shell)shell, (int)67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setLayoutData((Object)new GridData(4, 4, true, true));
        dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        dialog.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.title"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)this.makeGroupLayout(5));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.details"));
        Label usernameLabel = new Label((Composite)group, 0);
        usernameLabel.setLayoutData((Object)this.makeLabelData());
        usernameLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.details.user") + ":");
        final Text usernameText = new Text((Composite)group, 2056);
        usernameText.setLayoutData((Object)this.makeUsernameTextData());
        usernameText.setText(TGCommunitySingleton.getInstance(this.getContext()).getAuth().getUsername());
        Button usernameChooser = new Button((Composite)group, 8);
        usernameChooser.setText("...");
        usernameChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGCommunityAuthDialog authDialog = new TGCommunityAuthDialog(TGShareFileDialog.this.getContext());
                authDialog.open(dialog);
                if (authDialog.isAccepted()) {
                    TGCommunitySingleton.getInstance(TGShareFileDialog.this.getContext()).getAuth().update();
                    usernameText.setText(TGCommunitySingleton.getInstance(TGShareFileDialog.this.getContext()).getAuth().getUsername());
                }
            }
        });
        Label titleLabel = new Label((Composite)group, 0);
        titleLabel.setLayoutData((Object)this.makeLabelData());
        titleLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.details.title") + ":");
        final Text titleText = new Text((Composite)group, 2048);
        titleText.setLayoutData((Object)this.makeTextData());
        titleText.setText(this.file.getTitle());
        Label tagkeysLabel = new Label((Composite)group, 0);
        tagkeysLabel.setLayoutData((Object)this.makeLabelData());
        tagkeysLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.details.tagkeys") + ":");
        final Text tagkeysText = new Text((Composite)group, 2048);
        tagkeysText.setLayoutData((Object)this.makeTextData());
        tagkeysText.setText(this.file.getTagkeys());
        Label descriptionLabel = new Label((Composite)group, 0);
        descriptionLabel.setLayoutData((Object)this.makeLabelData());
        descriptionLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.details.description") + ":");
        final Text descriptionText = new Text((Composite)group, 2626);
        descriptionText.setLayoutData((Object)this.makeTextAreaData());
        descriptionText.setText(this.file.getDescription());
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGShareFileDialog.this.update(titleText.getText(), tagkeysText.getText(), descriptionText.getText());
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        if (this.errors != null) {
            TGMessageDialogUtil.errorMessage((TGContext)this.context, (Shell)dialog, (String)this.errors);
        }
        DialogUtils.openDialog((Shell)dialog, (int)11);
    }

    private GridLayout makeGroupLayout(int spacing) {
        GridLayout layout = new GridLayout(3, false);
        layout.marginTop = spacing;
        layout.marginBottom = spacing;
        layout.marginLeft = spacing;
        layout.marginRight = spacing;
        layout.verticalSpacing = spacing;
        layout.horizontalSpacing = spacing;
        return layout;
    }

    private GridData makeLabelData() {
        return new GridData(131072, 0x1000000, false, true);
    }

    private GridData makeTextAreaData() {
        GridData data = new GridData(4, 4, true, true, 2, 1);
        data.minimumWidth = 250;
        data.minimumHeight = 100;
        return data;
    }

    private GridData makeTextData() {
        GridData data = new GridData(4, 4, true, true, 2, 1);
        data.minimumWidth = 250;
        return data;
    }

    private GridData makeUsernameTextData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 250;
        return data;
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    protected void update(String title, String tagkeys, String description) {
        this.file.setTitle(title);
        this.file.setTagkeys(tagkeys);
        this.file.setDescription(description);
        this.accepted = true;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public TGContext getContext() {
        return this.context;
    }
}

