/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.oss;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.player.impl.midiport.oss.MidiOutputPortProviderImpl;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.configuration.TGConfigManager;

public class MidiConfigUtils {
    public static final String DEVICE_KEY = "oss.device";
    public static final String DEVICE_DEFAULT = "/dev/sequencer";

    public static TGConfigManager getConfig(TGContext context) {
        return new TGConfigManager(context, "tuxguitar-oss");
    }

    public static String getDevice(TGContext context) {
        return MidiConfigUtils.getDevice(MidiConfigUtils.getConfig(context));
    }

    public static String getDevice(TGConfigManager config) {
        return config.getStringValue(DEVICE_KEY, DEVICE_DEFAULT);
    }

    public static void setupDialog(TGContext context, Shell parent, MidiOutputPortProviderImpl provider) {
        MidiConfigUtils.setupDialog(parent, provider, MidiConfigUtils.getConfig(context));
    }

    public static void setupDialog(Shell parent, final MidiOutputPortProviderImpl provider, final TGConfigManager config) {
        final String device = MidiConfigUtils.getDevice(config);
        final Shell dialog = DialogUtils.newDialog((Shell)parent, (int)67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText("Configuration");
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText("Device Configuration");
        Label deviceLabel = new Label((Composite)group, 16384);
        deviceLabel.setText("Device:");
        final Text deviceValue = new Text((Composite)group, 2048);
        deviceValue.setLayoutData((Object)new GridData(250, -1));
        deviceValue.setText(device == null ? new String() : device);
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setLayoutData((Object)data);
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String value2;
                String selection = deviceValue.getText();
                String value1 = device == null ? new String() : device;
                String string = value2 = selection == null ? new String() : selection;
                if (!value1.equals(value2)) {
                    if (selection != null) {
                        config.setValue(MidiConfigUtils.DEVICE_KEY, selection);
                    } else {
                        config.remove(MidiConfigUtils.DEVICE_KEY);
                    }
                    config.save();
                    provider.updateDevice(selection);
                }
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.setLayoutData((Object)data);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog((Shell)dialog, (int)11);
    }
}

