/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.synthesizer;

import org.herac.tuxguitar.gm.port.GMReceiver;
import org.herac.tuxguitar.jack.JackClient;
import org.herac.tuxguitar.jack.JackPort;

public class JackGmReceiver
implements GMReceiver {
    private JackClient jackClient;
    private JackPort jackPort;

    public JackGmReceiver(JackClient jackClient, JackPort jackPort) {
        this.jackClient = jackClient;
        this.jackPort = jackPort;
    }

    public void sendAllNotesOff() {
        for (int i = 0; i < 16; ++i) {
            this.sendControlChange(i, 123, 0);
        }
    }

    public void sendNoteOn(int channel, int key, int velocity) {
        byte[] event = new byte[]{(byte)(0x90 | channel), (byte)key, (byte)velocity};
        this.jackClient.addEventToQueue(this.jackPort, event);
    }

    public void sendNoteOff(int channel, int key, int velocity) {
        byte[] event = new byte[]{(byte)(0x80 | channel), (byte)key, (byte)velocity};
        this.jackClient.addEventToQueue(this.jackPort, event);
    }

    public void sendPitchBend(int channel, int value) {
        byte[] event = new byte[]{(byte)(0xE0 | channel), 0, (byte)value};
        this.jackClient.addEventToQueue(this.jackPort, event);
    }

    public void sendProgramChange(int channel, int value) {
        byte[] event = new byte[]{(byte)(0xC0 | channel), (byte)value};
        this.jackClient.addEventToQueue(this.jackPort, event);
    }

    public void sendControlChange(int channel, int controller, int value) {
        byte[] event = new byte[]{(byte)(0xB0 | channel), (byte)controller, (byte)value};
        this.jackClient.addEventToQueue(this.jackPort, event);
    }

    public void sendSystemReset() {
    }
}

