/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.track;

import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.track.TGUndoableTrackBase;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableTrackGeneric
extends TGUndoableTrackBase {
    private int doAction;
    private TGTrack undoTrack;
    private TGTrack redoTrack;

    private TGUndoableTrackGeneric(TGContext context) {
        super(context);
    }

    public void redo() throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.copyTrackFrom(this.getSong(), this.getTrack(this.redoTrack.getNumber()), this.redoTrack);
        this.doAction = 1;
    }

    public void undo() throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.copyTrackFrom(this.getSong(), this.getTrack(this.undoTrack.getNumber()), this.undoTrack);
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableTrackGeneric startUndo(TGContext context, TGTrack track) {
        TGUndoableTrackGeneric undoable = new TGUndoableTrackGeneric(context);
        undoable.doAction = 1;
        undoable.undoTrack = track.clone(new TGFactory(), TGUndoableTrackGeneric.getSong(context));
        return undoable;
    }

    public TGUndoableTrackGeneric endUndo(TGTrack track) {
        this.redoTrack = track.clone(new TGFactory(), this.getSong());
        return this;
    }

    public TGTrack getTrack(int number) {
        return this.getSongManager().getTrack(this.getSong(), number);
    }
}

