/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.track;

import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGLyric;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public abstract class TGUndoableTrackBase
extends TGUndoableEditBase {
    protected TGUndoableTrackBase(TGContext context) {
        super(context);
    }

    public void addTrack(TGSong song, TGTrack track) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.add");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        this.processByPassUndoableAction(tgActionProcessor);
    }

    public void removeTrack(TGSong song, TGTrack track) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.remove");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        this.processByPassUndoableAction(tgActionProcessor);
    }

    public void cloneTrack(TGSong song, TGTrack track) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.clone");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        this.processByPassUndoableAction(tgActionProcessor);
    }

    public void moveTrackUp(TGSong song, TGTrack track) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.move-up");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        this.processByPassUndoableAction(tgActionProcessor);
    }

    public void moveTrackDown(TGSong song, TGTrack track) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.move-down");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        this.processByPassUndoableAction(tgActionProcessor);
    }

    public void copyTrackFrom(TGSong song, TGTrack track, TGTrack from) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.copy.from");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        tgActionProcessor.setAttribute("from", from);
        this.processByPassUndoableAction(tgActionProcessor);
    }

    public void setTrackSolo(TGTrack track, Boolean solo) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.set-solo");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        tgActionProcessor.setAttribute("solo", solo);
        this.processByPassUndoableAction(tgActionProcessor);
    }

    public void setTrackMute(TGTrack track, Boolean mute) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.set-mute");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        tgActionProcessor.setAttribute("mute", mute);
        this.processByPassUndoableAction(tgActionProcessor);
    }

    public void setTrackInfo(TGTrack track, String name, Integer offset, TGColor color) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.set-info");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        tgActionProcessor.setAttribute("name", name);
        tgActionProcessor.setAttribute("offset", offset);
        tgActionProcessor.setAttribute("color", color);
        this.processByPassUndoableAction(tgActionProcessor);
    }

    public void setTrackChannel(TGTrack track, TGChannel channel) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.set-channel");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHANNEL, channel);
        this.processByPassUndoableAction(tgActionProcessor);
    }

    public void setTrackLyrics(TGTrack track, TGLyric lyrics) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.set-lyric");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_LYRIC, lyrics);
        this.processByPassUndoableAction(tgActionProcessor);
    }
}

