/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.custom;

import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableOpenRepeat
extends TGUndoableEditBase {
    private int doAction;
    private long position;

    private TGUndoableOpenRepeat(TGContext context) {
        super(context);
    }

    public void redo() throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.changeOpenRepeat(this.getMeasureHeaderAt(this.position));
        this.doAction = 1;
    }

    public void undo() throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.changeOpenRepeat(this.getMeasureHeaderAt(this.position));
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableOpenRepeat startUndo(TGContext context, TGMeasureHeader header) {
        TGUndoableOpenRepeat undoable = new TGUndoableOpenRepeat(context);
        undoable.doAction = 1;
        undoable.position = header.getStart();
        return undoable;
    }

    public TGUndoableOpenRepeat endUndo() {
        return this;
    }

    public TGMeasureHeader getMeasureHeaderAt(Long start) {
        return this.getSongManager().getMeasureHeaderAt(this.getSong(), start.longValue());
    }

    public void changeOpenRepeat(TGMeasureHeader header) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.insert.open-repeat");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, header);
        this.processByPassUndoableAction(tgActionProcessor);
    }
}

