/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.custom;

import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableAltRepeat
extends TGUndoableEditBase {
    private int doAction;
    private long position;
    private int undoRepeatAlternative;
    private int redoRepeatAlternative;

    private TGUndoableAltRepeat(TGContext context) {
        super(context);
    }

    public void redo() throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.changeAlternativeRepeat(this.getMeasureHeaderAt(this.position), this.redoRepeatAlternative);
        this.doAction = 1;
    }

    public void undo() throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.changeAlternativeRepeat(this.getMeasureHeaderAt(this.position), this.undoRepeatAlternative);
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableAltRepeat startUndo(TGContext context, TGMeasureHeader header) {
        TGUndoableAltRepeat undoable = new TGUndoableAltRepeat(context);
        undoable.doAction = 1;
        undoable.position = header.getStart();
        undoable.undoRepeatAlternative = header.getRepeatAlternative();
        return undoable;
    }

    public TGUndoableAltRepeat endUndo(int redoRepeatAlternative) {
        this.redoRepeatAlternative = redoRepeatAlternative;
        return this;
    }

    public TGMeasureHeader getMeasureHeaderAt(Long start) {
        return this.getSongManager().getMeasureHeaderAt(this.getSong(), start.longValue());
    }

    public void changeAlternativeRepeat(TGMeasureHeader header, Integer repeatAlternative) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.insert.close-alternative");
        tgActionProcessor.setAttribute("repeatAlternative", repeatAlternative);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, header);
        this.processByPassUndoableAction(tgActionProcessor);
    }
}

