/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.action.channel;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class TGUpdateChannelAction
extends TGActionBase {
    public static final String NAME = "action.channel.update";
    public static final String ATTRIBUTE_BANK = "bank";
    public static final String ATTRIBUTE_PROGRAM = "program";
    public static final String ATTRIBUTE_VOLUME = "volume";
    public static final String ATTRIBUTE_BALANCE = "balance";
    public static final String ATTRIBUTE_CHORUS = "chorus";
    public static final String ATTRIBUTE_REVERB = "reverb";
    public static final String ATTRIBUTE_PHASER = "phaser";
    public static final String ATTRIBUTE_TREMOLO = "tremolo";
    public static final String ATTRIBUTE_NAME = "name";

    public TGUpdateChannelAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        TGChannel channel = (TGChannel)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHANNEL);
        short bank = (Short)this.findAttribute(context, ATTRIBUTE_BANK, channel.getBank());
        short program = (Short)this.findAttribute(context, ATTRIBUTE_PROGRAM, channel.getProgram());
        short volume = (Short)this.findAttribute(context, ATTRIBUTE_VOLUME, channel.getVolume());
        short balance = (Short)this.findAttribute(context, ATTRIBUTE_BALANCE, channel.getBalance());
        short chorus = (Short)this.findAttribute(context, ATTRIBUTE_CHORUS, channel.getChorus());
        short reverb = (Short)this.findAttribute(context, ATTRIBUTE_REVERB, channel.getReverb());
        short phaser = (Short)this.findAttribute(context, ATTRIBUTE_PHASER, channel.getPhaser());
        short tremolo = (Short)this.findAttribute(context, ATTRIBUTE_TREMOLO, channel.getTremolo());
        String name = (String)this.findAttribute(context, ATTRIBUTE_NAME, channel.getName());
        this.getSongManager(context).updateChannel(song, channel.getChannelId(), bank, program, volume, balance, chorus, reverb, phaser, tremolo, name);
    }

    private Object findAttribute(TGActionContext context, String attribute, Object defaultValue) {
        Object value = context.getAttribute(attribute);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

