/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor;

import org.herac.tuxguitar.editor.event.TGRedrawEvent;
import org.herac.tuxguitar.editor.event.TGUpdateEvent;
import org.herac.tuxguitar.editor.event.TGUpdateMeasureEvent;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.event.TGEventManager;
import org.herac.tuxguitar.util.TGAbstractContext;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGLock;
import org.herac.tuxguitar.util.error.TGErrorManager;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGEditorManager {
    private TGContext context;
    private TGLock lockControl;

    public TGEditorManager(TGContext context) {
        this.context = context;
    }

    public void setLockControl(TGLock lockControl) {
        this.lockControl = lockControl;
    }

    public TGLock getLockControl() {
        return this.lockControl;
    }

    public void redraw() {
        this.redraw(null);
    }

    public void redraw(final TGAbstractContext sourceContext) {
        this.asyncRunLocked(new Runnable(){

            public void run() {
                TGEditorManager.this.doRedraw(1, sourceContext);
            }
        });
    }

    public void redrawPlayingThread() {
        this.redrawPlayingThread(null);
    }

    public void redrawPlayingThread(final TGAbstractContext sourceContext) {
        this.asyncRunLocked(new Runnable(){

            public void run() {
                TGEditorManager.this.doRedraw(2, sourceContext);
            }
        });
    }

    public void redrawPlayingNewBeat() {
        this.redrawPlayingNewBeat(null);
    }

    public void redrawPlayingNewBeat(final TGAbstractContext sourceContext) {
        this.asyncRunLocked(new Runnable(){

            public void run() {
                TGEditorManager.this.doRedraw(3, sourceContext);
            }
        });
    }

    public void updateSelection() {
        this.updateSelection(null);
    }

    public void updateSelection(final TGAbstractContext sourceContext) {
        this.asyncRunLocked(new Runnable(){

            public void run() {
                TGEditorManager.this.doUpdate(1, sourceContext);
            }
        });
    }

    public void updateMeasure(int number) {
        this.updateMeasure(number, null);
    }

    public void updateMeasure(final int number, final TGAbstractContext sourceContext) {
        this.runLocked(new Runnable(){

            public void run() {
                TGEditorManager.this.doUpdateMeasure(number, sourceContext);
            }
        });
    }

    public void updateSong() {
        this.updateSong(null);
    }

    public void updateSong(final TGAbstractContext sourceContext) {
        this.runLocked(new Runnable(){

            public void run() {
                TGEditorManager.this.doUpdate(3, sourceContext);
            }
        });
    }

    public void updateSavedSong() {
        this.updateSavedSong(null);
    }

    public void updateSavedSong(final TGAbstractContext sourceContext) {
        this.runLocked(new Runnable(){

            public void run() {
                TGEditorManager.this.doUpdate(5, sourceContext);
            }
        });
    }

    public void updateLoadedSong() {
        this.updateLoadedSong(null);
    }

    public void updateLoadedSong(final TGAbstractContext context) {
        this.runLocked(new Runnable(){

            public void run() {
                TGEditorManager.this.doUpdate(4, context);
            }
        });
    }

    public void addRedrawListener(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).addListener("ui-redraw", listener);
    }

    public void removeRedrawListener(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).removeListener("ui-redraw", listener);
    }

    public void addUpdateListener(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).addListener("ui-update", listener);
    }

    public void removeUpdateListener(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).removeListener("ui-update", listener);
    }

    private void doRedraw(int type, TGAbstractContext context) {
        TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new TGRedrawEvent(type, context));
    }

    private void doUpdate(int type, TGAbstractContext context) {
        TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new TGUpdateEvent(type, context));
    }

    private void doUpdateMeasure(int number, TGAbstractContext context) {
        TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new TGUpdateMeasureEvent(number, context));
    }

    public void lock() {
        if (this.lockControl != null) {
            this.lockControl.lock();
        }
    }

    public boolean tryLock() {
        if (this.lockControl != null) {
            return this.lockControl.tryLock();
        }
        return true;
    }

    public void unlock() {
        if (this.lockControl != null) {
            this.lockControl.unlock();
        }
    }

    public boolean isLocked() {
        if (this.lockControl != null) {
            return this.lockControl.isLocked();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runLocked(Runnable runnable) {
        this.lock();
        try {
            runnable.run();
        }
        finally {
            this.unlock();
        }
    }

    public void asyncRunLocked(final Runnable runnable) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    TGEditorManager.this.runLocked(runnable);
                }
                catch (Throwable throwable) {
                    TGErrorManager.getInstance((TGContext)TGEditorManager.this.context).handleError(throwable);
                }
            }
        }).start();
    }

    public static TGEditorManager getInstance(TGContext context) {
        return (TGEditorManager)TGSingletonUtil.getInstance((TGContext)context, (String)TGEditorManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGEditorManager>(){

            public TGEditorManager createInstance(TGContext context) {
                return new TGEditorManager(context);
            }
        });
    }
}

