/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gpx;

import java.util.List;
import org.herac.tuxguitar.graphics.control.TGNoteImpl;
import org.herac.tuxguitar.io.gpx.score.GPXAutomation;
import org.herac.tuxguitar.io.gpx.score.GPXBar;
import org.herac.tuxguitar.io.gpx.score.GPXBeat;
import org.herac.tuxguitar.io.gpx.score.GPXDocument;
import org.herac.tuxguitar.io.gpx.score.GPXDrumkit;
import org.herac.tuxguitar.io.gpx.score.GPXMasterBar;
import org.herac.tuxguitar.io.gpx.score.GPXNote;
import org.herac.tuxguitar.io.gpx.score.GPXRhythm;
import org.herac.tuxguitar.io.gpx.score.GPXTrack;
import org.herac.tuxguitar.io.gpx.score.GPXVoice;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChannelParameter;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public class GPXDocumentParser {
    private static final float GP_BEND_POSITION = 100.0f;
    private static final float GP_BEND_SEMITONE = 25.0f;
    private static final float GP_WHAMMY_BAR_POSITION = 100.0f;
    private static final float GP_WHAMMY_BAR_SEMITONE = 50.0f;
    private TGFactory factory;
    private GPXDocument document;

    public GPXDocumentParser(TGFactory factory, GPXDocument document) {
        this.factory = factory;
        this.document = document;
    }

    public TGSong parse() {
        TGSong tgSong = this.factory.newSong();
        this.parseScore(tgSong);
        this.parseTracks(tgSong);
        this.parseMasterBars(tgSong);
        return tgSong;
    }

    private void parseScore(TGSong tgSong) {
        tgSong.setName(this.document.getScore().getTitle());
        tgSong.setArtist(this.document.getScore().getArtist());
        tgSong.setAlbum(this.document.getScore().getAlbum());
        tgSong.setAuthor(this.document.getScore().getWordsAndMusic());
        tgSong.setCopyright(this.document.getScore().getCopyright());
        tgSong.setWriter(this.document.getScore().getTabber());
        tgSong.setComments(this.document.getScore().getNotices());
    }

    private void parseTracks(TGSong tgSong) {
        List<GPXTrack> tracks = this.document.getTracks();
        for (int i = 0; i < tracks.size(); ++i) {
            GPXTrack gpTrack = this.document.getTracks().get(i);
            TGChannel tgChannel = this.factory.newChannel();
            tgChannel.setProgram((short)gpTrack.getGmProgram());
            tgChannel.setBank(gpTrack.getGmChannel1() == 9 ? (short)128 : 0);
            TGChannelParameter gmChannel1Param = this.factory.newChannelParameter();
            gmChannel1Param.setKey("gm-channel-1");
            gmChannel1Param.setValue(Integer.toString(gpTrack.getGmChannel1()));
            TGChannelParameter gmChannel2Param = this.factory.newChannelParameter();
            gmChannel2Param.setKey("gm-channel-2");
            gmChannel2Param.setValue(Integer.toString(gpTrack.getGmChannel1() != 9 ? gpTrack.getGmChannel2() : gpTrack.getGmChannel1()));
            for (int c = 0; c < tgSong.countChannels(); ++c) {
                TGChannel tgChannelAux = tgSong.getChannel(c);
                for (int n = 0; n < tgChannelAux.countParameters(); ++n) {
                    TGChannelParameter channelParameter = tgChannelAux.getParameter(n);
                    if (!channelParameter.getKey().equals("gm-channel-1") || !Integer.toString(gpTrack.getGmChannel1()).equals(channelParameter.getValue())) continue;
                    tgChannel.setChannelId(tgChannelAux.getChannelId());
                }
            }
            if (tgChannel.getChannelId() <= 0) {
                tgChannel.setChannelId(tgSong.countChannels() + 1);
                tgChannel.setName("#" + tgChannel.getChannelId());
                tgChannel.addParameter(gmChannel1Param);
                tgChannel.addParameter(gmChannel2Param);
                tgSong.addChannel(tgChannel);
            }
            TGTrack tgTrack = this.factory.newTrack();
            tgTrack.setNumber(i + 1);
            tgTrack.setName(gpTrack.getName());
            tgTrack.setChannelId(tgChannel.getChannelId());
            if (gpTrack.getTunningPitches() != null) {
                for (int s = 1; s <= gpTrack.getTunningPitches().length; ++s) {
                    TGString tgString = this.factory.newString();
                    tgString.setNumber(s);
                    tgString.setValue(gpTrack.getTunningPitches()[gpTrack.getTunningPitches().length - s]);
                    tgTrack.getStrings().add(tgString);
                }
            } else if (tgChannel.isPercussionChannel()) {
                for (int s = 1; s <= 6; ++s) {
                    tgTrack.getStrings().add(TGSongManager.newString((TGFactory)this.factory, (int)s, (int)0));
                }
            } else {
                tgTrack.getStrings().add(TGSongManager.newString((TGFactory)this.factory, (int)1, (int)64));
                tgTrack.getStrings().add(TGSongManager.newString((TGFactory)this.factory, (int)2, (int)59));
                tgTrack.getStrings().add(TGSongManager.newString((TGFactory)this.factory, (int)3, (int)55));
                tgTrack.getStrings().add(TGSongManager.newString((TGFactory)this.factory, (int)4, (int)50));
                tgTrack.getStrings().add(TGSongManager.newString((TGFactory)this.factory, (int)5, (int)45));
                tgTrack.getStrings().add(TGSongManager.newString((TGFactory)this.factory, (int)6, (int)40));
            }
            if (gpTrack.getColor() != null && gpTrack.getColor().length == 3) {
                tgTrack.getColor().setR(gpTrack.getColor()[0]);
                tgTrack.getColor().setG(gpTrack.getColor()[1]);
                tgTrack.getColor().setB(gpTrack.getColor()[2]);
            }
            tgSong.addTrack(tgTrack);
        }
    }

    private void parseMasterBars(TGSong tgSong) {
        long tgStart = 960L;
        List<GPXMasterBar> masterBars = this.document.getMasterBars();
        for (int i = 0; i < masterBars.size(); ++i) {
            GPXMasterBar mbar = masterBars.get(i);
            GPXAutomation gpTempoAutomation = this.document.getAutomation("Tempo", i);
            TGMeasureHeader tgMeasureHeader = this.factory.newHeader();
            tgMeasureHeader.setStart(tgStart);
            tgMeasureHeader.setNumber(i + 1);
            tgMeasureHeader.setRepeatOpen(mbar.isRepeatStart());
            tgMeasureHeader.setRepeatClose(mbar.getRepeatCount());
            tgMeasureHeader.setTripletFeel(this.parseTripletFeel(mbar));
            if (mbar.getTime() != null && mbar.getTime().length == 2) {
                tgMeasureHeader.getTimeSignature().setNumerator(mbar.getTime()[0]);
                tgMeasureHeader.getTimeSignature().getDenominator().setValue(mbar.getTime()[1]);
            }
            if (gpTempoAutomation != null && gpTempoAutomation.getValue().length == 2) {
                int tgTempo = gpTempoAutomation.getValue()[0];
                if (gpTempoAutomation.getValue()[1] == 1) {
                    tgTempo /= 2;
                } else if (gpTempoAutomation.getValue()[1] == 3) {
                    tgTempo += tgTempo / 2;
                } else if (gpTempoAutomation.getValue()[1] == 4) {
                    tgTempo *= 2;
                } else if (gpTempoAutomation.getValue()[1] == 5) {
                    tgTempo += tgTempo * 2;
                }
                tgMeasureHeader.getTempo().setValue(tgTempo);
            }
            tgSong.addMeasureHeader(tgMeasureHeader);
            for (int t = 0; t < tgSong.countTracks(); ++t) {
                GPXBar gpBar;
                TGTrack tgTrack = tgSong.getTrack(t);
                TGMeasure tgMeasure = this.factory.newMeasure(tgMeasureHeader);
                int accidental = mbar.getAccidentalCount();
                if (accidental < 0) {
                    accidental = 7 - accidental;
                }
                if (accidental >= 0 && accidental <= 14) {
                    tgMeasure.setKeySignature(accidental);
                }
                tgTrack.addMeasure(tgMeasure);
                int gpMasterBarIndex = i;
                GPXBar gPXBar = gpBar = t < mbar.getBarIds().length ? this.document.getBar(mbar.getBarIds()[t]) : null;
                while (gpBar != null && gpBar.getSimileMark() != null) {
                    String gpMark = gpBar.getSimileMark();
                    if (gpMark.equals("Simple")) {
                        --gpMasterBarIndex;
                    } else if (gpMark.equals("FirstOfDouble") || gpMark.equals("SecondOfDouble")) {
                        gpMasterBarIndex -= 2;
                    }
                    if (gpMasterBarIndex >= 0) {
                        GPXMasterBar gpMasterBarCopy = masterBars.get(gpMasterBarIndex);
                        gpBar = t < gpMasterBarCopy.getBarIds().length ? this.document.getBar(gpMasterBarCopy.getBarIds()[t]) : null;
                        continue;
                    }
                    gpBar = null;
                }
                if (gpBar == null) continue;
                this.parseBar(gpBar, tgMeasure);
            }
            tgStart += tgMeasureHeader.getLength();
        }
    }

    private void parseBar(GPXBar bar, TGMeasure tgMeasure) {
        if (bar.getClef() != null) {
            String clef = bar.getClef();
            if (clef.equals("F4")) {
                tgMeasure.setClef(2);
            } else if (clef.equals("C3")) {
                tgMeasure.setClef(4);
            } else if (clef.equals("C4")) {
                tgMeasure.setClef(3);
            }
        }
        int[] voiceIds = bar.getVoiceIds();
        for (int v = 0; v < 2; ++v) {
            GPXVoice voice;
            if (voiceIds.length <= v || voiceIds[v] < 0 || (voice = this.document.getVoice(voiceIds[v])) == null) continue;
            long tgStart = tgMeasure.getStart();
            for (int b = 0; b < voice.getBeatIds().length; ++b) {
                GPXBeat beat = this.document.getBeat(voice.getBeatIds()[b]);
                GPXRhythm gpRhythm = this.document.getRhythm(beat.getRhythmId());
                TGBeat tgBeat = this.getBeat(tgMeasure, tgStart);
                TGVoice tgVoice = tgBeat.getVoice(v % tgBeat.countVoices());
                tgVoice.setEmpty(false);
                tgBeat.getStroke().setDirection(this.parseStroke(beat));
                if (beat.getText().length() > 0) {
                    TGText text = this.factory.newText();
                    text.setValue(beat.getText().trim());
                    text.setBeat(tgBeat);
                    tgBeat.setText(text);
                }
                this.parseRhythm(gpRhythm, tgVoice.getDuration());
                if (beat.getNoteIds() != null) {
                    int tgVelocity = this.parseDynamic(beat);
                    for (int n = 0; n < beat.getNoteIds().length; ++n) {
                        GPXNote gpNote = this.document.getNote(beat.getNoteIds()[n]);
                        if (gpNote == null) continue;
                        this.parseNote(gpNote, tgVoice, tgVelocity, beat);
                    }
                }
                tgStart += tgVoice.getDuration().getTime();
            }
        }
        if (tgMeasure.getNumber() == 1) {
            this.fixFirstMeasureStartPositions(tgMeasure);
        }
    }

    private void parseNote(GPXNote gpNote, TGVoice tgVoice, int tgVelocity, GPXBeat gpBeat) {
        int tgValue = -1;
        int tgString = -1;
        if (gpNote.getString() >= 0 && gpNote.getFret() >= 0) {
            tgValue = gpNote.getFret();
            tgString = tgVoice.getBeat().getMeasure().getTrack().stringCount() - gpNote.getString();
        } else {
            TGString tgStringAlternative;
            int gmValue = -1;
            if (gpNote.getMidiNumber() >= 0) {
                gmValue = gpNote.getMidiNumber();
            } else if (gpNote.getTone() >= 0 && gpNote.getOctave() >= 0) {
                gmValue = gpNote.getTone() + (12 * gpNote.getOctave() - 12);
            } else if (gpNote.getElement() >= 0) {
                for (int i = 0; i < GPXDrumkit.DRUMKITS.length; ++i) {
                    if (GPXDrumkit.DRUMKITS[i].getElement() != gpNote.getElement() || GPXDrumkit.DRUMKITS[i].getVariation() != gpNote.getVariation()) continue;
                    gmValue = GPXDrumkit.DRUMKITS[i].getMidiValue();
                }
            }
            if (gmValue >= 0 && (tgStringAlternative = this.getStringFor(tgVoice.getBeat(), gmValue)) != null) {
                tgValue = gmValue - tgStringAlternative.getValue();
                tgString = tgStringAlternative.getNumber();
            }
        }
        if (tgValue >= 0 && tgString > 0) {
            TGNote tgNote = this.factory.newNote();
            tgNote.setValue(tgValue);
            tgNote.setString(tgString);
            tgNote.setTiedNote(gpNote.isTieDestination());
            tgNote.setVelocity(tgVelocity);
            tgNote.getEffect().setFadeIn(gpBeat.isFadeIn());
            tgNote.getEffect().setVibrato(gpNote.isVibrato());
            tgNote.getEffect().setSlide(gpNote.isSlide());
            tgNote.getEffect().setDeadNote(gpNote.isMutedEnabled());
            tgNote.getEffect().setPalmMute(gpNote.isPalmMutedEnabled());
            tgNote.getEffect().setTapping(gpNote.isTapped());
            tgNote.getEffect().setHammer(gpNote.isHammer());
            tgNote.getEffect().setGhostNote(gpNote.isGhost());
            tgNote.getEffect().setSlapping(gpBeat.isSlapped());
            tgNote.getEffect().setPopping(gpBeat.isPopped());
            tgNote.getEffect().setStaccato(gpNote.getAccent() == 1);
            tgNote.getEffect().setHeavyAccentuatedNote(gpNote.getAccent() == 4);
            tgNote.getEffect().setAccentuatedNote(gpNote.getAccent() == 8);
            tgNote.getEffect().setTrill(this.parseTrill(gpNote));
            tgNote.getEffect().setTremoloPicking(this.parseTremoloPicking(gpBeat, gpNote));
            tgNote.getEffect().setHarmonic(this.parseHarmonic(gpNote));
            tgNote.getEffect().setBend(this.parseBend(gpNote));
            tgNote.getEffect().setTremoloBar(this.parseTremoloBar(gpBeat));
            tgVoice.addNote(tgNote);
        }
    }

    private TGEffectTrill parseTrill(GPXNote gpNote) {
        TGEffectTrill tr = null;
        if (gpNote.getTrill() > 0) {
            tr = this.factory.newEffectTrill();
            tr.setFret(gpNote.getTrill());
        }
        return tr;
    }

    private TGEffectTremoloPicking parseTremoloPicking(GPXBeat gpBeat, GPXNote gpNote) {
        TGEffectTremoloPicking tp = null;
        if (gpBeat.getTremolo() != null && gpBeat.getTremolo().length == 2) {
            tp = this.factory.newEffectTremoloPicking();
            tp.getDuration().setValue(4 * gpBeat.getTremolo()[1]);
        }
        return tp;
    }

    private TGEffectHarmonic parseHarmonic(GPXNote note) {
        TGEffectHarmonic harmonic = null;
        if (note.getHarmonicType() != null && note.getHarmonicType().length() > 0) {
            harmonic = this.factory.newEffectHarmonic();
            String type = note.getHarmonicType();
            if (type.equals("Artificial")) {
                harmonic.setType(2);
            } else if (type.equals("Natural")) {
                harmonic.setType(1);
            } else if (type.equals("Pinch")) {
                harmonic.setType(4);
            } else {
                harmonic.setType(1);
            }
            int hFret = note.getHarmonicFret();
            if (hFret >= 0) {
                for (int i = 0; i < TGEffectHarmonic.NATURAL_FREQUENCIES.length; ++i) {
                    if (hFret != TGEffectHarmonic.NATURAL_FREQUENCIES[i][0]) continue;
                    harmonic.setData(i);
                    break;
                }
            }
        }
        return harmonic;
    }

    private TGEffectBend parseBend(GPXNote note) {
        TGEffectBend bend = null;
        if (note.isBendEnabled() && note.getBendOriginValue() != null && note.getBendDestinationValue() != null) {
            bend = this.factory.newEffectBend();
            bend.addPoint(0, this.parseBendValue(note.getBendOriginValue()));
            if (note.getBendOriginOffset() != null) {
                bend.addPoint(this.parseBendPosition(note.getBendOriginOffset()), this.parseBendValue(note.getBendOriginValue()));
            }
            if (note.getBendMiddleValue() != null) {
                Integer offset;
                Integer defaultMiddleOffset = new Integer(Math.round(50.0f));
                if (note.getBendMiddleOffset1() == null || note.getBendMiddleOffset1() != 12) {
                    offset = note.getBendMiddleOffset1() != null ? note.getBendMiddleOffset1() : defaultMiddleOffset;
                    bend.addPoint(this.parseBendPosition(offset), this.parseBendValue(note.getBendMiddleValue()));
                }
                if (note.getBendMiddleOffset2() == null || note.getBendMiddleOffset2() != 12) {
                    offset = note.getBendMiddleOffset2() != null ? note.getBendMiddleOffset2() : defaultMiddleOffset;
                    bend.addPoint(this.parseBendPosition(offset), this.parseBendValue(note.getBendMiddleValue()));
                }
            }
            if (note.getBendDestinationOffset() != null && (float)note.getBendDestinationOffset().intValue() < 100.0f) {
                bend.addPoint(this.parseBendPosition(note.getBendDestinationOffset()), this.parseBendValue(note.getBendDestinationValue()));
            }
            bend.addPoint(12, this.parseBendValue(note.getBendDestinationValue()));
        }
        return bend;
    }

    private int parseBendValue(Integer gpValue) {
        return Math.round((float)gpValue.intValue() * 0.04f);
    }

    private int parseBendPosition(Integer gpOffset) {
        return Math.round((float)gpOffset.intValue() * 0.12f);
    }

    private TGEffectTremoloBar parseTremoloBar(GPXBeat beat) {
        TGEffectTremoloBar tremoloBar = null;
        if (beat.isWhammyBarEnabled() && beat.getWhammyBarOriginValue() != null && beat.getWhammyBarDestinationValue() != null) {
            tremoloBar = this.factory.newEffectTremoloBar();
            tremoloBar.addPoint(0, this.parseTremoloBarValue(beat.getWhammyBarOriginValue()));
            if (beat.getWhammyBarOriginOffset() != null) {
                tremoloBar.addPoint(this.parseTremoloBarPosition(beat.getWhammyBarOriginOffset()), this.parseTremoloBarValue(beat.getWhammyBarOriginValue()));
            }
            if (beat.getWhammyBarMiddleValue() != null) {
                boolean hiddenPoint = false;
                if (beat.getWhammyBarDestinationValue() != 0 && beat.getWhammyBarMiddleValue() == Math.round((float)beat.getWhammyBarDestinationValue().intValue() / 2.0f)) {
                    hiddenPoint = false;
                }
                if (!hiddenPoint) {
                    Integer offset2;
                    Integer offset1;
                    Integer defaultMiddleOffset = new Integer(Math.round(50.0f));
                    Integer n = offset1 = beat.getWhammyBarMiddleOffset1() != null ? beat.getWhammyBarMiddleOffset1() : defaultMiddleOffset;
                    if (beat.getWhammyBarOriginOffset() == null || offset1 >= beat.getWhammyBarOriginOffset()) {
                        tremoloBar.addPoint(this.parseTremoloBarPosition(offset1), this.parseTremoloBarValue(beat.getWhammyBarMiddleValue()));
                    }
                    Integer n2 = offset2 = beat.getWhammyBarMiddleOffset2() != null ? beat.getWhammyBarMiddleOffset2() : defaultMiddleOffset;
                    if (beat.getWhammyBarOriginOffset() == null || offset1 >= beat.getWhammyBarOriginOffset() && offset2 > offset1) {
                        tremoloBar.addPoint(this.parseTremoloBarPosition(offset2), this.parseTremoloBarValue(beat.getWhammyBarMiddleValue()));
                    }
                }
            }
            if (beat.getWhammyBarDestinationOffset() != null && (float)beat.getWhammyBarDestinationOffset().intValue() < 100.0f) {
                tremoloBar.addPoint(this.parseTremoloBarPosition(beat.getWhammyBarDestinationOffset()), this.parseTremoloBarValue(beat.getWhammyBarDestinationValue()));
            }
            tremoloBar.addPoint(12, this.parseTremoloBarValue(beat.getWhammyBarDestinationValue()));
        }
        return tremoloBar;
    }

    private int parseTremoloBarValue(Integer gpValue) {
        int value = Math.round((float)gpValue.intValue() * 0.02f);
        if (value > 12) {
            value = 12;
        }
        if (value < -12) {
            value = -12;
        }
        return value;
    }

    private int parseTremoloBarPosition(Integer gpOffset) {
        return Math.round((float)gpOffset.intValue() * 0.12f);
    }

    private void parseRhythm(GPXRhythm gpRhythm, TGDuration tgDuration) {
        tgDuration.setDotted(gpRhythm.getAugmentationDotCount() == 1);
        tgDuration.setDoubleDotted(gpRhythm.getAugmentationDotCount() == 2);
        tgDuration.getDivision().setTimes(gpRhythm.getPrimaryTupletDen());
        tgDuration.getDivision().setEnters(gpRhythm.getPrimaryTupletNum());
        if (gpRhythm.getNoteValue().equals("Whole")) {
            tgDuration.setValue(1);
        } else if (gpRhythm.getNoteValue().equals("Half")) {
            tgDuration.setValue(2);
        } else if (gpRhythm.getNoteValue().equals("Quarter")) {
            tgDuration.setValue(4);
        } else if (gpRhythm.getNoteValue().equals("Eighth")) {
            tgDuration.setValue(8);
        } else if (gpRhythm.getNoteValue().equals("16th")) {
            tgDuration.setValue(16);
        } else if (gpRhythm.getNoteValue().equals("32nd")) {
            tgDuration.setValue(32);
        } else if (gpRhythm.getNoteValue().equals("64th")) {
            tgDuration.setValue(64);
        }
    }

    private int parseStroke(GPXBeat beat) {
        int tgStroke = 0;
        String stroke = beat.getBrush();
        if (stroke.equals("Down")) {
            tgStroke = -1;
        } else if (stroke.equals("Up")) {
            tgStroke = 1;
        }
        return tgStroke;
    }

    private int parseDynamic(GPXBeat beat) {
        int tgVelocity = 95;
        if (beat.getDynamic() != null) {
            if (beat.getDynamic().equals("PPP")) {
                tgVelocity = 15;
            } else if (beat.getDynamic().equals("PP")) {
                tgVelocity = 31;
            } else if (beat.getDynamic().equals("P")) {
                tgVelocity = 47;
            } else if (beat.getDynamic().equals("MP")) {
                tgVelocity = 63;
            } else if (beat.getDynamic().equals("MF")) {
                tgVelocity = 79;
            } else if (beat.getDynamic().equals("F")) {
                tgVelocity = 95;
            } else if (beat.getDynamic().equals("FF")) {
                tgVelocity = 111;
            } else if (beat.getDynamic().equals("FFF")) {
                tgVelocity = 127;
            }
        }
        return tgVelocity;
    }

    private int parseTripletFeel(GPXMasterBar gpMasterBar) {
        if (gpMasterBar.getTripletFeel() != null) {
            if (gpMasterBar.getTripletFeel().equals("Triplet8th")) {
                return 2;
            }
            if (gpMasterBar.getTripletFeel().equals("Triplet16th")) {
                return 3;
            }
        }
        return 1;
    }

    private TGBeat getBeat(TGMeasure measure, long start) {
        int count = measure.countBeats();
        for (int i = 0; i < count; ++i) {
            TGBeat beat = measure.getBeat(i);
            if (beat.getStart() != start) continue;
            return beat;
        }
        TGBeat beat = this.factory.newBeat();
        beat.setStart(start);
        measure.addBeat(beat);
        return beat;
    }

    private TGString getStringFor(TGBeat tgBeat, int value) {
        List strings = tgBeat.getMeasure().getTrack().getStrings();
        for (int i = 0; i < strings.size(); ++i) {
            TGString string = (TGString)strings.get(i);
            if (value < string.getValue()) continue;
            boolean emptyString = true;
            block1: for (int v = 0; v < tgBeat.countVoices(); ++v) {
                TGVoice voice = tgBeat.getVoice(v);
                for (TGNoteImpl note : voice.getNotes()) {
                    if (note.getString() != string.getNumber()) continue;
                    emptyString = false;
                    continue block1;
                }
            }
            if (!emptyString) continue;
            return string;
        }
        return null;
    }

    private void fixFirstMeasureStartPositions(TGMeasure tgMeasure) {
        if (tgMeasure.getNumber() == 1) {
            long measureEnd = tgMeasure.getStart() + tgMeasure.getLength();
            long maximumNoteEnd = 0L;
            for (int b = 0; b < tgMeasure.countBeats(); ++b) {
                TGBeat tgBeat = tgMeasure.getBeat(b);
                for (int v = 0; v < tgBeat.countVoices(); ++v) {
                    TGVoice tgVoice = tgBeat.getVoice(v);
                    if (tgVoice.isEmpty()) continue;
                    maximumNoteEnd = Math.max(maximumNoteEnd, tgBeat.getStart() + tgVoice.getDuration().getTime());
                }
            }
            if (maximumNoteEnd < measureEnd) {
                long movement = measureEnd - maximumNoteEnd;
                for (int b = 0; b < tgMeasure.countBeats(); ++b) {
                    TGBeat tgBeat = tgMeasure.getBeat(b);
                    tgBeat.setStart(tgBeat.getStart() + movement);
                }
            }
        }
    }
}

