/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelManagerDialog;
import org.herac.tuxguitar.app.view.dialog.fretboard.TGFretBoardEditor;
import org.herac.tuxguitar.app.view.dialog.transport.TGTransportDialog;
import org.herac.tuxguitar.app.view.toolbar.TGToolBar;
import org.herac.tuxguitar.app.view.toolbar.TGToolBarSection;

public class TGToolBarSectionView
implements TGToolBarSection {
    private ToolItem menuItem;

    public void createSection(final TGToolBar toolBar) {
        this.menuItem = new ToolItem(toolBar.getControl(), 8);
        this.menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TGToolBarSectionView.this.createMenu(toolBar, (ToolItem)event.widget);
            }
        });
        this.loadIcons(toolBar);
        this.loadProperties(toolBar);
    }

    public void loadProperties(TGToolBar toolBar) {
        this.menuItem.setToolTipText(toolBar.getText("view"));
    }

    public void loadIcons(TGToolBar toolBar) {
        this.menuItem.setImage(toolBar.getIconManager().getFretboard());
    }

    public void updateItems(TGToolBar toolBar) {
    }

    public void createMenu(TGToolBar toolBar, ToolItem item) {
        Menu menu = new Menu((Control)item.getParent().getShell());
        MenuItem showFretBoard = new MenuItem(menu, 8);
        showFretBoard.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.toggle-fretboard-editor"));
        showFretBoard.setImage(toolBar.getIconManager().getFretboard());
        showFretBoard.setText(toolBar.getText("view.show-fretboard", TGFretBoardEditor.getInstance(toolBar.getContext()).isVisible()));
        MenuItem showInstruments = new MenuItem(menu, 8);
        showInstruments.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.toggle-channels-dialog"));
        showInstruments.setImage(toolBar.getIconManager().getInstruments());
        showInstruments.setText(toolBar.getText("view.show-instruments", !TGChannelManagerDialog.getInstance(toolBar.getContext()).isDisposed()));
        MenuItem showTransport = new MenuItem(menu, 8);
        showTransport.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.toggle-transport-dialog"));
        showTransport.setImage(toolBar.getIconManager().getTransport());
        showTransport.setText(toolBar.getText("view.show-transport", !TGTransportDialog.getInstance(toolBar.getContext()).isDisposed()));
        Rectangle rect = item.getBounds();
        Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
        menu.setLocation(pt.x, pt.y + rect.height);
        menu.setVisible(true);
    }
}

