/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.app.view.toolbar.TGToolBar;
import org.herac.tuxguitar.app.view.toolbar.TGToolBarSection;

public class TGToolBarSectionFile
implements TGToolBarSection {
    private ToolItem menuItem;

    public void createSection(final TGToolBar toolBar) {
        this.menuItem = new ToolItem(toolBar.getControl(), 8);
        this.menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TGToolBarSectionFile.this.createMenu(toolBar, (ToolItem)event.widget);
            }
        });
        this.loadIcons(toolBar);
        this.loadProperties(toolBar);
    }

    public void loadProperties(TGToolBar toolBar) {
        this.menuItem.setToolTipText(toolBar.getText("file"));
    }

    public void loadIcons(TGToolBar toolBar) {
        this.menuItem.setImage(toolBar.getIconManager().getFileNew());
    }

    public void updateItems(TGToolBar toolBar) {
    }

    public void createMenu(TGToolBar toolBar, ToolItem item) {
        Rectangle rect = item.getBounds();
        Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
        Menu menu = new Menu((Control)item.getParent().getShell());
        MenuItem newSong = new MenuItem(menu, 8);
        newSong.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.song.new-from-template"));
        newSong.setText(toolBar.getText("file.new"));
        newSong.setImage(toolBar.getIconManager().getFileNew());
        MenuItem openSong = new MenuItem(menu, 8);
        openSong.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.file.open"));
        openSong.setText(toolBar.getText("file.open"));
        openSong.setImage(toolBar.getIconManager().getFileOpen());
        MenuItem saveSong = new MenuItem(menu, 8);
        saveSong.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.file.save"));
        saveSong.setText(toolBar.getText("file.save"));
        saveSong.setImage(toolBar.getIconManager().getFileSave());
        MenuItem saveAsSong = new MenuItem(menu, 8);
        saveAsSong.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.file.save-as"));
        saveAsSong.setText(toolBar.getText("file.save-as"));
        saveAsSong.setImage(toolBar.getIconManager().getFileSaveAs());
        MenuItem printSong = new MenuItem(menu, 8);
        printSong.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.file.print"));
        printSong.setText(toolBar.getText("file.print"));
        printSong.setImage(toolBar.getIconManager().getFilePrint());
        MenuItem printPreviewSong = new MenuItem(menu, 8);
        printPreviewSong.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.file.print-preview"));
        printPreviewSong.setText(toolBar.getText("file.print-preview"));
        printPreviewSong.setImage(toolBar.getIconManager().getFilePrintPreview());
        new MenuItem(menu, 2);
        MenuItem properties = new MenuItem(menu, 8);
        properties.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.open-song-info-dialog"));
        properties.setText(toolBar.getText("composition.properties"));
        properties.setImage(toolBar.getIconManager().getSongProperties());
        menu.setLocation(pt.x, pt.y + rect.height);
        menu.setVisible(true);
    }
}

