/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;

public class DurationMenuItem
extends TGMenuItem {
    private MenuItem durationMenuItem;
    private Menu menu;
    private MenuItem whole;
    private MenuItem half;
    private MenuItem quarter;
    private MenuItem eighth;
    private MenuItem sixteenth;
    private MenuItem thirtySecond;
    private MenuItem sixtyFourth;
    private MenuItem dotted;
    private MenuItem doubleDotted;
    private MenuItem division;

    public DurationMenuItem(Shell shell, Menu parent, int style) {
        this.durationMenuItem = new MenuItem(parent, style);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.whole = new MenuItem(this.menu, 8);
        this.whole.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.duration.set-whole"));
        this.half = new MenuItem(this.menu, 8);
        this.half.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.duration.set-half"));
        this.quarter = new MenuItem(this.menu, 8);
        this.quarter.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.duration.set-quarter"));
        this.eighth = new MenuItem(this.menu, 8);
        this.eighth.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.duration.set-eighth"));
        this.sixteenth = new MenuItem(this.menu, 8);
        this.sixteenth.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.duration.set-sixteenth"));
        this.thirtySecond = new MenuItem(this.menu, 8);
        this.thirtySecond.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.duration.set-thirty-second"));
        this.sixtyFourth = new MenuItem(this.menu, 8);
        this.sixtyFourth.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.duration.set-sixty-fourth"));
        new MenuItem(this.menu, 2);
        this.dotted = new MenuItem(this.menu, 8);
        this.dotted.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.duration.change-dotted"));
        this.doubleDotted = new MenuItem(this.menu, 8);
        this.doubleDotted.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.duration.change-double-dotted"));
        this.division = new MenuItem(this.menu, 8);
        this.division.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.duration.set-division-type"));
        this.durationMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.whole.setEnabled(!running);
        this.half.setEnabled(!running);
        this.quarter.setEnabled(!running);
        this.eighth.setEnabled(!running);
        this.sixteenth.setEnabled(!running);
        this.thirtySecond.setEnabled(!running);
        this.sixtyFourth.setEnabled(!running);
        this.dotted.setEnabled(!running);
        this.doubleDotted.setEnabled(!running);
        this.division.setEnabled(!running);
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.durationMenuItem, "duration", null);
        this.setMenuItemTextAndAccelerator(this.whole, "duration.whole", "action.note.duration.set-whole");
        this.setMenuItemTextAndAccelerator(this.half, "duration.half", "action.note.duration.set-half");
        this.setMenuItemTextAndAccelerator(this.quarter, "duration.quarter", "action.note.duration.set-quarter");
        this.setMenuItemTextAndAccelerator(this.eighth, "duration.eighth", "action.note.duration.set-eighth");
        this.setMenuItemTextAndAccelerator(this.sixteenth, "duration.sixteenth", "action.note.duration.set-sixteenth");
        this.setMenuItemTextAndAccelerator(this.thirtySecond, "duration.thirtysecond", "action.note.duration.set-thirty-second");
        this.setMenuItemTextAndAccelerator(this.sixtyFourth, "duration.sixtyfourth", "action.note.duration.set-sixty-fourth");
        this.setMenuItemTextAndAccelerator(this.dotted, "duration.dotted", "action.note.duration.change-dotted");
        this.setMenuItemTextAndAccelerator(this.doubleDotted, "duration.doubledotted", "action.note.duration.change-double-dotted");
        this.setMenuItemTextAndAccelerator(this.division, "duration.division-type", "action.note.duration.set-division-type");
    }

    public void loadIcons() {
        this.whole.setImage(TuxGuitar.getInstance().getIconManager().getDuration(1));
        this.half.setImage(TuxGuitar.getInstance().getIconManager().getDuration(2));
        this.quarter.setImage(TuxGuitar.getInstance().getIconManager().getDuration(4));
        this.eighth.setImage(TuxGuitar.getInstance().getIconManager().getDuration(8));
        this.sixteenth.setImage(TuxGuitar.getInstance().getIconManager().getDuration(16));
        this.thirtySecond.setImage(TuxGuitar.getInstance().getIconManager().getDuration(32));
        this.sixtyFourth.setImage(TuxGuitar.getInstance().getIconManager().getDuration(64));
        this.dotted.setImage(TuxGuitar.getInstance().getIconManager().getDurationDotted());
        this.doubleDotted.setImage(TuxGuitar.getInstance().getIconManager().getDurationDoubleDotted());
        this.division.setImage(TuxGuitar.getInstance().getIconManager().getDivisionType());
    }
}

