/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.BeatMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.CompositionMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.EditMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.FileMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.HelpMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.MarkerMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.MeasureMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.ToolMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.TrackMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.TransportMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.ViewMenuItem;
import org.herac.tuxguitar.app.view.util.TGSyncProcessLocked;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.util.TGContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGMenuManager
implements TGEventListener {
    private TGContext context;
    private Menu menu;
    private Menu popupMenu;
    private List<TGMenuItem> loadedMenuItems;
    private List<TGMenuItem> loadedPopupMenuItems;
    private TGSyncProcessLocked loadIconsProcess;
    private TGSyncProcessLocked loadPropertiesProcess;
    private TGSyncProcessLocked updateItemsProcess;
    private TGSyncProcessLocked createMenuProcess;

    public TGMenuManager(TGContext context) {
        this.context = context;
        this.loadedMenuItems = new ArrayList<TGMenuItem>();
        this.loadedPopupMenuItems = new ArrayList<TGMenuItem>();
        this.createSyncProcesses();
        this.loadItems();
        this.appendListeners();
    }

    public void loadItems() {
        this.createMenuProcess.process();
        this.createPopupMenu();
    }

    public void createMenu() {
        Shell shell = TuxGuitar.getInstance().getShell();
        if (!shell.isDisposed()) {
            if (this.menu == null || this.menu.isDisposed()) {
                this.menu = new Menu((Decorations)shell, 2);
            }
            MenuItem[] items = this.menu.getItems();
            for (int i = 0; i < items.length; ++i) {
                items[i].dispose();
            }
            this.loadedMenuItems.clear();
            this.loadedMenuItems.add(new FileMenuItem(shell, this.menu, 64));
            this.loadedMenuItems.add(new EditMenuItem(shell, this.menu, 64));
            this.loadedMenuItems.add(new ViewMenuItem(shell, this.menu, 64));
            this.loadedMenuItems.add(new CompositionMenuItem(shell, this.menu, 64));
            this.loadedMenuItems.add(new TrackMenuItem(shell, this.menu, 64));
            this.loadedMenuItems.add(new MeasureMenuItem(shell, this.menu, 64));
            this.loadedMenuItems.add(new BeatMenuItem(shell, this.menu, 64));
            this.loadedMenuItems.add(new MarkerMenuItem(shell, this.menu, 64));
            this.loadedMenuItems.add(new TransportMenuItem(shell, this.menu, 64));
            this.loadedMenuItems.add(new ToolMenuItem(shell, this.menu, 64));
            this.loadedMenuItems.add(new HelpMenuItem(shell, this.menu, 64));
            this.showMenuItems(this.loadedMenuItems);
            shell.setMenuBar(this.menu);
        }
    }

    public void createPopupMenu() {
        Shell shell = TuxGuitar.getInstance().getShell();
        if (this.popupMenu == null || this.popupMenu.isDisposed()) {
            this.popupMenu = new Menu((Decorations)shell, 8);
        }
        MenuItem[] items = this.popupMenu.getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
        this.loadedPopupMenuItems.clear();
        this.loadedPopupMenuItems.add(new EditMenuItem(shell, this.popupMenu, 64));
        this.loadedPopupMenuItems.add(new CompositionMenuItem(shell, this.popupMenu, 64));
        this.loadedPopupMenuItems.add(new TrackMenuItem(shell, this.popupMenu, 64));
        this.loadedPopupMenuItems.add(new MeasureMenuItem(shell, this.popupMenu, 64));
        this.loadedPopupMenuItems.add(new BeatMenuItem(shell, this.popupMenu, 64));
        this.loadedPopupMenuItems.add(new MarkerMenuItem(shell, this.popupMenu, 64));
        this.loadedPopupMenuItems.add(new TransportMenuItem(shell, this.popupMenu, 64));
        this.showMenuItems(this.loadedPopupMenuItems);
    }

    private void showMenuItems(List<TGMenuItem> items) {
        for (TGMenuItem item : items) {
            item.showItems();
        }
    }

    public void updateItems() {
        if (!this.isDisposed()) {
            this.updateItems(this.loadedMenuItems);
            this.updateItems(this.loadedPopupMenuItems);
        }
    }

    public void updateItems(List<TGMenuItem> menuItems) {
        for (TGMenuItem menuItem : menuItems) {
            menuItem.update();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.loadProperties(this.loadedMenuItems);
            this.loadProperties(this.loadedPopupMenuItems);
        }
    }

    public void loadProperties(List<TGMenuItem> menuItems) {
        for (TGMenuItem menuItem : menuItems) {
            menuItem.loadProperties();
        }
    }

    public void loadIcons() {
        this.loadItems();
    }

    public Menu getPopupMenu() {
        return this.popupMenu;
    }

    private boolean isMenuDisposed() {
        return this.menu == null || this.menu.isDisposed();
    }

    private boolean isPopupMenuDisposed() {
        return this.popupMenu == null || this.popupMenu.isDisposed();
    }

    private boolean isDisposed() {
        return this.isMenuDisposed() || this.isPopupMenuDisposed();
    }

    public void createSyncProcesses() {
        this.updateItemsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TGMenuManager.this.updateItems();
            }
        });
        this.loadIconsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TGMenuManager.this.loadIcons();
            }
        });
        this.loadPropertiesProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TGMenuManager.this.loadProperties();
            }
        });
        this.createMenuProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TGMenuManager.this.createMenu();
            }
        });
    }

    public void appendListeners() {
        TuxGuitar.getInstance().getIconManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
        TuxGuitar.getInstance().getFileFormatManager().addFileFormatAvailabilityListener((TGEventListener)this);
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 1) {
            this.updateItemsProcess.process();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        } else if ("ui-icon".equals(event.getEventType())) {
            this.loadIconsProcess.process();
        } else if ("language".equals(event.getEventType())) {
            this.loadPropertiesProcess.process();
        } else if ("file-format-availability".equals(event.getEventType())) {
            this.createMenuProcess.process();
        }
    }
}

