/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.tremolobar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.graphics.TGColorImpl;
import org.herac.tuxguitar.app.graphics.TGPainterImpl;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.action.effect.TGChangeTremoloBarAction;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.util.TGContext;

public class TGTremoloBarDialog {
    private static final int X_SPACING = 30;
    private static final int Y_SPACING = 10;
    private static final int X_LENGTH = 13;
    private static final int Y_LENGTH = 25;
    private int[] x;
    private int[] y;
    private int width;
    private int height;
    private List<Point> points;
    protected Composite editor;
    protected DefaultTremoloBar[] defaultTremoloBars;

    public TGTremoloBarDialog() {
        this.init();
    }

    private void init() {
        int i;
        this.x = new int[13];
        this.y = new int[25];
        this.width = 360;
        this.height = 240;
        this.points = new ArrayList<Point>();
        for (i = 0; i < this.x.length; ++i) {
            this.x[i] = (i + 1) * 30;
        }
        for (i = 0; i < this.y.length; ++i) {
            this.y[i] = (i + 1) * 10;
        }
    }

    public void show(final TGViewContext context) {
        final TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final TGBeat beat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        final TGString string = (TGString)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING);
        TGNote note = (TGNote)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE);
        if (measure != null && beat != null && note != null && string != null) {
            Shell parent = (Shell)context.getAttribute("parent");
            final Shell dialog = DialogUtils.newDialog(parent, 67680);
            dialog.setLayout((Layout)new GridLayout());
            dialog.setText(TuxGuitar.getProperty("effects.tremolo-bar-editor"));
            Composite composite = new Composite((Composite)dialog, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite leftComposite = new Composite(composite, 0);
            leftComposite.setLayout((Layout)new GridLayout());
            leftComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite rightComposite = new Composite(composite, 0);
            rightComposite.setLayout((Layout)new GridLayout());
            rightComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.editor = new Composite(leftComposite, 0x20000800);
            this.editor.setBackground(this.editor.getDisplay().getSystemColor(1));
            this.editor.setLayoutData((Object)this.resizeData(new GridData(4, 4, true, true), this.getWidth() + 60, this.getHeight() + 20));
            this.editor.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    TGPainterImpl painter = new TGPainterImpl(e.gc);
                    TGTremoloBarDialog.this.paintEditor(painter);
                }
            });
            this.editor.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    TGTremoloBarDialog.this.checkPoint(e.x, e.y);
                    TGTremoloBarDialog.this.editor.redraw();
                }
            });
            this.resetDefaultTremoloBars();
            final org.eclipse.swt.widgets.List defaultTremoloBarList = new org.eclipse.swt.widgets.List(rightComposite, 2048);
            for (int i = 0; i < this.defaultTremoloBars.length; ++i) {
                defaultTremoloBarList.add(this.defaultTremoloBars[i].getName());
            }
            defaultTremoloBarList.select(0);
            defaultTremoloBarList.setLayoutData((Object)new GridData(4, 4, true, true));
            defaultTremoloBarList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = defaultTremoloBarList.getSelectionIndex();
                    if (index >= 0 && index < TGTremoloBarDialog.this.defaultTremoloBars.length) {
                        TGTremoloBarDialog.this.setTremoloBar(TGTremoloBarDialog.this.defaultTremoloBars[index].getTremoloBar());
                        TGTremoloBarDialog.this.editor.redraw();
                    }
                }
            });
            Button buttonClean = new Button(rightComposite, 8);
            buttonClean.setLayoutData((Object)this.resizeData(new GridData(4, 1024, true, true), 80, 25));
            buttonClean.setText(TuxGuitar.getProperty("clean"));
            buttonClean.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    TGTremoloBarDialog.this.changeTremoloBar(context.getContext(), measure, beat, string, null);
                    dialog.dispose();
                }
            });
            Button buttonOK = new Button(rightComposite, 8);
            buttonOK.setLayoutData((Object)this.resizeData(new GridData(4, 1024, true, false), 80, 25));
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    TGTremoloBarDialog.this.changeTremoloBar(context.getContext(), measure, beat, string, TGTremoloBarDialog.this.getTremoloBar());
                    dialog.dispose();
                }
            });
            Button buttonCancel = new Button(rightComposite, 8);
            buttonCancel.setLayoutData((Object)this.resizeData(new GridData(4, 1024, true, false), 80, 25));
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });
            if (note.getEffect().isTremoloBar()) {
                this.setTremoloBar(note.getEffect().getTremoloBar());
            } else {
                this.setTremoloBar(this.defaultTremoloBars[0].getTremoloBar());
            }
            dialog.setDefaultButton(buttonOK);
            DialogUtils.openDialog(dialog, 10);
        }
    }

    private GridData resizeData(GridData data, int minimumWidth, int minimumHeight) {
        data.minimumWidth = minimumWidth;
        data.minimumHeight = minimumHeight;
        return data;
    }

    protected void paintEditor(TGPainterImpl painter) {
        int i;
        for (i = 0; i < this.x.length; ++i) {
            this.setStyleX(painter, i);
            painter.initPath();
            painter.setAntialias(false);
            painter.moveTo(this.x[i], 10.0f);
            painter.lineTo(this.x[i], 10 + this.height);
            painter.closePath();
        }
        for (i = 0; i < this.y.length; ++i) {
            this.setStyleY(painter, i);
            painter.initPath();
            painter.setAntialias(false);
            painter.moveTo(30.0f, this.y[i]);
            painter.lineTo(30 + this.width, this.y[i]);
            painter.closePath();
        }
        Iterator<Point> it = null;
        Point prevPoint = null;
        painter.setLineStyleSolid();
        painter.setLineWidth(2.0f);
        painter.setForeground(new TGColorImpl(this.editor.getDisplay().getSystemColor(15)));
        for (Point point : this.points) {
            if (prevPoint != null) {
                painter.initPath();
                painter.moveTo(prevPoint.x, prevPoint.y);
                painter.lineTo(point.x, point.y);
                painter.closePath();
            }
            prevPoint = point;
        }
        painter.setLineWidth(5.0f);
        painter.setForeground(new TGColorImpl(this.editor.getDisplay().getSystemColor(2)));
        for (Point point : this.points) {
            painter.initPath();
            painter.setAntialias(false);
            painter.addRectangle(point.x - 2, point.y - 2, 5.0f, 5.0f);
            painter.closePath();
        }
        painter.setLineWidth(1.0f);
    }

    private void setStyleX(TGPainterImpl painter, int i) {
        painter.setLineStyleSolid();
        if (i == 0 || i == 12) {
            painter.setForeground(new TGColorImpl(this.editor.getDisplay().getSystemColor(2)));
        } else {
            painter.setForeground(new TGColorImpl(this.editor.getDisplay().getSystemColor(9)));
            if (i % 3 > 0) {
                painter.setLineStyleDot();
            }
        }
    }

    private void setStyleY(TGPainterImpl painter, int i) {
        painter.setLineStyleSolid();
        if (i == 0 || i == 24) {
            painter.setForeground(new TGColorImpl(this.editor.getDisplay().getSystemColor(2)));
        } else if (i == 12) {
            painter.setForeground(new TGColorImpl(this.editor.getDisplay().getSystemColor(2)));
        } else {
            painter.setForeground(new TGColorImpl(this.editor.getDisplay().getSystemColor(3)));
            if (i % 2 > 0) {
                painter.setLineStyleDot();
                painter.setForeground(new TGColorImpl(this.editor.getDisplay().getSystemColor(15)));
            }
        }
    }

    protected void checkPoint(int x, int y) {
        Point point = new Point(this.getX(x), this.getY(y));
        if (!this.removePoint(point)) {
            this.removePointsAtXLine(point.x);
            this.addPoint(point);
            this.orderPoints();
        }
    }

    private boolean removePoint(Point point) {
        Point pointToRemove = null;
        for (Point currPoint : this.points) {
            if (currPoint.x != point.x || currPoint.y != point.y) continue;
            pointToRemove = currPoint;
            break;
        }
        if (pointToRemove != null) {
            this.points.remove(pointToRemove);
            return true;
        }
        return false;
    }

    private void orderPoints() {
        for (int i = 0; i < this.points.size(); ++i) {
            Point minPoint = null;
            for (int noteIdx = i; noteIdx < this.points.size(); ++noteIdx) {
                Point point = this.points.get(noteIdx);
                if (minPoint != null && point.x >= minPoint.x) continue;
                minPoint = point;
            }
            this.points.remove(minPoint);
            this.points.add(i, minPoint);
        }
    }

    private void removePointsAtXLine(int x) {
        ArrayList<Point> pointsToRemove = new ArrayList<Point>();
        for (Point point : this.points) {
            if (point.x != x) continue;
            pointsToRemove.add(point);
            break;
        }
        this.points.removeAll(pointsToRemove);
    }

    private void addPoint(Point point) {
        this.points.add(point);
    }

    private int getX(int pointX) {
        int currPointX = -1;
        for (int i = 0; i < this.x.length; ++i) {
            if (currPointX < 0) {
                currPointX = this.x[i];
                continue;
            }
            int distanceX = Math.abs(pointX - currPointX);
            int currDistanceX = Math.abs(pointX - this.x[i]);
            if (currDistanceX >= distanceX) continue;
            currPointX = this.x[i];
        }
        return currPointX;
    }

    private int getY(int pointY) {
        int currPointY = -1;
        for (int i = 0; i < this.y.length; ++i) {
            if (currPointY < 0) {
                currPointY = this.y[i];
                continue;
            }
            int distanceX = Math.abs(pointY - currPointY);
            int currDistanceX = Math.abs(pointY - this.y[i]);
            if (currDistanceX >= distanceX) continue;
            currPointY = this.y[i];
        }
        return currPointY;
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public TGEffectTremoloBar getTremoloBar() {
        if (this.points != null && !this.points.isEmpty()) {
            TGEffectTremoloBar tremoloBar = TuxGuitar.getInstance().getSongManager().getFactory().newEffectTremoloBar();
            for (Point point : this.points) {
                this.addTremoloBarPoint(tremoloBar, point);
            }
            return tremoloBar;
        }
        return null;
    }

    private void addTremoloBarPoint(TGEffectTremoloBar effect, Point point) {
        int i;
        int position = 0;
        int value = 0;
        for (i = 0; i < this.x.length; ++i) {
            if (point.x != this.x[i]) continue;
            position = i;
        }
        for (i = 0; i < this.y.length; ++i) {
            if (point.y != this.y[i]) continue;
            value = 12 - i;
        }
        effect.addPoint(position, value);
    }

    public void setTremoloBar(TGEffectTremoloBar effect) {
        this.points.clear();
        for (TGEffectTremoloBar.TremoloBarPoint tremoloBarPoint : effect.getPoints()) {
            this.makePoint(tremoloBarPoint);
        }
    }

    private void makePoint(TGEffectTremoloBar.TremoloBarPoint tremoloBarPoint) {
        int indexX = tremoloBarPoint.getPosition();
        int indexY = this.y.length - 12 - tremoloBarPoint.getValue() - 1;
        if (indexX >= 0 && indexX < this.x.length && indexY >= 0 && indexY < this.y.length) {
            Point point = new Point(0, 0);
            point.x = this.x[indexX];
            point.y = this.y[indexY];
            this.points.add(point);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private void resetDefaultTremoloBars() {
        this.defaultTremoloBars = new DefaultTremoloBar[6];
        this.defaultTremoloBars[0] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.dip"), TuxGuitar.getInstance().getSongManager().getFactory().newEffectTremoloBar());
        this.defaultTremoloBars[0].getTremoloBar().addPoint(0, 0);
        this.defaultTremoloBars[0].getTremoloBar().addPoint(6, -2);
        this.defaultTremoloBars[0].getTremoloBar().addPoint(12, 0);
        this.defaultTremoloBars[1] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.dive"), TuxGuitar.getInstance().getSongManager().getFactory().newEffectTremoloBar());
        this.defaultTremoloBars[1].getTremoloBar().addPoint(0, 0);
        this.defaultTremoloBars[1].getTremoloBar().addPoint(9, -2);
        this.defaultTremoloBars[1].getTremoloBar().addPoint(12, -2);
        this.defaultTremoloBars[2] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.release-up"), TuxGuitar.getInstance().getSongManager().getFactory().newEffectTremoloBar());
        this.defaultTremoloBars[2].getTremoloBar().addPoint(0, -2);
        this.defaultTremoloBars[2].getTremoloBar().addPoint(9, -2);
        this.defaultTremoloBars[2].getTremoloBar().addPoint(12, 0);
        this.defaultTremoloBars[3] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.inverted-dip"), TuxGuitar.getInstance().getSongManager().getFactory().newEffectTremoloBar());
        this.defaultTremoloBars[3].getTremoloBar().addPoint(0, 0);
        this.defaultTremoloBars[3].getTremoloBar().addPoint(6, 2);
        this.defaultTremoloBars[3].getTremoloBar().addPoint(12, 0);
        this.defaultTremoloBars[4] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.return"), TuxGuitar.getInstance().getSongManager().getFactory().newEffectTremoloBar());
        this.defaultTremoloBars[4].getTremoloBar().addPoint(0, 0);
        this.defaultTremoloBars[4].getTremoloBar().addPoint(9, 2);
        this.defaultTremoloBars[4].getTremoloBar().addPoint(12, 2);
        this.defaultTremoloBars[5] = new DefaultTremoloBar(TuxGuitar.getProperty("effects.tremolo-bar.release-down"), TuxGuitar.getInstance().getSongManager().getFactory().newEffectTremoloBar());
        this.defaultTremoloBars[5].getTremoloBar().addPoint(0, 2);
        this.defaultTremoloBars[5].getTremoloBar().addPoint(9, 2);
        this.defaultTremoloBars[5].getTremoloBar().addPoint(12, 0);
    }

    public void changeTremoloBar(TGContext context, TGMeasure measure, TGBeat beat, TGString string, TGEffectTremoloBar effect) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.note.effect.change-tremolo-bar");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
        tgActionProcessor.setAttribute(TGChangeTremoloBarAction.ATTRIBUTE_EFFECT, (Object)effect);
        tgActionProcessor.process();
    }

    private class DefaultTremoloBar {
        private String name;
        private TGEffectTremoloBar tremoloBar;

        public DefaultTremoloBar(String name, TGEffectTremoloBar tremoloBar) {
            this.name = name;
            this.tremoloBar = tremoloBar;
        }

        public TGEffectTremoloBar getTremoloBar() {
            return this.tremoloBar;
        }

        public String getName() {
            return this.name;
        }
    }
}

