/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.transport;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.editor.EditorCache;
import org.herac.tuxguitar.app.transport.TGTransport;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.util.TGProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcessLocked;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGTransportDialog
implements TGEventListener {
    private static final int PLAY_MODE_DELAY = 250;
    public static final int STATUS_STOPPED = 1;
    public static final int STATUS_PAUSED = 2;
    public static final int STATUS_RUNNING = 3;
    private TGContext context;
    private Shell dialog;
    private Label label;
    private ProgressBar tickProgress;
    private Button metronome;
    private Button mode;
    private ToolBar toolBar;
    private ToolItem first;
    private ToolItem last;
    private ToolItem previous;
    private ToolItem next;
    private ToolItem stop;
    private ToolItem play;
    private TGProcess loadPropertiesProcess;
    private TGProcess loadIconsProcess;
    private TGProcess updateItemsProcess;
    private TGProcess redrawPlayModeProcess;
    private boolean editingTickScale;
    private long redrawTime;
    private int status;

    public TGTransportDialog(TGContext context) {
        this.context = context;
        this.createSyncProcesses();
    }

    public void show() {
        this.dialog = DialogUtils.newDialog(TuxGuitar.getInstance().getShell(), 2144);
        this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("transport"));
        this.initComposites();
        this.initToolBar();
        this.redrawProgress();
        this.addListeners();
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TGTransportDialog.this.removeListeners();
                TuxGuitar.getInstance().updateCache(true);
            }
        });
        DialogUtils.openDialog(this.dialog, 10);
    }

    public void addListeners() {
        TuxGuitar.getInstance().getIconManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addRedrawListener((TGEventListener)this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getIconManager().removeLoader(this);
        TuxGuitar.getInstance().getLanguageManager().removeLoader(this);
        TuxGuitar.getInstance().getEditorManager().removeRedrawListener((TGEventListener)this);
        TuxGuitar.getInstance().getEditorManager().removeUpdateListener((TGEventListener)this);
    }

    private void initComposites() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        Composite composite = new Composite((Composite)this.dialog, 2048);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.initOptions(composite);
        this.initProgress(composite);
    }

    private void initOptions(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, false, true));
        this.metronome = new Button(composite, 2);
        this.metronome.setLayoutData((Object)new GridData(4, 4, true, true));
        this.metronome.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.transport.metronome"));
        this.mode = new Button(composite, 8);
        this.mode.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mode.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.gui.open-transport-mode-dialog"));
        this.loadOptionIcons();
    }

    private void initProgress(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.initLabel(composite);
        this.initScale(composite);
    }

    private void initLabel(Composite parent) {
        final Font font = new Font((Device)parent.getDisplay(), "Minisystem", 36, 0);
        this.label = new Label(parent, 131072);
        this.label.setLayoutData((Object)new GridData(4, 4, true, true));
        this.label.setBackground(parent.getDisplay().getSystemColor(2));
        this.label.setForeground(parent.getDisplay().getSystemColor(9));
        this.label.setFont(font);
        this.label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
    }

    private void initScale(Composite parent) {
        GridData data = new GridData(4, 0x1000000, true, false);
        data.heightHint = 10;
        this.tickProgress = new ProgressBar(parent, 67840);
        this.tickProgress.setCursor(this.tickProgress.getDisplay().getSystemCursor(21));
        this.tickProgress.setLayoutData((Object)data);
        this.tickProgress.setSelection(960);
        this.tickProgress.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TGTransportDialog.this.setEditingTickScale(true);
                TGTransportDialog.this.updateProgressBar(e.x);
            }

            public void mouseUp(MouseEvent e) {
                TGTransportDialog.this.gotoMeasure(TGTransportDialog.this.getSongManager().getMeasureHeaderAt(TGTransportDialog.this.getDocumentManager().getSong(), (long)TGTransportDialog.this.tickProgress.getSelection()), true);
                TGTransportDialog.this.setEditingTickScale(false);
            }
        });
        this.tickProgress.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                TGTransportDialog.this.updateProgressBar(e.x);
            }
        });
    }

    protected void updateProgressBar(int x) {
        if (this.isEditingTickScale()) {
            int selection = this.tickProgress.getMinimum() + x * (this.tickProgress.getMaximum() - this.tickProgress.getMinimum()) / this.tickProgress.getSize().x;
            this.tickProgress.setSelection(Math.max(960, selection));
            this.redrawProgress();
        }
    }

    private void initToolBar() {
        if (this.toolBar != null) {
            this.toolBar.dispose();
        }
        this.toolBar = new ToolBar((Composite)this.dialog, 0x800000);
        this.first = new ToolItem(this.toolBar, 8);
        this.first.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.measure.go-first"));
        this.previous = new ToolItem(this.toolBar, 8);
        this.previous.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.measure.go-previous"));
        this.stop = new ToolItem(this.toolBar, 8);
        this.stop.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.transport.stop"));
        this.play = new ToolItem(this.toolBar, 8);
        this.play.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.transport.play"));
        this.next = new ToolItem(this.toolBar, 8);
        this.next.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.measure.go-next"));
        this.last = new ToolItem(this.toolBar, 8);
        this.last.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.measure.go-last"));
        this.updateItems(true);
        this.loadProperties();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void updateItems() {
        this.updateItems(false);
    }

    public void updateItems(boolean force) {
        if (!this.isDisposed()) {
            int lastStatus = this.getStatus();
            if (TuxGuitar.getInstance().getPlayer().isRunning()) {
                this.setStatus(3);
            } else if (TuxGuitar.getInstance().getPlayer().isPaused()) {
                this.setStatus(2);
            } else {
                this.setStatus(1);
            }
            if (force || lastStatus != this.getStatus()) {
                if (this.getStatus() == 3) {
                    this.first.setImage(TuxGuitar.getInstance().getIconManager().getTransportFirst2());
                    this.last.setImage(TuxGuitar.getInstance().getIconManager().getTransportLast2());
                    this.previous.setImage(TuxGuitar.getInstance().getIconManager().getTransportPrevious2());
                    this.next.setImage(TuxGuitar.getInstance().getIconManager().getTransportNext2());
                    this.stop.setImage(TuxGuitar.getInstance().getIconManager().getTransportStop2());
                    this.play.setImage(TuxGuitar.getInstance().getIconManager().getTransportPause());
                } else if (this.getStatus() == 2) {
                    this.first.setImage(TuxGuitar.getInstance().getIconManager().getTransportFirst2());
                    this.last.setImage(TuxGuitar.getInstance().getIconManager().getTransportLast2());
                    this.previous.setImage(TuxGuitar.getInstance().getIconManager().getTransportPrevious2());
                    this.next.setImage(TuxGuitar.getInstance().getIconManager().getTransportNext2());
                    this.stop.setImage(TuxGuitar.getInstance().getIconManager().getTransportStop2());
                    this.play.setImage(TuxGuitar.getInstance().getIconManager().getTransportPlay2());
                } else if (this.getStatus() == 1) {
                    this.first.setImage(TuxGuitar.getInstance().getIconManager().getTransportFirst1());
                    this.last.setImage(TuxGuitar.getInstance().getIconManager().getTransportLast1());
                    this.previous.setImage(TuxGuitar.getInstance().getIconManager().getTransportPrevious1());
                    this.next.setImage(TuxGuitar.getInstance().getIconManager().getTransportNext1());
                    this.stop.setImage(TuxGuitar.getInstance().getIconManager().getTransportStop1());
                    this.play.setImage(TuxGuitar.getInstance().getIconManager().getTransportPlay1());
                }
                this.loadPlayText();
            }
            TGMeasureHeader first = this.getSongManager().getFirstMeasureHeader(this.getDocumentManager().getSong());
            TGMeasureHeader last = this.getSongManager().getLastMeasureHeader(this.getDocumentManager().getSong());
            this.tickProgress.setMinimum((int)first.getStart());
            this.tickProgress.setMaximum((int)(last.getStart() + last.getLength()) - 1);
            this.metronome.setSelection(TuxGuitar.getInstance().getPlayer().isMetronomeEnabled());
            this.redrawProgress();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty("transport"));
            this.stop.setToolTipText(TuxGuitar.getProperty("transport.stop"));
            this.first.setToolTipText(TuxGuitar.getProperty("transport.first"));
            this.last.setToolTipText(TuxGuitar.getProperty("transport.last"));
            this.previous.setToolTipText(TuxGuitar.getProperty("transport.previous"));
            this.next.setToolTipText(TuxGuitar.getProperty("transport.next"));
            this.metronome.setToolTipText(TuxGuitar.getProperty("transport.metronome"));
            this.mode.setToolTipText(TuxGuitar.getProperty("transport.mode"));
            this.loadPlayText();
        }
    }

    public void loadPlayText() {
        String property = TuxGuitar.getProperty(this.getStatus() == 3 ? "transport.pause" : "transport.start");
        this.play.setToolTipText(property);
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.initToolBar();
            this.loadOptionIcons();
            this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
            this.dialog.layout(true);
            this.dialog.pack(true);
        }
    }

    private void loadOptionIcons() {
        this.metronome.setImage(TuxGuitar.getInstance().getIconManager().getTransportMetronome());
        this.mode.setImage(TuxGuitar.getInstance().getIconManager().getTransportMode());
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public boolean isEditingTickScale() {
        return this.editingTickScale;
    }

    public void setEditingTickScale(boolean editingTickScale) {
        this.editingTickScale = editingTickScale;
    }

    protected TGSongManager getSongManager() {
        return TuxGuitar.getInstance().getSongManager();
    }

    protected TGDocumentManager getDocumentManager() {
        return TuxGuitar.getInstance().getDocumentManager();
    }

    public void gotoMeasure(TGMeasureHeader header, boolean moveCaret) {
        TGTransport.getInstance(this.context).gotoMeasure(header, moveCaret);
    }

    public void redrawProgress() {
        if (!this.isDisposed() && !TuxGuitar.getInstance().isLocked()) {
            if (this.isEditingTickScale()) {
                this.label.setText(Long.toString(this.tickProgress.getSelection()));
            } else if (!MidiPlayer.getInstance((TGContext)this.context).isRunning()) {
                long tickPosition = TablatureEditor.getInstance(this.context).getTablature().getCaret().getPosition();
                this.label.setText(Long.toString(tickPosition));
                this.tickProgress.setSelection((int)tickPosition);
            }
        }
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed()) {
            MidiPlayer player = MidiPlayer.getInstance((TGContext)this.context);
            if (!this.isEditingTickScale() && player.isRunning()) {
                EditorCache editorCache = TuxGuitar.getInstance().getEditorCache();
                long time = System.currentTimeMillis();
                if (time > this.redrawTime + 250L) {
                    long position = editorCache.getPlayStart() + (player.getTickPosition() - editorCache.getPlayTick());
                    this.label.setText(Long.toString(position));
                    this.tickProgress.setSelection((int)position);
                    this.redrawTime = time;
                }
            }
        }
    }

    public void createSyncProcesses() {
        this.loadPropertiesProcess = new TGSyncProcess(this.context, new Runnable(){

            public void run() {
                TGTransportDialog.this.loadProperties();
            }
        });
        this.loadIconsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TGTransportDialog.this.loadIcons();
            }
        });
        this.updateItemsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TGTransportDialog.this.updateItems();
            }
        });
        this.redrawPlayModeProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TGTransportDialog.this.redrawPlayingMode();
            }
        });
    }

    public void processRedrawEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("redrawMode");
        if (type == 2 || type == 3) {
            this.redrawPlayModeProcess.process();
        }
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 1) {
            this.updateItemsProcess.process();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-icon".equals(event.getEventType())) {
            this.loadIconsProcess.process();
        } else if ("language".equals(event.getEventType())) {
            this.loadPropertiesProcess.process();
        } else if ("ui-redraw".equals(event.getEventType())) {
            this.processRedrawEvent(event);
        } else if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        }
    }

    public static TGTransportDialog getInstance(TGContext context) {
        return (TGTransportDialog)TGSingletonUtil.getInstance((TGContext)context, (String)TGTransportDialog.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGTransportDialog>(){

            public TGTransportDialog createInstance(TGContext context) {
                return new TGTransportDialog(context);
            }
        });
    }
}

