/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.timesignature;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.util.TGContext;

public class TGTimeSignatureDialog {
    public void show(final TGViewContext context) {
        Shell parent = (Shell)context.getAttribute("parent");
        final TGSongManager songManager = (TGSongManager)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG_MANAGER);
        final TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final TGMeasureHeader header = (TGMeasureHeader)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("composition.timesignature"));
        Group timeSignature = new Group((Composite)dialog, 16);
        timeSignature.setLayout((Layout)new GridLayout(2, false));
        timeSignature.setLayoutData((Object)new GridData(4, 4, true, true));
        timeSignature.setText(TuxGuitar.getProperty("composition.timesignature"));
        TGTimeSignature currentTimeSignature = header.getTimeSignature();
        Label numeratorLabel = new Label((Composite)timeSignature, 0);
        numeratorLabel.setText(TuxGuitar.getProperty("composition.timesignature.Numerator"));
        final Combo numerator = new Combo((Composite)timeSignature, 12);
        for (int i = 1; i <= 32; ++i) {
            numerator.add(Integer.toString(i));
        }
        numerator.setText(Integer.toString(currentTimeSignature.getNumerator()));
        numerator.setLayoutData((Object)this.getComboData());
        Label denominatorLabel = new Label((Composite)timeSignature, 0);
        denominatorLabel.setText(TuxGuitar.getProperty("composition.timesignature.denominator"));
        final Combo denominator = new Combo((Composite)timeSignature, 12);
        for (int i = 1; i <= 32; i *= 2) {
            denominator.add(Integer.toString(i));
        }
        denominator.setText(Integer.toString(currentTimeSignature.getDenominator().getValue()));
        denominator.setLayoutData((Object)this.getComboData());
        Group check = new Group((Composite)dialog, 16);
        check.setLayout((Layout)new GridLayout());
        check.setText(TuxGuitar.getProperty("options"));
        check.setLayoutData((Object)new GridData(4, 4, true, true));
        final Button toEnd = new Button((Composite)check, 32);
        toEnd.setText(TuxGuitar.getProperty("composition.timesignature.to-the-end"));
        toEnd.setSelection(true);
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonOk = new Button(buttons, 8);
        buttonOk.setText(TuxGuitar.getProperty("ok"));
        buttonOk.setLayoutData((Object)this.getButtonData());
        buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGTimeSignatureDialog.this.changeTimeSignature(context.getContext(), song, header, TGTimeSignatureDialog.this.parseTimeSignature(songManager, numerator, denominator), toEnd.getSelection());
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOk);
        DialogUtils.openDialog(dialog, 10);
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private GridData getComboData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 150;
        return data;
    }

    public TGTimeSignature parseTimeSignature(TGSongManager songManager, Combo numerator, Combo denominator) {
        TGTimeSignature tgTimeSignature = songManager.getFactory().newTimeSignature();
        tgTimeSignature.setNumerator(Integer.parseInt(numerator.getText()));
        tgTimeSignature.getDenominator().setValue(Integer.parseInt(denominator.getText()));
        return tgTimeSignature;
    }

    public void changeTimeSignature(TGContext context, TGSong song, TGMeasureHeader header, TGTimeSignature timeSignature, Boolean applyToEnd) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.composition.change-time-signature");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, (Object)header);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TIME_SIGNATURE, (Object)timeSignature);
        tgActionProcessor.setAttribute("applyToEnd", (Object)applyToEnd);
        tgActionProcessor.processOnNewThread();
    }
}

