/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.settings.items;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.dialog.settings.TGSettingsEditor;
import org.herac.tuxguitar.app.view.dialog.settings.items.Option;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;

public class StylesOption
extends Option {
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 0;
    protected boolean initialized = false;
    protected FontData defaultFontData = new FontData();
    protected FontData noteFontData = new FontData();
    protected FontData timeSignatureFontData = new FontData();
    protected FontData textFontData = new FontData();
    protected FontData lyricFontData = new FontData();
    protected FontData printerDefaultFontData = new FontData();
    protected FontData printerNoteFontData = new FontData();
    protected FontData printerTSFontData = new FontData();
    protected FontData printerTextFontData = new FontData();
    protected FontData printerLyricFontData = new FontData();
    protected Button defaultFontButton;
    protected Button noteFontButton;
    protected Button timeSignatureFontButton;
    protected Button textFontButton;
    protected Button lyricFontButton;
    protected Button printerDefaultFontButton;
    protected Button printerNoteFontButton;
    protected Button printerTSFontButton;
    protected Button printerTextFontButton;
    protected Button printerLyricFontButton;
    protected ButtonColor scoreNoteColorButton;
    protected ButtonColor tabNoteColorButton;
    protected ButtonColor playNoteColorButton;
    protected ButtonColor linesColorButton;

    public StylesOption(TGSettingsEditor configEditor, ToolBar toolBar, Composite parent) {
        super(configEditor, toolBar, parent, TuxGuitar.getProperty("settings.config.styles"));
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.styles"));
        this.getToolItem().setImage(TuxGuitar.getInstance().getIconManager().getOptionStyle());
        this.getToolItem().addSelectionListener((SelectionListener)this);
        this.showLabel(this.getComposite(), 16576, 1, 0, TuxGuitar.getProperty("settings.config.styles.general"));
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)this.getTabbedData());
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.default"));
        this.defaultFontButton = this.createFontButton(composite, this.defaultFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.note"));
        this.noteFontButton = this.createFontButton(composite, this.noteFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.lyric"));
        this.lyricFontButton = this.createFontButton(composite, this.lyricFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.text"));
        this.textFontButton = this.createFontButton(composite, this.textFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.time-signature"));
        this.timeSignatureFontButton = this.createFontButton(composite, this.timeSignatureFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.score-note"));
        this.scoreNoteColorButton = new ButtonColor(composite, 8, this.makeButtonData(), TuxGuitar.getProperty("choose"));
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.tab-note"));
        this.tabNoteColorButton = new ButtonColor(composite, 8, this.makeButtonData(), TuxGuitar.getProperty("choose"));
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.play-note"));
        this.playNoteColorButton = new ButtonColor(composite, 8, this.makeButtonData(), TuxGuitar.getProperty("choose"));
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.lines"));
        this.linesColorButton = new ButtonColor(composite, 8, this.makeButtonData(), TuxGuitar.getProperty("choose"));
        this.showLabel(this.getComposite(), 16576, 1, 0, TuxGuitar.getProperty("settings.config.styles.printer"));
        composite = new Composite(this.getComposite(), 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)this.getTabbedData());
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.default"));
        this.printerDefaultFontButton = this.createFontButton(composite, this.printerDefaultFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.note"));
        this.printerNoteFontButton = this.createFontButton(composite, this.printerNoteFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.lyric"));
        this.printerLyricFontButton = this.createFontButton(composite, this.printerLyricFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.text"));
        this.printerTextFontButton = this.createFontButton(composite, this.printerTextFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.time-signature"));
        this.printerTSFontButton = this.createFontButton(composite, this.printerTSFontData);
        this.loadConfig();
    }

    private void addFontButtonListeners(final Button button, final FontData fontData) {
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (StylesOption.this.initialized) {
                    Font font = new Font((Device)StylesOption.this.getDisplay(), fontData);
                    FontData[] fontDataList = font.getFontData();
                    font.dispose();
                    FontDialog fontDialog = new FontDialog(StylesOption.this.getShell());
                    fontDialog.setFontList(fontDataList);
                    FontData result = fontDialog.open();
                    if (result != null) {
                        StylesOption.this.loadFontData(result, fontData, button);
                    }
                }
            }
        });
    }

    protected void loadFontData(FontData src, FontData dst, Button button) {
        this.copyFontData(src, dst);
        this.setButtonFontData(button, dst);
    }

    protected void loadColor(ButtonColor button, RGB rgb) {
        button.loadColor(rgb);
    }

    protected void setButtonFontData(Button button, FontData fontData) {
        String text = fontData.getName();
        if ((fontData.getStyle() & 1) != 0) {
            text = text + " Bold";
        }
        if ((fontData.getStyle() & 2) != 0) {
            text = text + " Italic";
        }
        text = text + " " + fontData.getHeight();
        button.setText(text);
    }

    protected void copyFontData(FontData src, FontData dst) {
        dst.setName(src.getName());
        dst.setStyle(src.getStyle());
        dst.setHeight(src.getHeight());
    }

    protected void copyRGB(RGB src, RGB dst) {
        dst.red = src.red;
        dst.green = src.green;
        dst.blue = src.blue;
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                final FontData defaultFontData = StylesOption.this.getConfig().getFontDataConfigValue("font.default");
                final FontData noteFontData = StylesOption.this.getConfig().getFontDataConfigValue("font.note");
                final FontData timeSignatureFontData = StylesOption.this.getConfig().getFontDataConfigValue("font.time-signature");
                final FontData textFontData = StylesOption.this.getConfig().getFontDataConfigValue("font.text");
                final FontData lyricFontData = StylesOption.this.getConfig().getFontDataConfigValue("font.lyric");
                final FontData printerDefaultFontData = StylesOption.this.getConfig().getFontDataConfigValue("font.printer.default");
                final FontData printerNoteFontData = StylesOption.this.getConfig().getFontDataConfigValue("font.printer.note");
                final FontData printerTSFontData = StylesOption.this.getConfig().getFontDataConfigValue("font.printer.time-signature");
                final FontData printerTextFontData = StylesOption.this.getConfig().getFontDataConfigValue("font.printer.text");
                final FontData printerLyricFontData = StylesOption.this.getConfig().getFontDataConfigValue("font.printer.lyric");
                final RGB scoreNoteRGB = StylesOption.this.getConfig().getRGBConfigValue("color.score.note");
                final RGB tabNoteRGB = StylesOption.this.getConfig().getRGBConfigValue("color.tab.note");
                final RGB playNoteRGB = StylesOption.this.getConfig().getRGBConfigValue("color.play.note");
                final RGB linesRGB = StylesOption.this.getConfig().getRGBConfigValue("color.line");
                TGSynchronizer.getInstance((TGContext)StylesOption.this.getViewContext().getContext()).executeLater(new Runnable(){

                    public void run() {
                        if (!StylesOption.this.isDisposed()) {
                            StylesOption.this.loadFontData(defaultFontData, StylesOption.this.defaultFontData, StylesOption.this.defaultFontButton);
                            StylesOption.this.loadFontData(noteFontData, StylesOption.this.noteFontData, StylesOption.this.noteFontButton);
                            StylesOption.this.loadFontData(timeSignatureFontData, StylesOption.this.timeSignatureFontData, StylesOption.this.timeSignatureFontButton);
                            StylesOption.this.loadFontData(textFontData, StylesOption.this.textFontData, StylesOption.this.textFontButton);
                            StylesOption.this.loadFontData(lyricFontData, StylesOption.this.lyricFontData, StylesOption.this.lyricFontButton);
                            StylesOption.this.loadFontData(printerDefaultFontData, StylesOption.this.printerDefaultFontData, StylesOption.this.printerDefaultFontButton);
                            StylesOption.this.loadFontData(printerNoteFontData, StylesOption.this.printerNoteFontData, StylesOption.this.printerNoteFontButton);
                            StylesOption.this.loadFontData(printerTSFontData, StylesOption.this.printerTSFontData, StylesOption.this.printerTSFontButton);
                            StylesOption.this.loadFontData(printerTextFontData, StylesOption.this.printerTextFontData, StylesOption.this.printerTextFontButton);
                            StylesOption.this.loadFontData(printerLyricFontData, StylesOption.this.printerLyricFontData, StylesOption.this.printerLyricFontButton);
                            StylesOption.this.scoreNoteColorButton.loadColor(scoreNoteRGB);
                            StylesOption.this.tabNoteColorButton.loadColor(tabNoteRGB);
                            StylesOption.this.playNoteColorButton.loadColor(playNoteRGB);
                            StylesOption.this.linesColorButton.loadColor(linesRGB);
                            StylesOption.this.initialized = true;
                            StylesOption.this.pack();
                        }
                    }
                });
            }
        }).start();
    }

    public Button createFontButton(Composite parent, FontData fontData) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)this.makeButtonData());
        button.setText("-");
        this.addFontButtonListeners(button, fontData);
        return button;
    }

    public GridData makeButtonData() {
        GridData data = new GridData(4, 0x1000000, true, true);
        data.minimumWidth = 200;
        data.minimumHeight = 0;
        return data;
    }

    public void updateConfig() {
        if (this.initialized) {
            this.getConfig().setValue("font.default", this.defaultFontData);
            this.getConfig().setValue("font.note", this.noteFontData);
            this.getConfig().setValue("font.time-signature", this.timeSignatureFontData);
            this.getConfig().setValue("font.text", this.textFontData);
            this.getConfig().setValue("font.lyric", this.lyricFontData);
            this.getConfig().setValue("font.printer.default", this.printerDefaultFontData);
            this.getConfig().setValue("font.printer.note", this.printerNoteFontData);
            this.getConfig().setValue("font.printer.time-signature", this.printerTSFontData);
            this.getConfig().setValue("font.printer.text", this.printerTextFontData);
            this.getConfig().setValue("font.printer.lyric", this.printerLyricFontData);
            this.getConfig().setValue("color.score.note", this.scoreNoteColorButton.getValue());
            this.getConfig().setValue("color.tab.note", this.tabNoteColorButton.getValue());
            this.getConfig().setValue("color.play.note", this.playNoteColorButton.getValue());
            this.getConfig().setValue("color.line", this.linesColorButton.getValue());
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setValue("font.default", this.getDefaults().getValue("font.default"));
            this.getConfig().setValue("font.note", this.getDefaults().getValue("font.note"));
            this.getConfig().setValue("font.time-signature", this.getDefaults().getValue("font.time-signature"));
            this.getConfig().setValue("font.text", this.getDefaults().getValue("font.text"));
            this.getConfig().setValue("font.lyric", this.getDefaults().getValue("font.lyric"));
            this.getConfig().setValue("font.printer.default", this.getDefaults().getValue("font.printer.default"));
            this.getConfig().setValue("font.printer.note", this.getDefaults().getValue("font.printer.note"));
            this.getConfig().setValue("font.printer.time-signature", this.getDefaults().getValue("font.printer.time-signature"));
            this.getConfig().setValue("font.printer.text", this.getDefaults().getValue("font.printer.text"));
            this.getConfig().setValue("font.printer.lyric", this.getDefaults().getValue("font.printer.lyric"));
            this.getConfig().setValue("color.score.note", this.getDefaults().getValue("color.score.note"));
            this.getConfig().setValue("color.tab.note", this.getDefaults().getValue("color.tab.note"));
            this.getConfig().setValue("color.play.note", this.getDefaults().getValue("color.play.note"));
            this.getConfig().setValue("color.line", this.getDefaults().getValue("color.line"));
        }
    }

    private class ButtonColor {
        protected Button button;
        protected Color color;
        protected RGB value = new RGB(0, 0, 0);

        public ButtonColor(Composite parent, int style, Object layoutData, String text) {
            this.button = new Button(parent, style);
            this.button.setLayoutData(layoutData);
            this.button.setText(text);
            this.addListeners();
        }

        protected void loadColor(RGB rgb) {
            this.value.red = rgb.red;
            this.value.green = rgb.green;
            this.value.blue = rgb.blue;
            Color color = new Color((Device)this.button.getDisplay(), this.value);
            this.button.setForeground(color);
            this.disposeColor();
            this.color = color;
        }

        protected void disposeColor() {
            if (this.color != null && !this.color.isDisposed()) {
                this.color.dispose();
                this.color = null;
            }
        }

        private void addListeners() {
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (StylesOption.this.initialized) {
                        ColorDialog dlg = new ColorDialog(StylesOption.this.getShell());
                        dlg.setRGB(ButtonColor.this.value);
                        dlg.setText(TuxGuitar.getProperty("choose-color"));
                        RGB result = dlg.open();
                        if (result != null) {
                            ButtonColor.this.loadColor(result);
                        }
                    }
                }
            });
            this.button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ButtonColor.this.disposeColor();
                }
            });
        }

        protected RGB getValue() {
            return this.value;
        }
    }
}

