/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.settings.items;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.settings.TGSettingsEditor;
import org.herac.tuxguitar.util.properties.TGProperties;

public abstract class Option
extends SelectionAdapter {
    protected static final int DEFAULT_INDENT = 20;
    private TGSettingsEditor configEditor;
    private ToolBar toolBar;
    private Group group;
    private Composite composite;
    private ToolItem toolItem;

    public Option(TGSettingsEditor configEditor, ToolBar toolBar, Composite parent, String text, int horizontalAlignment, int verticalAlignment) {
        this.configEditor = configEditor;
        this.toolBar = toolBar;
        this.toolItem = new ToolItem(toolBar, 16);
        this.group = new Group(parent, 16);
        this.group.setLayout((Layout)new GridLayout());
        this.group.setLayoutData((Object)this.getGroupData());
        this.group.setText(text);
        this.composite = new Composite((Composite)this.group, 16);
        this.composite.setLayout((Layout)new GridLayout());
        this.composite.setLayoutData((Object)new GridData(horizontalAlignment, verticalAlignment, true, true));
    }

    public Option(TGSettingsEditor configEditor, ToolBar toolBar, Composite parent, String text) {
        this(configEditor, toolBar, parent, text, 4, 128);
    }

    public abstract void createOption();

    public abstract void updateConfig();

    public abstract void updateDefaults();

    public void setVisible(boolean visible) {
        this.toolItem.setSelection(visible);
        this.group.setVisible(visible);
        this.group.setFocus();
        if (visible) {
            this.group.layout(true, true);
        }
        this.group.redraw();
    }

    public void dispose() {
    }

    protected Label showLabel(Composite parent, int labelStyle, int fontStyle, int fontScale, String text) {
        return this.showLabel(parent, 4, 0x1000000, labelStyle, fontStyle, fontScale, text);
    }

    protected Label showLabel(Composite parent, int hAlign, int vAlign, int labelStyle, int fontStyle, int fontScale, String text) {
        return this.showLabel(parent, hAlign, vAlign, true, true, labelStyle, fontStyle, fontScale, text);
    }

    protected Label showLabel(Composite parent, int hAlign, int vAlign, boolean grabExcessHSpace, boolean grabExcessVSpace, int labelStyle, int fontStyle, int fontScale, String text) {
        Label label = new Label(parent, labelStyle);
        label.setText(text);
        label.setLayoutData((Object)new GridData(hAlign, vAlign, grabExcessHSpace, grabExcessVSpace));
        FontData[] fontDatas = label.getFont().getFontData();
        if (fontDatas.length > 0) {
            final Font font = new Font((Device)label.getDisplay(), fontDatas[0].getName(), fontDatas[0].getHeight() + fontScale, fontStyle);
            label.setFont(font);
            label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    font.dispose();
                }
            });
        }
        return label;
    }

    protected Label showImageLabel(Composite parent, int labelStyle, Image image) {
        Label label = new Label(parent, labelStyle);
        label.setImage(image);
        return label;
    }

    protected FormData getGroupData() {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    public void widgetSelected(SelectionEvent e) {
        this.configEditor.select(this);
    }

    public Composite getComposite() {
        return this.composite;
    }

    public ToolItem getToolItem() {
        return this.toolItem;
    }

    public Point computeSize() {
        return this.computeSize(-1, -1);
    }

    protected Point computeSize(int wHint, int hHint) {
        return this.group.computeSize(wHint, hHint);
    }

    public TGConfigManager getConfig() {
        return this.configEditor.getConfig();
    }

    public TGViewContext getViewContext() {
        return this.configEditor.getViewContext();
    }

    public TGProperties getDefaults() {
        return this.configEditor.getDefaults();
    }

    public TablatureEditor getEditor() {
        return this.configEditor.getEditor();
    }

    public Display getDisplay() {
        return this.toolBar.getDisplay();
    }

    public Shell getShell() {
        return this.toolBar.getShell();
    }

    protected boolean isDisposed() {
        return this.toolBar.isDisposed() || this.toolBar.getShell().isDisposed();
    }

    public GridData makeGridData(int with, int height, int minWith, int minHeight) {
        return this.configEditor.makeGridData(with, height, minWith, minHeight);
    }

    protected GridData getTabbedData() {
        return this.getTabbedData(20, 4, 0x1000000);
    }

    protected GridData getTabbedData(int horizontalAlignment, int verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace) {
        return this.getTabbedData(20, horizontalAlignment, verticalAlignment, grabExcessHorizontalSpace, grabExcessVerticalSpace);
    }

    protected GridData getTabbedData(int horizontalAlignment, int verticalAlignment) {
        return this.getTabbedData(20, horizontalAlignment, verticalAlignment);
    }

    protected GridData getTabbedData(int indent, int horizontalAlignment, int verticalAlignment) {
        return this.getTabbedData(indent, horizontalAlignment, verticalAlignment, true, true);
    }

    protected GridData getTabbedData(int indent, int horizontalAlignment, int verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace) {
        GridData data = new GridData();
        data.horizontalAlignment = horizontalAlignment;
        data.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        data.verticalAlignment = verticalAlignment;
        data.grabExcessVerticalSpace = grabExcessVerticalSpace;
        data.horizontalIndent = indent;
        return data;
    }

    public GridData makeGridData(int widthHint, int heightHint, int minimumWidth, int minimumHeight, int horizontalAlignment, int verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, int horizontalSpan, int verticalSpan) {
        GridData data = new GridData();
        data.widthHint = widthHint;
        data.heightHint = heightHint;
        data.minimumWidth = minimumWidth;
        data.minimumHeight = minimumHeight;
        data.horizontalAlignment = horizontalAlignment;
        data.verticalAlignment = verticalAlignment;
        data.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        data.grabExcessVerticalSpace = grabExcessVerticalSpace;
        data.horizontalSpan = horizontalSpan;
        data.verticalSpan = verticalSpan;
        return data;
    }

    public void pack() {
        this.configEditor.pack();
    }

    public void loadCursor(int style) {
        this.configEditor.loadCursor(style);
    }

    protected void addSyncThread(Runnable runnable) {
        this.configEditor.addSyncThread(runnable);
    }
}

