/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.repeat;

import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class TGRepeatAlternativeDialog {
    public void show(final TGViewContext context) {
        final TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final TGMeasureHeader header = (TGMeasureHeader)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
        int existentEndings = this.getExistentEndings(song, header);
        int selectedEndings = header.getRepeatAlternative() > 0 ? header.getRepeatAlternative() : this.getDefaultEndings(existentEndings);
        Shell parent = (Shell)context.getAttribute("parent");
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("repeat.alternative.editor"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout(4, true));
        group.setLayoutData((Object)this.getMainData());
        group.setText(TuxGuitar.getProperty("repeat.alternative"));
        final Button[] selections = new Button[8];
        for (int i = 0; i < selections.length; ++i) {
            boolean enabled = (existentEndings & 1 << i) == 0;
            selections[i] = new Button((Composite)group, 32);
            selections[i].setText(Integer.toString(i + 1));
            selections[i].setLayoutData((Object)new GridData(4, 4, true, true));
            selections[i].setEnabled(enabled);
            selections[i].setSelection(enabled && (selectedEndings & 1 << i) != 0);
        }
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int values = 0;
                for (int i = 0; i < selections.length; ++i) {
                    values |= selections[i].getSelection() ? 1 << i : 0;
                }
                TGRepeatAlternativeDialog.this.changeRepeatAlternative(context.getContext(), song, header, values);
                dialog.dispose();
            }
        });
        Button buttonClean = new Button(buttons, 8);
        buttonClean.setText(TuxGuitar.getProperty("clean"));
        buttonClean.setLayoutData((Object)this.getButtonData());
        buttonClean.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGRepeatAlternativeDialog.this.changeRepeatAlternative(context.getContext(), song, header, 0);
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    private GridData getMainData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 350;
        return data;
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    protected int getExistentEndings(TGSong song, TGMeasureHeader header) {
        TGMeasureHeader currentHeader;
        int existentEndings = 0;
        Iterator it = song.getMeasureHeaders();
        while (it.hasNext() && (currentHeader = (TGMeasureHeader)it.next()).getNumber() != header.getNumber()) {
            if (currentHeader.isRepeatOpen()) {
                existentEndings = 0;
            }
            existentEndings |= currentHeader.getRepeatAlternative();
        }
        return existentEndings;
    }

    protected int getDefaultEndings(int existentEndings) {
        for (int i = 0; i < 8; ++i) {
            if ((existentEndings & 1 << i) != 0) continue;
            return 1 << i;
        }
        return -1;
    }

    public void changeRepeatAlternative(TGContext context, TGSong song, TGMeasureHeader header, Integer repeatAlternative) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.insert.close-alternative");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, (Object)header);
        tgActionProcessor.setAttribute("repeatAlternative", (Object)repeatAlternative);
        tgActionProcessor.processOnNewThread();
    }
}

