/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.plugin;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.util.plugin.TGPluginInfo;

public class TGPluginInfoDialog {
    public static String ATTRIBUTE_MODULE_ID = "moduleId";

    public void show(TGViewContext context) {
        String moduleId = (String)context.getAttribute(ATTRIBUTE_MODULE_ID);
        Shell parent = (Shell)context.getAttribute("parent");
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        TGPluginInfo pluginInfo = new TGPluginInfo(context.getContext(), moduleId);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setLayoutData((Object)new GridData(4, 4, true, true));
        dialog.setText(TuxGuitar.getProperty("plugins"));
        Composite info = new Composite((Composite)dialog, 0);
        info.setLayout((Layout)new GridLayout(2, false));
        this.showInfoString(info, TuxGuitar.getProperty("name") + ":", pluginInfo.getName());
        this.showInfoString(info, TuxGuitar.getProperty("version") + ":", pluginInfo.getVersion());
        this.showInfoString(info, TuxGuitar.getProperty("author") + ":", pluginInfo.getAuthor());
        this.showInfoString(info, TuxGuitar.getProperty("description") + ":", pluginInfo.getDescription());
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button buttonExit = new Button(buttons, 8);
        buttonExit.setText(TuxGuitar.getProperty("exit"));
        buttonExit.setLayoutData((Object)this.getButtonData());
        buttonExit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonExit);
        DialogUtils.openDialog(dialog, 10);
    }

    private void showInfoString(Composite parent, String key, String value) {
        Label labelKey = new Label(parent, 16384);
        Label labelValue = new Label(parent, 16448);
        labelKey.setLayoutData((Object)new GridData(16384, 128, false, true));
        labelValue.setLayoutData((Object)new GridData(4, 128, true, true));
        this.setBold(labelKey);
        labelKey.setText(key);
        labelValue.setText(value != null && value.length() > 0 ? value : TuxGuitar.getProperty("plugin.unknown-value"));
    }

    private void setBold(Label label) {
        FontData[] fontDatas = label.getFont().getFontData();
        if (fontDatas.length > 0) {
            final Font font = new Font((Device)label.getDisplay(), fontDatas[0].getName(), fontDatas[0].getHeight(), 1);
            label.setFont(font);
            label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    font.dispose();
                }
            });
        }
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }
}

