/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.measure;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class TGMeasureAddDialog {
    public void show(final TGViewContext context) {
        final TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final TGMeasureHeader header = (TGMeasureHeader)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
        Shell parent = (Shell)context.getAttribute("parent");
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("measure.add"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("measure.add"));
        Label countLabel = new Label((Composite)group, 0);
        countLabel.setText(TuxGuitar.getProperty("measure.add.count"));
        final Spinner countSpinner = new Spinner((Composite)group, 2048);
        countSpinner.setLayoutData((Object)this.getSpinnerData());
        countSpinner.setMinimum(1);
        countSpinner.setMaximum(100);
        countSpinner.setSelection(1);
        Group options = new Group((Composite)dialog, 16);
        options.setLayout((Layout)new GridLayout());
        options.setLayoutData((Object)new GridData(4, 4, true, true));
        options.setText(TuxGuitar.getProperty("options"));
        final Button beforePosition = new Button((Composite)options, 16);
        beforePosition.setText(TuxGuitar.getProperty("measure.add-before-current-position"));
        final Button afterPosition = new Button((Composite)options, 16);
        afterPosition.setText(TuxGuitar.getProperty("measure.add-after-current-position"));
        final Button atEnd = new Button((Composite)options, 16);
        atEnd.setText(TuxGuitar.getProperty("measure.add-at-end"));
        atEnd.setSelection(true);
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int number = 0;
                int count = countSpinner.getSelection();
                if (beforePosition.getSelection()) {
                    number = header.getNumber();
                } else if (afterPosition.getSelection()) {
                    number = header.getNumber() + 1;
                } else if (atEnd.getSelection()) {
                    number = song.countMeasureHeaders() + 1;
                }
                TGMeasureAddDialog.this.processAction(context.getContext(), song, number, count);
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    private GridData getSpinnerData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 150;
        return data;
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    public void processAction(TGContext context, TGSong song, Integer number, Integer count) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.measure.add-list");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
        tgActionProcessor.setAttribute("measureCount", (Object)count);
        tgActionProcessor.setAttribute("measureNumber", (Object)number);
        tgActionProcessor.process();
    }
}

