/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.matrix;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.config.TGConfigDefaults;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.util.properties.TGProperties;

public class TGMatrixConfig {
    private Font font;
    private Color[] colorLines;
    private Color colorForeground;
    private Color colorBorder;
    private Color colorPosition;
    private Color colorNote;
    private Color colorPlay;
    private static final int MINIMUM_CONTROL_WIDTH = 180;
    private static final int MINIMUM_BUTTON_WIDTH = 80;
    private static final int MINIMUM_BUTTON_HEIGHT = 25;

    public Font getFont() {
        return this.font;
    }

    public Color getColorForeground() {
        return this.colorForeground;
    }

    public Color getColorBorder() {
        return this.colorBorder;
    }

    public Color getColorPosition() {
        return this.colorPosition;
    }

    public Color getColorNote() {
        return this.colorNote;
    }

    public Color getColorPlay() {
        return this.colorPlay;
    }

    public Color[] getColorLines() {
        return this.colorLines;
    }

    public Color getColorLine(int index) {
        return this.colorLines[index];
    }

    public void load() {
        Display display = TuxGuitar.getInstance().getDisplay();
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        this.font = new Font((Device)display, config.getFontDataConfigValue("matrix.font"));
        this.colorForeground = new Color((Device)display, config.getRGBConfigValue("matrix.color.foreground"));
        this.colorBorder = new Color((Device)display, config.getRGBConfigValue("matrix.color.border"));
        this.colorPosition = new Color((Device)display, config.getRGBConfigValue("matrix.color.position"));
        this.colorNote = new Color((Device)display, config.getRGBConfigValue("matrix.color.note"));
        this.colorPlay = new Color((Device)display, config.getRGBConfigValue("matrix.color.play-note"));
        this.colorLines = new Color[]{new Color((Device)display, config.getRGBConfigValue("matrix.color.line-1")), new Color((Device)display, config.getRGBConfigValue("matrix.color.line-2")), new Color((Device)display, config.getRGBConfigValue("matrix.color.line-3"))};
    }

    public void defaults() {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        TGProperties defaults = TGConfigDefaults.createDefaults();
        config.setValue("matrix.font", defaults.getValue("matrix.font"));
        config.setValue("matrix.color.foreground", defaults.getValue("matrix.color.foreground"));
        config.setValue("matrix.color.border", defaults.getValue("matrix.color.border"));
        config.setValue("matrix.color.position", defaults.getValue("matrix.color.position"));
        config.setValue("matrix.color.note", defaults.getValue("matrix.color.note"));
        config.setValue("matrix.color.play-note", defaults.getValue("matrix.color.play-note"));
        config.setValue("matrix.color.line-1", defaults.getValue("matrix.color.line-1"));
        config.setValue("matrix.color.line-2", defaults.getValue("matrix.color.line-2"));
        config.setValue("matrix.color.line-3", defaults.getValue("matrix.color.line-3"));
    }

    public void save(FontData fontData, RGB rgbForeground, RGB rgbBorder, RGB rgbPosition, RGB rgbNote, RGB rgbPlay, RGB[] rgbLines) {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        config.setValue("matrix.font", fontData);
        config.setValue("matrix.color.foreground", rgbForeground);
        config.setValue("matrix.color.border", rgbBorder);
        config.setValue("matrix.color.position", rgbPosition);
        config.setValue("matrix.color.note", rgbNote);
        config.setValue("matrix.color.play-note", rgbPlay);
        config.setValue("matrix.color.line-1", rgbLines[0]);
        config.setValue("matrix.color.line-2", rgbLines[1]);
        config.setValue("matrix.color.line-3", rgbLines[2]);
    }

    public void dispose() {
        this.dispose((Resource)this.font);
        this.dispose((Resource)this.colorForeground);
        this.dispose((Resource)this.colorBorder);
        this.dispose((Resource)this.colorPosition);
        this.dispose((Resource)this.colorNote);
        this.dispose((Resource)this.colorPlay);
        this.dispose((Resource[])this.colorLines);
    }

    protected void dispose(Resource[] resources) {
        if (resources != null) {
            for (int i = 0; i < resources.length; ++i) {
                this.dispose(resources[i]);
            }
        }
    }

    protected void dispose(Resource resource) {
        if (resource != null) {
            resource.dispose();
        }
    }

    public void configure(Shell shell) {
        final Shell dialog = DialogUtils.newDialog(shell, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("matrix.settings"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("matrix.settings"));
        final FontData fontData = this.getFontChooser((Composite)group, TuxGuitar.getProperty("matrix.font"), this.font.getFontData()[0]);
        final RGB rgbForeground = this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.foreground-color"), this.colorForeground.getRGB());
        final RGB[] rgbLines = new RGB[]{this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.line-color-1"), this.colorLines[0].getRGB()), this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.line-color-2"), this.colorLines[1].getRGB()), this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.line-color-over"), this.colorLines[2].getRGB())};
        final RGB rgbBorder = this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.border-color"), this.colorBorder.getRGB());
        final RGB rgbPosition = this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.position-color"), this.colorPosition.getRGB());
        final RGB rgbNote = this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.note-color"), this.colorNote.getRGB());
        final RGB rgbPlay = this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.play-note-color"), this.colorPlay.getRGB());
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonDefaults = new Button(buttons, 8);
        buttonDefaults.setText(TuxGuitar.getProperty("defaults"));
        buttonDefaults.setLayoutData((Object)this.getButtonData());
        buttonDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
                TGMatrixConfig.this.defaults();
                TGMatrixConfig.this.applyChanges();
            }
        });
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
                TGMatrixConfig.this.save(fontData, rgbForeground, rgbBorder, rgbPosition, rgbNote, rgbPlay, rgbLines);
                TGMatrixConfig.this.applyChanges();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    protected GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    protected void applyChanges() {
        this.dispose();
        this.load();
    }

    private RGB getColorChooser(Composite parent, String title, RGB rgb) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label.setText(title);
        ButtonColor button = new ButtonColor(parent, 8, TuxGuitar.getProperty("choose"));
        button.setLayoutData(this.getAlignmentData(180, 4));
        button.loadColor(rgb);
        return button.getValue();
    }

    private FontData getFontChooser(final Composite parent, String title, FontData fontData) {
        final FontData selection = new FontData(fontData.getName(), fontData.getHeight(), fontData.getStyle());
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label.setText(title);
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)this.getAlignmentData(180, 4));
        button.setText(TuxGuitar.getProperty("choose"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Font font = new Font((Device)parent.getDisplay(), selection);
                FontDialog fontDialog = new FontDialog(parent.getShell());
                fontDialog.setFontList(font.getFontData());
                FontData fd = fontDialog.open();
                if (fd != null) {
                    selection.setName(fd.getName());
                    selection.setHeight(fd.getHeight());
                    selection.setStyle(fd.getStyle());
                }
                font.dispose();
            }
        });
        return selection;
    }

    private GridData getAlignmentData(int minimumWidth, int horizontalAlignment) {
        GridData data = new GridData();
        data.minimumWidth = minimumWidth;
        data.horizontalAlignment = horizontalAlignment;
        data.verticalAlignment = -1;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        return data;
    }

    private class ButtonColor {
        protected Button button;
        protected Color color;
        protected RGB value = new RGB(0, 0, 0);

        public ButtonColor(Composite parent, int style, String text) {
            this.button = new Button(parent, style);
            this.button.setText(text);
            this.addListeners();
        }

        protected void setLayoutData(Object layoutData) {
            this.button.setLayoutData(layoutData);
        }

        protected void loadColor(RGB rgb) {
            this.value.red = rgb.red;
            this.value.green = rgb.green;
            this.value.blue = rgb.blue;
            Color color = new Color((Device)this.button.getDisplay(), this.value);
            this.button.setForeground(color);
            this.disposeColor();
            this.color = color;
        }

        protected void disposeColor() {
            if (this.color != null && !this.color.isDisposed()) {
                this.color.dispose();
                this.color = null;
            }
        }

        private void addListeners() {
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ColorDialog dlg = new ColorDialog(ButtonColor.this.button.getShell());
                    dlg.setRGB(ButtonColor.this.value);
                    dlg.setText(TuxGuitar.getProperty("choose-color"));
                    RGB result = dlg.open();
                    if (result != null) {
                        ButtonColor.this.loadColor(result);
                    }
                }
            });
            this.button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ButtonColor.this.disposeColor();
                }
            });
        }

        protected RGB getValue() {
            return this.value;
        }
    }
}

