/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.keybindings;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.impl.view.TGOpenViewAction;
import org.herac.tuxguitar.app.system.keybindings.KeyBinding;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingAction;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.dialog.confirm.TGConfirmDialog;
import org.herac.tuxguitar.app.view.dialog.confirm.TGConfirmDialogController;
import org.herac.tuxguitar.app.view.dialog.keybindings.TGKeyBindingEditor;
import org.herac.tuxguitar.app.view.dialog.keybindings.TGKeyBindingSelectorHandler;
import org.herac.tuxguitar.editor.action.TGActionProcessor;

public class TGKeyBindingSelector {
    public static final String ATTRIBUTE_EDITOR = TGKeyBindingEditor.class.getName();
    public static final String ATTRIBUTE_KB_ACTION = KeyBindingAction.class.getName();
    private Shell dialog;
    private TGKeyBindingEditor editor;
    private KeyBindingAction keyBindingAction;
    private TGKeyBindingSelectorHandler handler;

    public TGKeyBindingSelector(TGKeyBindingEditor editor, KeyBindingAction keyBindingAction, TGKeyBindingSelectorHandler handler) {
        this.editor = editor;
        this.keyBindingAction = keyBindingAction;
        this.handler = handler;
    }

    public void select(Shell parent) {
        this.dialog = DialogUtils.newDialog(parent, 67680);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setLayoutData((Object)new GridData(4, 4, true, true));
        this.dialog.setText(TuxGuitar.getProperty("key-bindings-editor"));
        Group group = new Group((Composite)this.dialog, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty(this.keyBindingAction.getAction()));
        final Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFocus();
        composite.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                TGKeyBindingSelector.this.handleSelection(new KeyBinding(e.keyCode, e.stateMask));
                TGKeyBindingSelector.this.dialog.dispose();
            }
        });
        Label iconLabel = new Label(composite, 0x1000000);
        iconLabel.setImage(iconLabel.getDisplay().getSystemImage(2));
        iconLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        Label textLabel = new Label(composite, 0x1000000);
        textLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        textLabel.setText(TuxGuitar.getProperty("key-bindings-editor-push-a-key"));
        FontData[] fd = textLabel.getFont().getFontData();
        if (fd != null && fd.length > 0) {
            final Font font = new Font((Device)textLabel.getDisplay(), new FontData(fd[0].getName(), 14, 1));
            textLabel.setFont(font);
            textLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    font.dispose();
                }
            });
        }
        Composite buttons = new Composite((Composite)this.dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button buttonClean = new Button(buttons, 8);
        buttonClean.setText(TuxGuitar.getProperty("clean"));
        buttonClean.setLayoutData((Object)this.getButtonData());
        buttonClean.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                composite.setFocus();
            }
        });
        buttonClean.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGKeyBindingSelector.this.dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                composite.setFocus();
            }
        });
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGKeyBindingSelector.this.dialog.dispose();
            }
        });
        DialogUtils.openDialog(this.dialog, 10);
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    public void handleSelection(final KeyBinding kb) {
        if (kb.isSameAs(this.keyBindingAction.getKeyBinding()) || !this.editor.exists(kb)) {
            this.handler.handleSelection(kb);
        } else {
            TGActionProcessor tgActionProcessor = new TGActionProcessor(this.editor.getContext().getContext(), "action.gui.open-view");
            tgActionProcessor.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGConfirmDialogController());
            tgActionProcessor.setAttribute("message", (Object)TuxGuitar.getProperty("key-bindings-editor-override"));
            tgActionProcessor.setAttribute("style", (Object)(TGConfirmDialog.BUTTON_YES | TGConfirmDialog.BUTTON_NO));
            tgActionProcessor.setAttribute("defaultButton", (Object)TGConfirmDialog.BUTTON_NO);
            tgActionProcessor.setAttribute("yesRunnable", (Object)new Runnable(){

                public void run() {
                    TGKeyBindingSelector.this.handler.handleSelection(kb);
                }
            });
            tgActionProcessor.process();
        }
    }
}

