/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.fretboard;

import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.editor.TGExternalBeatViewerManager;
import org.herac.tuxguitar.app.view.dialog.fretboard.TGFretBoard;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.editor.TGEditorManager;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGFretBoardEditor
implements TGEventListener {
    private TGContext context;
    private TGFretBoard fretBoard;
    private boolean visible;

    public TGFretBoardEditor(TGContext context) {
        this.context = context;
        this.appendListeners();
    }

    public void appendListeners() {
        TuxGuitar.getInstance().getIconManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getScaleManager().addListener(this);
    }

    private TGFretBoard getFretBoard() {
        return this.fretBoard;
    }

    public void hideFretBoard() {
        this.visible = false;
        this.getFretBoard().setVisible(this.visible);
        TGEditorManager.getInstance((TGContext)this.context).removeRedrawListener((TGEventListener)this);
        TGExternalBeatViewerManager.getInstance(this.context).removeBeatViewerListener(this);
        TGWindow tgWindow = TGWindow.getInstance(this.context);
        tgWindow.updateShellFooter(0, 0, 0);
    }

    public void showFretBoard() {
        this.visible = true;
        this.getFretBoard().setVisible(this.visible);
        TGEditorManager.getInstance((TGContext)this.context).addRedrawListener((TGEventListener)this);
        TGExternalBeatViewerManager.getInstance(this.context).addBeatViewerListener(this);
        TGWindow tgWindow = TGWindow.getInstance(this.context);
        tgWindow.updateShellFooter(this.getFretBoard().getHeight(), 730, 520);
    }

    public void showFretBoard(Composite parent) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.fretBoard = new TGFretBoard(this.context, parent);
        this.fretBoard.setLayoutData(data);
    }

    public void dispose() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().dispose();
        }
    }

    public void redraw() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().redraw();
        }
    }

    public void redrawPlayingMode() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed() && !TuxGuitar.getInstance().isLocked()) {
            this.getFretBoard().redrawPlayingMode();
        }
    }

    public boolean isVisible() {
        return this.getFretBoard() != null && !this.getFretBoard().isDisposed() && this.visible;
    }

    public void loadProperties() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().loadProperties();
        }
    }

    public void loadIcons() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().loadIcons();
        }
    }

    public void loadScale() {
        if (this.getFretBoard() != null) {
            this.getFretBoard().loadScale();
        }
    }

    public void showExternalBeat(TGBeat beat) {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().setExternalBeat(beat);
        }
    }

    public void hideExternalBeat() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().setExternalBeat(null);
        }
    }

    public void processRedrawEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("redrawMode");
        if (type == 1) {
            this.redraw();
        } else if (type == 3) {
            this.redrawPlayingMode();
        }
    }

    public void processExternalBeatEvent(TGEvent event) {
        if ("show".equals(event.getAttribute("action"))) {
            this.showExternalBeat((TGBeat)event.getAttribute("beat"));
        } else if ("hide".equals(event.getAttribute("action"))) {
            this.hideExternalBeat();
        }
    }

    public void processEvent(final TGEvent event) {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            public void run() {
                if ("ui-icon".equals(event.getEventType())) {
                    TGFretBoardEditor.this.loadIcons();
                } else if ("language".equals(event.getEventType())) {
                    TGFretBoardEditor.this.loadProperties();
                } else if ("ui-redraw".equals(event.getEventType())) {
                    TGFretBoardEditor.this.processRedrawEvent(event);
                } else if ("ui-external-beat-viewer".equals(event.getEventType())) {
                    TGFretBoardEditor.this.processExternalBeatEvent(event);
                } else if ("ui-scale-changed".equals(event.getEventType())) {
                    TGFretBoardEditor.this.loadScale();
                }
            }
        });
    }

    public static TGFretBoardEditor getInstance(TGContext context) {
        return (TGFretBoardEditor)TGSingletonUtil.getInstance((TGContext)context, (String)TGFretBoardEditor.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGFretBoardEditor>(){

            public TGFretBoardEditor createInstance(TGContext context) {
                return new TGFretBoardEditor(context);
            }
        });
    }
}

