/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.fretboard;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.config.TGConfigDefaults;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.util.properties.TGProperties;

public class TGFretBoardConfig {
    public static final int DISPLAY_TEXT_NOTE = 1;
    public static final int DISPLAY_TEXT_SCALE = 2;
    public static final int DIRECTION_RIGHT = 0;
    public static final int DIRECTION_LEFT = 1;
    private int style;
    private int direction;
    private Font font;
    private Color colorBackground;
    private Color colorString;
    private Color colorFretPoint;
    private Color colorNote;
    private Color colorScale;
    private static final int MINIMUM_CONTROL_WIDTH = 180;
    private static final int MINIMUM_BUTTON_WIDTH = 80;
    private static final int MINIMUM_BUTTON_HEIGHT = 25;

    public int getStyle() {
        return this.style;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getColorBackground() {
        return this.colorBackground;
    }

    public Color getColorString() {
        return this.colorString;
    }

    public Color getColorFretPoint() {
        return this.colorFretPoint;
    }

    public Color getColorNote() {
        return this.colorNote;
    }

    public Color getColorScale() {
        return this.colorScale;
    }

    public int getDirection() {
        return this.direction;
    }

    public void load() {
        Display display = TuxGuitar.getInstance().getDisplay();
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        this.style = config.getIntegerValue("fretboard.style");
        this.direction = config.getIntegerValue("fretboard.direction", 0);
        this.font = new Font((Device)display, config.getFontDataConfigValue("fretboard.font"));
        this.colorBackground = new Color((Device)display, config.getRGBConfigValue("fretboard.color.background"));
        this.colorString = new Color((Device)display, config.getRGBConfigValue("fretboard.color.string"));
        this.colorFretPoint = new Color((Device)display, config.getRGBConfigValue("fretboard.color.fret-point"));
        this.colorNote = new Color((Device)display, config.getRGBConfigValue("fretboard.color.note"));
        this.colorScale = new Color((Device)display, config.getRGBConfigValue("fretboard.color.scale"));
    }

    public void defaults() {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        TGProperties defaults = TGConfigDefaults.createDefaults();
        config.setValue("fretboard.style", defaults.getValue("fretboard.style"));
        config.setValue("fretboard.direction", defaults.getValue("fretboard.direction"));
        config.setValue("fretboard.font", defaults.getValue("fretboard.font"));
        config.setValue("fretboard.color.background", defaults.getValue("fretboard.color.background"));
        config.setValue("fretboard.color.string", defaults.getValue("fretboard.color.string"));
        config.setValue("fretboard.color.fret-point", defaults.getValue("fretboard.color.fret-point"));
        config.setValue("fretboard.color.note", defaults.getValue("fretboard.color.note"));
        config.setValue("fretboard.color.scale", defaults.getValue("fretboard.color.scale"));
    }

    public void save(int style, int direction, FontData fontData, RGB rgbBackground, RGB rgbString, RGB rgbFretPoint, RGB rgbNote, RGB rgbScale) {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        config.setValue("fretboard.style", style);
        config.setValue("fretboard.direction", direction);
        config.setValue("fretboard.font", fontData);
        config.setValue("fretboard.color.background", rgbBackground);
        config.setValue("fretboard.color.string", rgbString);
        config.setValue("fretboard.color.fret-point", rgbFretPoint);
        config.setValue("fretboard.color.note", rgbNote);
        config.setValue("fretboard.color.scale", rgbScale);
    }

    public void saveDirection(int direction) {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        config.setValue("fretboard.direction", direction);
        this.direction = direction;
    }

    public void dispose() {
        this.font.dispose();
        this.colorBackground.dispose();
        this.colorString.dispose();
        this.colorFretPoint.dispose();
        this.colorNote.dispose();
        this.colorScale.dispose();
    }

    public void configure(Shell shell) {
        final Shell dialog = DialogUtils.newDialog(shell, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("fretboard.settings"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("fretboard.settings"));
        final FontData fontData = this.getFontChooser((Composite)group, TuxGuitar.getProperty("fretboard.font"), this.font.getFontData()[0]);
        final RGB rgbBackground = this.getColorChooser((Composite)group, TuxGuitar.getProperty("fretboard.background-color"), this.colorBackground.getRGB());
        final RGB rgbString = this.getColorChooser((Composite)group, TuxGuitar.getProperty("fretboard.string-color"), this.colorString.getRGB());
        final RGB rgbFretPoint = this.getColorChooser((Composite)group, TuxGuitar.getProperty("fretboard.fretpoint-color"), this.colorFretPoint.getRGB());
        final RGB rgbNote = this.getColorChooser((Composite)group, TuxGuitar.getProperty("fretboard.note-color"), this.colorNote.getRGB());
        final RGB rgbScale = this.getColorChooser((Composite)group, TuxGuitar.getProperty("fretboard.scale-note-color"), this.colorScale.getRGB());
        Label directionLabel = new Label((Composite)group, 0);
        directionLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        directionLabel.setText(TuxGuitar.getProperty("fretboard.direction"));
        final Combo directionCombo = new Combo((Composite)group, 12);
        directionCombo.setLayoutData((Object)this.getAlignmentData(180, 4));
        directionCombo.add(TuxGuitar.getProperty("fretboard.right-mode"));
        directionCombo.add(TuxGuitar.getProperty("fretboard.left-mode"));
        directionCombo.select(this.direction);
        group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("fretboard.settings.options"));
        final Button displayTextNote = new Button((Composite)group, 32);
        displayTextNote.setLayoutData((Object)new GridData(4, 4, true, true));
        displayTextNote.setText(TuxGuitar.getProperty("fretboard.display-note-text"));
        displayTextNote.setSelection((this.style & 1) != 0);
        final Button displayTextScale = new Button((Composite)group, 32);
        displayTextScale.setLayoutData((Object)new GridData(4, 4, true, true));
        displayTextScale.setText(TuxGuitar.getProperty("fretboard.display-scale-text"));
        displayTextScale.setSelection((this.style & 2) != 0);
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonDefaults = new Button(buttons, 8);
        buttonDefaults.setText(TuxGuitar.getProperty("defaults"));
        buttonDefaults.setLayoutData((Object)this.getButtonData());
        buttonDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
                TGFretBoardConfig.this.defaults();
                TGFretBoardConfig.this.applyChanges();
            }
        });
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int style = 0;
                style |= displayTextNote.getSelection() ? 1 : 0;
                style |= displayTextScale.getSelection() ? 2 : 0;
                int direction = directionCombo.getSelectionIndex();
                if (direction != 0 && direction != 1) {
                    direction = 0;
                }
                dialog.dispose();
                TGFretBoardConfig.this.save(style, direction, fontData, rgbBackground, rgbString, rgbFretPoint, rgbNote, rgbScale);
                TGFretBoardConfig.this.applyChanges();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    protected GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    protected void applyChanges() {
        this.dispose();
        this.load();
    }

    private RGB getColorChooser(Composite parent, String title, RGB rgb) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label.setText(title);
        ButtonColor button = new ButtonColor(parent, 8, TuxGuitar.getProperty("choose"));
        button.setLayoutData(this.getAlignmentData(180, 4));
        button.loadColor(rgb);
        return button.getValue();
    }

    private FontData getFontChooser(final Composite parent, String title, FontData fontData) {
        final FontData selection = new FontData(fontData.getName(), fontData.getHeight(), fontData.getStyle());
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label.setText(title);
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)this.getAlignmentData(180, 4));
        button.setText(TuxGuitar.getProperty("choose"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Font font = new Font((Device)parent.getDisplay(), selection);
                FontDialog fontDialog = new FontDialog(parent.getShell());
                fontDialog.setFontList(font.getFontData());
                FontData fd = fontDialog.open();
                if (fd != null) {
                    selection.setName(fd.getName());
                    selection.setHeight(fd.getHeight());
                    selection.setStyle(fd.getStyle());
                }
                font.dispose();
            }
        });
        return selection;
    }

    private GridData getAlignmentData(int minimumWidth, int horizontalAlignment) {
        GridData data = new GridData();
        data.minimumWidth = minimumWidth;
        data.horizontalAlignment = horizontalAlignment;
        data.verticalAlignment = -1;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        return data;
    }

    private class ButtonColor {
        protected Button button;
        protected Color color;
        protected RGB value = new RGB(0, 0, 0);

        public ButtonColor(Composite parent, int style, String text) {
            this.button = new Button(parent, style);
            this.button.setText(text);
            this.addListeners();
        }

        protected void setLayoutData(Object layoutData) {
            this.button.setLayoutData(layoutData);
        }

        protected void loadColor(RGB rgb) {
            this.value.red = rgb.red;
            this.value.green = rgb.green;
            this.value.blue = rgb.blue;
            Color color = new Color((Device)this.button.getDisplay(), this.value);
            this.button.setForeground(color);
            this.disposeColor();
            this.color = color;
        }

        protected void disposeColor() {
            if (this.color != null && !this.color.isDisposed()) {
                this.color.dispose();
                this.color = null;
            }
        }

        private void addListeners() {
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ColorDialog dlg = new ColorDialog(ButtonColor.this.button.getShell());
                    dlg.setRGB(ButtonColor.this.value);
                    dlg.setText(TuxGuitar.getProperty("choose-color"));
                    RGB result = dlg.open();
                    if (result != null) {
                        ButtonColor.this.loadColor(result);
                    }
                }
            });
            this.button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ButtonColor.this.disposeColor();
                }
            });
        }

        protected RGB getValue() {
            return this.value;
        }
    }
}

