/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.confirm;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;

public class TGConfirmDialog {
    public static final String ATTRIBUTE_MESSAGE = "message";
    public static final String ATTRIBUTE_STYLE = "style";
    public static final String ATTRIBUTE_DEFAULT_BUTTON = "defaultButton";
    public static final String ATTRIBUTE_RUNNABLE_YES = "yesRunnable";
    public static final String ATTRIBUTE_RUNNABLE_NO = "noRunnable";
    public static final String ATTRIBUTE_RUNNABLE_CANCEL = "cancelRunnable";
    public static int BUTTON_CANCEL = 1;
    public static int BUTTON_YES = 2;
    public static int BUTTON_NO = 4;

    public void show(TGViewContext context) {
        String message = (String)context.getAttribute(ATTRIBUTE_MESSAGE);
        Integer style = (Integer)context.getAttribute(ATTRIBUTE_STYLE);
        Integer defaultButton = (Integer)context.getAttribute(ATTRIBUTE_DEFAULT_BUTTON);
        Runnable yesRunnable = (Runnable)context.getAttribute(ATTRIBUTE_RUNNABLE_YES);
        Runnable noRunnable = (Runnable)context.getAttribute(ATTRIBUTE_RUNNABLE_NO);
        Runnable cancelRunnable = (Runnable)context.getAttribute(ATTRIBUTE_RUNNABLE_CANCEL);
        Shell parent = (Shell)context.getAttribute("parent");
        Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout(1, true));
        Composite labelComposite = new Composite((Composite)dialog, 0);
        labelComposite.setLayout((Layout)new GridLayout(2, false));
        labelComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label icon = new Label(labelComposite, 0);
        icon.setImage(parent.getDisplay().getSystemImage(4));
        Label messageLabel = new Label(labelComposite, 0);
        messageLabel.setText(message);
        GridLayout buttonsLayout = new GridLayout(0, false);
        Composite buttonsComposite = new Composite((Composite)dialog, 0);
        buttonsComposite.setLayout((Layout)buttonsLayout);
        buttonsComposite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        if ((style & BUTTON_YES) != 0) {
            this.addCloseButton(dialog, buttonsComposite, TuxGuitar.getProperty("yes"), yesRunnable, defaultButton == BUTTON_YES);
            ++buttonsLayout.numColumns;
        }
        if ((style & BUTTON_NO) != 0) {
            this.addCloseButton(dialog, buttonsComposite, TuxGuitar.getProperty("no"), noRunnable, defaultButton == BUTTON_NO);
            ++buttonsLayout.numColumns;
        }
        if ((style & BUTTON_CANCEL) != 0) {
            this.addCloseButton(dialog, buttonsComposite, TuxGuitar.getProperty("cancel"), cancelRunnable, defaultButton == BUTTON_CANCEL);
            ++buttonsLayout.numColumns;
        }
        DialogUtils.openDialog(dialog, 10);
    }

    private void addCloseButton(final Shell dialog, Composite parent, String text, final Runnable runnable, boolean defaultButton) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)this.getButtonData());
        button.setText(text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        if (defaultButton) {
            dialog.setDefaultButton(button);
        }
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }
}

