/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.chord.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.herac.tuxguitar.song.models.TGChord;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGChordXMLWriter {
    public static void setChords(List<TGChord> chords, String fileName) {
        File file = new File(fileName);
        Document doc = TGChordXMLWriter.createDocument();
        TGChordXMLWriter.setChords(chords, doc);
        TGChordXMLWriter.saveDocument(doc, file);
    }

    public static Document createDocument() {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        return document;
    }

    public static void saveDocument(Document document, File file) {
        try {
            FileOutputStream fs = new FileOutputStream(file);
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            Transformer idTransform = xformFactory.newTransformer();
            DOMSource input = new DOMSource(document);
            StreamResult output = new StreamResult(fs);
            idTransform.setOutputProperty("indent", "yes");
            idTransform.transform(input, output);
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void setChords(List<TGChord> chords, Document document) {
        Element chordsNode = document.createElement("chords");
        for (TGChord chord : chords) {
            Element chordNode = document.createElement("chord");
            chordsNode.appendChild(chordNode);
            Attr nameAttr = document.createAttribute("name");
            nameAttr.setNodeValue(chord.getName());
            chordNode.getAttributes().setNamedItem(nameAttr);
            Attr stringsAttr = document.createAttribute("strings");
            stringsAttr.setNodeValue(Integer.toString(chord.getStrings().length));
            chordNode.getAttributes().setNamedItem(stringsAttr);
            Attr firstFretAttr = document.createAttribute("first-fret");
            firstFretAttr.setNodeValue(Integer.toString(chord.getFirstFret()));
            chordNode.getAttributes().setNamedItem(firstFretAttr);
            for (int i = 0; i < chord.getStrings().length; ++i) {
                Element stringNode = document.createElement("string");
                chordNode.appendChild(stringNode);
                Attr numberAttr = document.createAttribute("number");
                numberAttr.setNodeValue(Integer.toString(i));
                stringNode.getAttributes().setNamedItem(numberAttr);
                Attr fretAttr = document.createAttribute("fret");
                fretAttr.setNodeValue(Integer.toString(chord.getFretValue(i)));
                stringNode.getAttributes().setNamedItem(fretAttr);
            }
        }
        document.appendChild(chordsNode);
    }
}

