/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.chord;

import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordCustomList;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordEditor;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordList;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordRecognizer;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordSelector;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;

public class TGChordDialog {
    private static final int DEFAULT_STYLE = 2048;
    private Shell dialog;
    private TGViewContext context;
    private TGChordEditor editor;
    private TGChordSelector selector;
    private TGChordList list;
    private TGChordRecognizer recognizer;

    public TGChordDialog(TGViewContext context) {
        this.context = context;
    }

    public void show() {
        final TGTrack track = (TGTrack)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        final TGMeasure measure = (TGMeasure)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final TGBeat beat = (TGBeat)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        final TGVoice voice = (TGVoice)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE);
        Shell parent = (Shell)this.context.getAttribute("parent");
        this.dialog = DialogUtils.newDialog(parent, 67680);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("chord.editor"));
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TuxGuitar.getInstance().getCustomChordManager().write();
            }
        });
        Composite topComposite = new Composite((Composite)this.dialog, 0);
        topComposite.setLayout((Layout)new GridLayout(4, false));
        topComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite bottomComposite = new Composite((Composite)this.dialog, 0);
        bottomComposite.setLayout((Layout)new GridLayout());
        bottomComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        int[] tuning = this.findCurrentTuning(measure.getTrack());
        this.selector = new TGChordSelector(this, topComposite, 2048, tuning);
        this.selector.pack();
        this.editor = new TGChordEditor(this, topComposite, 2048, (short)tuning.length);
        this.editor.pack();
        this.editor.setCurrentTrack(measure.getTrack());
        this.recognizer = new TGChordRecognizer(this, topComposite, 2048);
        new TGChordCustomList(this, topComposite, 2048, Math.max(this.selector.getBounds().height, this.editor.getBounds().height));
        Composite listComposite = new Composite(bottomComposite, 0);
        listComposite.setLayout((Layout)this.gridLayout(1, false, 0, 0));
        listComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.list = new TGChordList(this, listComposite, beat);
        Composite buttons = new Composite((Composite)this.dialog, 0);
        buttons.setLayout((Layout)this.gridLayout(3, false, 0, 0));
        buttons.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGChordDialog.this.insertChord(track, measure, beat, voice, TGChordDialog.this.getEditor().getChord());
                TGChordDialog.this.getDialog().dispose();
            }
        });
        Button buttonClean = new Button(buttons, 8);
        buttonClean.setText(TuxGuitar.getProperty("clean"));
        buttonClean.setLayoutData((Object)this.getButtonData());
        buttonClean.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGChordDialog.this.removeChord(measure, beat);
                TGChordDialog.this.getDialog().dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGChordDialog.this.getDialog().dispose();
            }
        });
        this.editor.setChord(this.findCurrentChord(measure, beat.getStart()));
        this.dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(this.dialog, 10);
    }

    public TGChordEditor getEditor() {
        return this.editor;
    }

    public TGChordSelector getSelector() {
        return this.selector;
    }

    public TGChordList getList() {
        return this.list;
    }

    public TGChordRecognizer getRecognizer() {
        return this.recognizer;
    }

    public boolean isDisposed() {
        return this.dialog.isDisposed();
    }

    public Shell getDialog() {
        return this.dialog;
    }

    public GridLayout gridLayout(int numColumns, boolean makeColumnsEqualWidth, int marginWidth, int marginHeight) {
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.marginWidth = marginWidth >= 0 ? marginWidth : layout.marginWidth;
        layout.marginHeight = marginHeight >= 0 ? marginHeight : layout.marginHeight;
        return layout;
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private int[] findCurrentTuning(TGTrack track) {
        int[] tuning = new int[track.stringCount()];
        for (TGString string : track.getStrings()) {
            tuning[tuning.length - string.getNumber()] = string.getValue();
        }
        return tuning;
    }

    protected TGChord findCurrentChord(TGMeasure measure, long start) {
        TGSongManager manager = TuxGuitar.getInstance().getSongManager();
        TGChord chord = manager.getMeasureManager().getChord(measure, start);
        if (chord == null) {
            chord = manager.getFactory().newChord(measure.getTrack().stringCount());
            chord.setFirstFret(1);
            List notes = manager.getMeasureManager().getNotes(measure, start);
            if (!notes.isEmpty()) {
                int maxValue = -1;
                int minValue = -1;
                for (TGNote note : notes) {
                    if (maxValue < 0 || maxValue < note.getValue()) {
                        maxValue = note.getValue();
                    }
                    if (note.getValue() <= 0 || minValue >= 0 && minValue <= note.getValue()) continue;
                    minValue = note.getValue();
                }
                if (maxValue > 6 && minValue > 0) {
                    chord.setFirstFret((int)((short)minValue));
                }
                for (TGNote note : notes) {
                    chord.addFretValue(note.getString() - 1, note.getValue());
                }
            }
        }
        return chord;
    }

    public void insertChord(TGTrack track, TGMeasure measure, TGBeat beat, TGVoice voice, TGChord chord) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.beat.general.insert-chord");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE, (Object)voice);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHORD, (Object)chord);
        tgActionProcessor.processOnNewThread();
    }

    public void removeChord(TGMeasure measure, TGBeat beat) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.beat.general.remove-chord");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.processOnNewThread();
    }

    public TGViewContext getContext() {
        return this.context;
    }
}

