/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.browser.main;

import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.browser.TGBrowserCollection;
import org.herac.tuxguitar.app.tools.browser.TGBrowserManager;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserFactory;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserBar;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserCollectionCombo;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserDialog;

public class TGBrowserToolBar
extends TGBrowserBar {
    private Composite composite;
    private ToolBar toolBar;
    private ToolItem newBrowser;
    private ToolItem root;
    private ToolItem back;
    private ToolItem refresh;
    protected Menu newBrowserMenu;
    protected TGBrowserCollectionCombo collections;

    public TGBrowserToolBar(TGBrowserDialog browser) {
        super(browser);
    }

    public void init(Shell shell) {
        this.composite = new Composite((Composite)shell, 0);
        this.composite.setLayout((Layout)this.getLayout());
        this.composite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.initItems();
    }

    public void initItems() {
        this.toolBar = new ToolBar(this.composite, 0x800040);
        this.newBrowserMenu = new Menu((Control)this.composite);
        Iterator<TGBrowserFactory> bookTypes = TGBrowserManager.getInstance(this.getBrowser().getContext()).getFactories();
        while (bookTypes.hasNext()) {
            final TGBrowserFactory bookType = bookTypes.next();
            MenuItem item = new MenuItem(this.newBrowserMenu, 8);
            item.setText(bookType.getName());
            item.setData((Object)bookType);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TGBrowserToolBar.this.newCollection(bookType.getType());
                }
            });
        }
        this.newBrowser = new ToolItem(this.toolBar, 4);
        this.newBrowser.setImage(TuxGuitar.getInstance().getIconManager().getBrowserNew());
        this.newBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4) {
                    ToolItem item = (ToolItem)event.widget;
                    Rectangle rect = item.getBounds();
                    Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                    TGBrowserToolBar.this.newBrowserMenu.setLocation(pt.x, pt.y + rect.height);
                    TGBrowserToolBar.this.newBrowserMenu.setVisible(true);
                }
            }
        });
        new ToolItem(this.toolBar, 2);
        this.root = new ToolItem(this.toolBar, 8);
        this.root.setImage(TuxGuitar.getInstance().getIconManager().getBrowserRoot());
        this.root.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGBrowserToolBar.this.getBrowser().getConnection().cdRoot(3);
            }
        });
        this.back = new ToolItem(this.toolBar, 8);
        this.back.setImage(TuxGuitar.getInstance().getIconManager().getBrowserBack());
        this.back.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGBrowserToolBar.this.getBrowser().getConnection().cdUp(4);
            }
        });
        this.refresh = new ToolItem(this.toolBar, 8);
        this.refresh.setImage(TuxGuitar.getInstance().getIconManager().getBrowserRefresh());
        this.refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGBrowserToolBar.this.getBrowser().getConnection().listElements(5);
            }
        });
        new ToolItem(this.toolBar, 2);
        this.collections = new TGBrowserCollectionCombo(this.composite, 8);
        this.collections.setLayoutData(new GridData(4, 0x1000000, true, true));
        this.collections.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGBrowserToolBar.this.updateCollection();
            }
        });
    }

    public void updateItems() {
        this.newBrowser.setEnabled(!this.getBrowser().getConnection().isLocked());
        this.collections.setEnabled(!this.getBrowser().getConnection().isLocked());
        this.root.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.back.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.refresh.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
    }

    public void updateCollections(TGBrowserCollection selection) {
        int index = 0;
        this.collections.removeAll();
        Iterator<TGBrowserCollection> it = TGBrowserManager.getInstance(this.getBrowser().getContext()).getCollections();
        while (it.hasNext()) {
            TGBrowserCollection collection = it.next();
            if (collection.getData() == null) continue;
            this.collections.add(collection);
            if (selection != null && selection.equals(collection)) {
                this.collections.select(index);
            }
            ++index;
        }
    }

    public void reload() {
        this.disposeItems();
        this.initItems();
        this.loadProperties();
        this.updateItems();
        this.composite.layout(true, true);
    }

    public void loadProperties() {
        this.newBrowser.setToolTipText(TuxGuitar.getProperty("browser.collection.new"));
        this.root.setToolTipText(TuxGuitar.getProperty("browser.go-root"));
        this.back.setToolTipText(TuxGuitar.getProperty("browser.go-back"));
        this.refresh.setToolTipText(TuxGuitar.getProperty("browser.refresh"));
        this.updateCollections(this.getBrowser().getCollection());
    }

    protected void updateCollection() {
        TGBrowserCollection collection = this.collections.getSelection();
        if (collection == null) {
            this.closeCollection();
        } else {
            this.openCollection(collection);
        }
    }

    private void disposeItems() {
        Control[] controls = this.composite.getChildren();
        for (int i = 0; i < controls.length; ++i) {
            controls[i].dispose();
        }
    }

    private GridLayout getLayout() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }
}

