/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.tab;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.clipboard.ClipBoard;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.app.view.util.TGSyncProcessLocked;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TablatureEditor
implements TGEventListener {
    private TGContext context;
    private Tablature tablature;
    private ClipBoard clipBoard;
    private TGSyncProcessLocked redrawProcess;
    private TGSyncProcessLocked redrawPlayModeProcess;

    public TablatureEditor(TGContext context) {
        this.context = context;
        this.clipBoard = new ClipBoard();
    }

    public void showTablature(Composite parent) {
        this.tablature = new Tablature(this.context, parent, 0x20000B00, TuxGuitar.getInstance().getDocumentManager());
        this.tablature.initGUI();
        this.tablature.reloadViewLayout();
        this.tablature.updateTablature();
        this.tablature.resetCaret();
        this.tablature.setFocus();
        this.createSyncProcesses();
        this.initListener();
        this.initKeyActions();
        this.initMenu();
    }

    private void initListener() {
        TuxGuitar.getInstance().getEditorManager().addRedrawListener((TGEventListener)this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    private void initKeyActions() {
        TuxGuitar.getInstance().getKeyBindingManager().appendListenersTo((Control)this.tablature);
    }

    private void initMenu() {
        Menu menu = TuxGuitar.getInstance().getItemManager().getPopupMenu();
        menu.addMenuListener(this.getTablature().getEditorKit().getMenuListener());
        this.tablature.setMenu(menu);
    }

    public void reloadConfig() {
        this.getTablature().reloadStyles();
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public ClipBoard getClipBoard() {
        return this.clipBoard;
    }

    public boolean isDisposed() {
        return this.tablature == null || this.tablature.isDisposed();
    }

    public void createSyncProcesses() {
        this.redrawProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TablatureEditor.this.getTablature().redraw();
            }
        });
        this.redrawPlayModeProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TablatureEditor.this.getTablature().redrawPlayingMode();
            }
        });
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 2) {
            this.getTablature().updateMeasure((Integer)event.getAttribute("measureNumber"));
        } else if (type == 3) {
            this.getTablature().updateTablature();
        } else if (type == 4) {
            this.getTablature().updateTablature();
        }
    }

    public void processRedrawEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("redrawMode");
        if (type == 1) {
            this.redrawProcess.process();
        } else if (type == 3) {
            this.redrawPlayModeProcess.process();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-redraw".equals(event.getEventType())) {
            this.processRedrawEvent(event);
        } else if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        }
    }

    public static TablatureEditor getInstance(TGContext context) {
        return (TablatureEditor)TGSingletonUtil.getInstance((TGContext)context, (String)TablatureEditor.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TablatureEditor>(){

            public TablatureEditor createInstance(TGContext context) {
                return new TablatureEditor(context);
            }
        });
    }
}

