/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class ImageUtils {
    public static void writeImage(ImageData data, OutputStream outputStream, int format) {
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{data};
        loader.save(outputStream, format);
    }

    public static byte[] imageToByteArray(ImageData data, int format) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageUtils.writeImage(data, out, format);
        return out.toByteArray();
    }

    public static ImageData applyMask(ImageData src, RGB alpha, RGB none) {
        ImageData maskData = new ImageData(src.width, src.height, 1, new PaletteData(new RGB[]{none, alpha}));
        for (int x = 0; x < maskData.width; ++x) {
            for (int y = 0; y < maskData.height; ++y) {
                RGB rgb = src.palette.getRGB(src.getPixel(x, y));
                if (rgb.red == alpha.red && rgb.green == alpha.green && rgb.blue == alpha.blue) {
                    maskData.setPixel(x, y, maskData.palette.getPixel(none));
                    continue;
                }
                maskData.setPixel(x, y, maskData.palette.getPixel(alpha));
            }
        }
        return maskData;
    }
}

