/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.listener.gui;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.util.TGContext;

public class TGActionProcessingListener
implements TGEventListener {
    public static final String ATTRIBUTE_BY_PASS = "byPassProcessingListener";
    private TGContext context;
    private Integer level;

    public TGActionProcessingListener(TGContext context) {
        this.context = context;
        this.resetLevel();
    }

    public void resetLevel() {
        this.level = 0;
    }

    public void increaseLevel() {
        TGActionProcessingListener tGActionProcessingListener = this;
        Integer n = tGActionProcessingListener.level;
        Integer n2 = tGActionProcessingListener.level = Integer.valueOf(tGActionProcessingListener.level + 1);
    }

    public void decreaseLevel() {
        TGActionProcessingListener tGActionProcessingListener = this;
        Integer n = tGActionProcessingListener.level;
        Integer n2 = tGActionProcessingListener.level = Integer.valueOf(tGActionProcessingListener.level - 1);
    }

    public void showProcessing() {
        TGWindow.getInstance(this.context).loadBusyCursor();
    }

    public void hideProcessing() {
        TGWindow.getInstance(this.context).loadDefaultCursor();
    }

    public void updateProcessingVisibility(boolean processing) {
        if (processing) {
            this.showProcessing();
        } else {
            this.hideProcessing();
        }
    }

    public boolean isByPassProcessing(TGEvent event) {
        TGActionContext actionContext = (TGActionContext)event.getAttribute("sourceContext");
        return Boolean.TRUE.equals(actionContext.getAttribute(ATTRIBUTE_BY_PASS));
    }

    public void processEvent(boolean processing) {
        if (this.level == 0) {
            this.updateProcessingVisibility(processing);
        }
    }

    public void processEvent(TGEvent event) {
        if (!this.isByPassProcessing(event)) {
            if ("action-pre-execution".equals(event.getEventType())) {
                this.processEvent(true);
                this.increaseLevel();
            } else if ("action-post-execution".equals(event.getEventType())) {
                this.decreaseLevel();
                this.processEvent(false);
            } else if ("action-error".equals(event.getEventType())) {
                this.decreaseLevel();
                this.processEvent(false);
            }
        }
    }
}

