/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.synthesizer.settings;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelSettingsDialog;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.gm.GMChannelRoute;
import org.herac.tuxguitar.gm.GMChannelRouter;
import org.herac.tuxguitar.gm.GMChannelRouterConfigurator;
import org.herac.tuxguitar.jack.synthesizer.settings.JackMidiPlayerListener;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChannelParameter;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.error.TGErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JackChannelSettingsDialog
implements TGChannelSettingsDialog {
    public static final short MAX_CHANNELS = 16;
    public static final short DEFAULT_INSTRUMENT_CHANNEL_1 = 0;
    public static final short DEFAULT_INSTRUMENT_CHANNEL_2 = 1;
    public static final short DEFAULT_PERCUSSION_CHANNEL = 9;
    private TGContext context;
    private TGSong song;
    private TGChannel channel;
    private GMChannelRouter router;
    private Shell dialog;
    private Combo gmChannel1Combo;
    private Combo gmChannel2Combo;
    private Button exclusiveButton;
    private JackMidiPlayerListener jackMidiPlayerListener;

    public JackChannelSettingsDialog(TGContext context, TGChannel channel, TGSong song) {
        this.context = context;
        this.song = song;
        this.channel = channel;
        this.router = new GMChannelRouter();
        this.jackMidiPlayerListener = new JackMidiPlayerListener(this.context, this);
    }

    public void show(Shell parent) {
        this.configureRouter(true);
        this.dialog = DialogUtils.newDialog((Shell)parent, (int)2144);
        this.dialog.setLayout((Layout)new GridLayout(1, false));
        this.dialog.setLayoutData((Object)new GridData(4, 4, true, true));
        this.dialog.setText(TuxGuitar.getProperty((String)"jack.settings.channel.dialog"));
        Group group = new Group((Composite)this.dialog, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"jack.settings.channel.gm.tip"));
        Label gmChannel1Label = new Label((Composite)group, 0);
        gmChannel1Label.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        gmChannel1Label.setText(TuxGuitar.getProperty((String)"jack.settings.channel.gm.channel.label-1") + ":");
        this.gmChannel1Combo = new Combo((Composite)group, 12);
        this.gmChannel1Combo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.gmChannel1Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JackChannelSettingsDialog.this.updateChannel();
            }
        });
        Label gmChannel2Label = new Label((Composite)group, 0);
        gmChannel2Label.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        gmChannel2Label.setText(TuxGuitar.getProperty((String)"jack.settings.channel.gm.channel.label-2") + ":");
        this.gmChannel2Combo = new Combo((Composite)group, 12);
        this.gmChannel2Combo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.gmChannel2Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JackChannelSettingsDialog.this.updateChannel();
            }
        });
        Group optionsGroup = new Group((Composite)this.dialog, 16);
        optionsGroup.setLayout((Layout)new GridLayout());
        optionsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        optionsGroup.setText(TuxGuitar.getProperty((String)"options"));
        this.exclusiveButton = new Button((Composite)optionsGroup, 32);
        this.exclusiveButton.setText(TuxGuitar.getProperty((String)"jack.settings.channel.exclusive.port"));
        this.exclusiveButton.setSelection(this.isExclusive());
        this.exclusiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JackChannelSettingsDialog.this.updateExclusive();
            }
        });
        this.updateDefaultExclusiveChannels();
        this.updateChannelCombos();
        this.updateControls();
        this.addMidiPlayerListener();
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                JackChannelSettingsDialog.this.removeMidiPlayerListener();
            }
        });
        DialogUtils.openDialog((Shell)this.dialog, (int)10);
    }

    public void addMidiPlayerListener() {
        MidiPlayer.getInstance((TGContext)this.context).addListener((TGEventListener)this.jackMidiPlayerListener);
    }

    public void removeMidiPlayerListener() {
        MidiPlayer.getInstance((TGContext)this.context).removeListener((TGEventListener)this.jackMidiPlayerListener);
    }

    public void updateControls() {
        if (this.dialog != null && !this.dialog.isDisposed()) {
            boolean playerRunning = TuxGuitar.getInstance().getPlayer().isRunning();
            this.gmChannel1Combo.setEnabled(!playerRunning && !this.channel.isPercussionChannel() && this.gmChannel1Combo.getItemCount() > 0);
            this.gmChannel2Combo.setEnabled(!playerRunning && !this.channel.isPercussionChannel() && this.gmChannel2Combo.getItemCount() > 0);
            this.exclusiveButton.setEnabled(!playerRunning);
        }
    }

    private void configureRouter(boolean updateChannel) {
        if (!this.isExclusive()) {
            GMChannelRouterConfigurator gmChannelRouterConfigurator = new GMChannelRouterConfigurator(this.router);
            gmChannelRouterConfigurator.configureRouter(this.findGmChannels());
            if (updateChannel) {
                this.updateChannelFromRouter();
            }
        }
    }

    private void updateChannelCombos() {
        if (this.isExclusive()) {
            this.reloadExclusiveChannelCombos();
        } else {
            this.reloadGMChannelCombos();
        }
        this.updateControls();
    }

    private void reloadExclusiveChannelCombos() {
        ArrayList<Integer> channels = new ArrayList<Integer>();
        for (int i = 0; i < 16; ++i) {
            channels.add(new Integer(i));
        }
        int channel1 = this.getIntegerChannelParameter(this.channel, "gm-channel-1", -1);
        int channel2 = this.getIntegerChannelParameter(this.channel, "gm-channel-2", -1);
        this.reloadChannelCombo(this.gmChannel1Combo, channels, channel1, "jack.settings.channel.gm.channel.value-1");
        this.reloadChannelCombo(this.gmChannel2Combo, channels, channel2, "jack.settings.channel.gm.channel.value-2");
    }

    private void reloadGMChannelCombos() {
        GMChannelRoute route = this.router.getRoute(this.channel.getChannelId());
        List channels = this.router.getFreeChannels(route);
        this.reloadChannelCombo(this.gmChannel1Combo, channels, route.getChannel1(), "jack.settings.channel.gm.channel.value-1");
        this.reloadChannelCombo(this.gmChannel2Combo, channels, route.getChannel2(), "jack.settings.channel.gm.channel.value-2");
    }

    private void reloadChannelCombo(Combo combo, List<Integer> channels, int selected, String valueKey) {
        int i;
        if (!(combo.getData() instanceof List) || this.isDifferentList(channels, (List)combo.getData())) {
            combo.removeAll();
            combo.setData(channels);
            for (i = 0; i < channels.size(); ++i) {
                combo.add(TuxGuitar.getProperty((String)valueKey, (String[])new String[]{channels.get(i).toString()}));
            }
        }
        for (i = 0; i < channels.size(); ++i) {
            Integer channel = channels.get(i);
            if (channel != selected) continue;
            combo.select(i);
        }
    }

    public void updateExclusive() {
        boolean exclusive = this.exclusiveButton.getSelection();
        this.setChannelParameter(this.channel, "jack-port-exclusive", Boolean.toString(exclusive));
        this.removeChannelParameter(this.channel, "gm-channel-1");
        this.removeChannelParameter(this.channel, "gm-channel-2");
        this.configureRouter(true);
        this.updateDefaultExclusiveChannels();
        this.updateChannelCombos();
        this.updatePlayerChannels();
    }

    public void updateChannel() {
        int channel1 = -1;
        int channel2 = -1;
        int channel1Selection = this.gmChannel1Combo.getSelectionIndex();
        Object channel1Data = this.gmChannel1Combo.getData();
        if (channel1Selection >= 0 && channel1Data instanceof List && ((List)channel1Data).size() > channel1Selection) {
            channel1 = (Integer)((List)channel1Data).get(channel1Selection);
        }
        int channel2Selection = this.gmChannel2Combo.getSelectionIndex();
        Object channel2Data = this.gmChannel2Combo.getData();
        if (channel2Selection >= 0 && channel2Data instanceof List && ((List)channel2Data).size() > channel2Selection) {
            channel2 = (Integer)((List)channel2Data).get(channel2Selection);
        }
        this.setChannelParameter(this.channel, "gm-channel-1", Integer.toString(channel1));
        this.setChannelParameter(this.channel, "gm-channel-2", Integer.toString(channel2));
        this.configureRouter(false);
        this.updatePlayerChannels();
    }

    public void updateChannelFromRouter() {
        GMChannelRoute route = this.router.getRoute(this.channel.getChannelId());
        if (this.findChannelParameter(this.channel, "gm-channel-1") == null) {
            this.setChannelParameter(this.channel, "gm-channel-1", Integer.toString(route.getChannel1()));
        }
        if (this.findChannelParameter(this.channel, "gm-channel-2") == null) {
            this.setChannelParameter(this.channel, "gm-channel-2", Integer.toString(route.getChannel2()));
        }
    }

    public void updateDefaultExclusiveChannels() {
        if (this.isExclusive()) {
            int channel1 = this.channel.isPercussionChannel() ? 9 : 0;
            int channel2 = this.channel.isPercussionChannel() ? 9 : 1;
            this.setChannelParameter(this.channel, "gm-channel-1", Integer.toString(channel1));
            this.setChannelParameter(this.channel, "gm-channel-2", Integer.toString(channel2));
        }
    }

    public void updatePlayerChannels() {
        try {
            if (!MidiPlayer.getInstance((TGContext)this.context).isRunning()) {
                MidiPlayer.getInstance((TGContext)this.context).updateChannels();
            }
        }
        catch (MidiPlayerException e) {
            TGErrorManager.getInstance((TGContext)this.context).handleError((Throwable)e);
        }
    }

    private void setChannelParameter(TGChannel tgChannel, String key, String value) {
        TGChannelParameter tgChannelParameter = this.findOrCreateChannelParameter(tgChannel, key);
        tgChannelParameter.setValue(value);
    }

    private TGChannelParameter findChannelParameter(TGChannel tgChannel, String key) {
        Iterator it = tgChannel.getParameters();
        while (it.hasNext()) {
            TGChannelParameter parameter = (TGChannelParameter)it.next();
            if (!parameter.getKey().equals(key)) continue;
            return parameter;
        }
        return null;
    }

    private TGChannelParameter findOrCreateChannelParameter(TGChannel tgChannel, String key) {
        TGChannelParameter tgChannelParameter = this.findChannelParameter(tgChannel, key);
        if (tgChannelParameter == null) {
            tgChannelParameter = TuxGuitar.getInstance().getSongManager().getFactory().newChannelParameter();
            tgChannelParameter.setKey(key);
            tgChannel.addParameter(tgChannelParameter);
        }
        return tgChannelParameter;
    }

    private int getIntegerChannelParameter(TGChannel tgChannel, String key, int nullValue) {
        TGChannelParameter tgChannelParameter = this.findChannelParameter(tgChannel, key);
        if (tgChannelParameter != null && tgChannelParameter.getValue() != null) {
            return Integer.parseInt(tgChannelParameter.getValue());
        }
        return nullValue;
    }

    private void removeChannelParameter(TGChannel tgChannel, String key) {
        int index = -1;
        int count = tgChannel.countParameters();
        for (int i = 0; i < count; ++i) {
            TGChannelParameter parameter = tgChannel.getParameter(i);
            if (!parameter.getKey().equals(key)) continue;
            index = i;
        }
        if (index >= 0) {
            tgChannel.removeParameter(index);
        }
    }

    private boolean isDifferentList(List<?> list1, List<?> list2) {
        if (list1.size() != list2.size()) {
            return true;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isExclusive(TGChannel tgChannel) {
        TGChannelParameter tgChannelParameter = this.findChannelParameter(tgChannel, "jack-port-exclusive");
        if (tgChannelParameter != null) {
            return Boolean.TRUE.toString().equals(tgChannelParameter.getValue());
        }
        return false;
    }

    private boolean isExclusive() {
        return this.isExclusive(this.channel);
    }

    private Iterator<TGChannel> findGmChannels() {
        ArrayList<TGChannel> tgChannels = new ArrayList<TGChannel>();
        int count = this.song.countChannels();
        for (int i = 0; i < count; ++i) {
            TGChannel tgChannel = this.song.getChannel(i);
            if (this.isExclusive(tgChannel)) continue;
            tgChannels.add(tgChannel);
        }
        return tgChannels.iterator();
    }
}

