/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.console;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.jack.connection.JackConnectionManager;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.error.TGErrorManager;

public class JackConsoleDialog
implements TGEventListener {
    private static final int SHELL_WIDTH = 350;
    private TGContext context;
    private JackConnectionManager jackConnectionManager;
    private Shell dialog;
    private Group groupOptions;
    private Button buttonAutoConnectPorts;
    private Button buttonStoreConnections;
    private Button buttonRestoreConnections;

    public JackConsoleDialog(TGContext context, JackConnectionManager jackConnectionManager) {
        this.context = context;
        this.jackConnectionManager = jackConnectionManager;
    }

    public void show() {
        this.dialog = DialogUtils.newDialog((Shell)TuxGuitar.getInstance().getShell(), (int)2144);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setMinimumSize(350, -1);
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TuxGuitar.getInstance().getIconManager().removeLoader((TGEventListener)JackConsoleDialog.this);
                TuxGuitar.getInstance().getLanguageManager().removeLoader((TGEventListener)JackConsoleDialog.this);
            }
        });
        this.groupOptions = new Group((Composite)this.dialog, 16);
        this.groupOptions.setLayout((Layout)new GridLayout());
        this.groupOptions.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite((Composite)this.groupOptions, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.buttonAutoConnectPorts = new Button(composite, 32);
        this.buttonAutoConnectPorts.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.buttonAutoConnectPorts.setSelection(this.jackConnectionManager.isAutoConnectPorts());
        this.buttonAutoConnectPorts.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final boolean selection = ((Button)e.widget).getSelection();
                new Thread(new Runnable(){

                    public void run() {
                        JackConsoleDialog.this.updateAutoConnectPorts(selection);
                    }
                }).start();
            }
        });
        Composite buttons = new Composite((Composite)this.dialog, 0);
        buttons.setLayout((Layout)new GridLayout(1, false));
        buttons.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.buttonStoreConnections = new Button(buttons, 8);
        this.buttonStoreConnections.setLayoutData((Object)new GridData(4, 4, true, true));
        this.buttonStoreConnections.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                new Thread(new Runnable(){

                    public void run() {
                        JackConsoleDialog.this.storeConnections();
                    }
                }).start();
            }
        });
        this.buttonRestoreConnections = new Button(buttons, 8);
        this.buttonRestoreConnections.setLayoutData((Object)new GridData(4, 4, true, true));
        this.buttonRestoreConnections.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                new Thread(new Runnable(){

                    public void run() {
                        JackConsoleDialog.this.restoreConnections();
                    }
                }).start();
            }
        });
        this.loadIcons(false);
        this.loadProperties(false);
        TuxGuitar.getInstance().getIconManager().addLoader((TGEventListener)this);
        TuxGuitar.getInstance().getLanguageManager().addLoader((TGEventListener)this);
        DialogUtils.openDialog((Shell)this.dialog, (int)10);
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void loadProperties() {
        this.loadProperties(true);
    }

    public void loadProperties(boolean layout) {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty((String)"jack.console.title"));
            this.groupOptions.setText(TuxGuitar.getProperty((String)"jack.console.options"));
            this.buttonAutoConnectPorts.setText(TuxGuitar.getProperty((String)"jack.console.autoconnect.ports"));
            this.buttonStoreConnections.setText(TuxGuitar.getProperty((String)"jack.console.store.connections"));
            this.buttonRestoreConnections.setText(TuxGuitar.getProperty((String)"jack.console.restore.connections"));
            if (layout) {
                this.dialog.layout(true, true);
            }
        }
    }

    public void loadIcons() {
        this.loadIcons(true);
    }

    public void loadIcons(boolean layout) {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
            if (layout) {
                this.dialog.layout(true, true);
            }
        }
    }

    public void updateAutoConnectPorts(boolean autoConnectPorts) {
        try {
            this.jackConnectionManager.setAutoConnectPorts(autoConnectPorts);
            this.jackConnectionManager.saveConfig();
        }
        catch (Throwable throwable) {
            TGErrorManager.getInstance((TGContext)this.context).handleError(throwable);
        }
    }

    public void storeConnections() {
        try {
            this.jackConnectionManager.loadExistingConnections();
            this.jackConnectionManager.saveConfig();
            this.showInfoMessage("jack.console.info.message.title", "jack.console.store.connections.success");
        }
        catch (Throwable throwable) {
            TGErrorManager.getInstance((TGContext)this.context).handleError(throwable);
        }
    }

    public void restoreConnections() {
        try {
            this.jackConnectionManager.connectAllPorts();
            this.showInfoMessage("jack.console.info.message.title", "jack.console.restore.connections.success");
        }
        catch (Throwable throwable) {
            TGErrorManager.getInstance((TGContext)this.context).handleError(throwable);
        }
    }

    public void showInfoMessage(String title, String message) {
        TGMessageDialogUtil.infoMessage((TGContext)this.context, (Shell)this.dialog, (String)TuxGuitar.getProperty((String)title), (String)TuxGuitar.getProperty((String)message));
    }

    public void processEvent(TGEvent event) {
        if ("ui-icon".equals(event.getEventType())) {
            this.loadIcons();
        } else if ("language".equals(event.getEventType())) {
            this.loadProperties();
        }
    }
}

