/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.auth;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.community.TGCommunitySingleton;
import org.herac.tuxguitar.community.auth.TGCommunityAuth;
import org.herac.tuxguitar.community.utils.TGCommunityWeb;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;

public class TGCommunityAuthDialog {
    private TGContext context;
    private TGCommunityAuth auth;
    private boolean accepted;

    public TGCommunityAuthDialog(TGContext context) {
        this.context = context;
        this.auth = TGCommunitySingleton.getInstance(this.context).getAuth();
        this.accepted = false;
    }

    public void open() {
        this.open(TuxGuitar.getInstance().getShell());
    }

    public void open(Shell shell) {
        this.accepted = false;
        final Shell dialog = DialogUtils.newDialog((Shell)shell, (int)67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setLayoutData((Object)new GridData(4, 4, true, true));
        dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        dialog.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.title"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)this.makeGroupLayout(2, 5));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.signin"));
        Label usernameLabel = new Label((Composite)group, 0);
        usernameLabel.setLayoutData((Object)this.makeLabelData());
        usernameLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.signin.username") + ":");
        final Text usernameText = new Text((Composite)group, 2048);
        usernameText.setLayoutData((Object)this.makeTextData());
        usernameText.setText(this.auth.getUsername());
        Label passwordLabel = new Label((Composite)group, 0);
        passwordLabel.setLayoutData((Object)this.makeLabelData());
        passwordLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.signin.password") + ":");
        final Text passwordText = new Text((Composite)group, 0x400800);
        passwordText.setLayoutData((Object)this.makeTextData());
        passwordText.setText(this.auth.getPassword());
        Group join = new Group((Composite)dialog, 16);
        join.setLayout((Layout)this.makeGroupLayout(1, 5));
        join.setLayoutData((Object)new GridData(group.computeSize((int)-1, (int)-1).x, -1));
        join.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.signup"));
        Link joinLink = new Link((Composite)join, 16384);
        joinLink.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        joinLink.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.signup.tip"));
        joinLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                final String href = event.text;
                if (href != null) {
                    new Thread(new Runnable(){

                        public void run() throws TGException {
                            TGCommunityWeb.open(TGCommunityAuthDialog.this.getContext(), href);
                        }
                    }).start();
                }
            }
        });
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGCommunityAuthDialog.this.update(usernameText.getText(), passwordText.getText());
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog((Shell)dialog, (int)11);
    }

    private GridLayout makeGroupLayout(int columns, int spacing) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginTop = spacing;
        layout.marginBottom = spacing;
        layout.marginLeft = spacing;
        layout.marginRight = spacing;
        layout.verticalSpacing = spacing;
        layout.horizontalSpacing = spacing;
        return layout;
    }

    private GridData makeLabelData() {
        return new GridData(131072, 0x1000000, false, true);
    }

    private GridData makeTextData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 250;
        return data;
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    protected void update(String username, String password) {
        this.auth.setUsername(username);
        this.auth.setPassword(password);
        this.accepted = true;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public TGContext getContext() {
        return this.context;
    }
}

