/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models.effects;

public class HarmonicEffect {
    public static final String KEY_NATURAL = "N.H";
    public static final String KEY_ARTIFICIAL = "A.H";
    public static final String KEY_TAPPED = "T.H";
    public static final String KEY_PINCH = "P.H";
    public static final String KEY_SEMI = "S.H";
    public static final int TYPE_NATURAL = 1;
    public static final int TYPE_ARTIFICIAL = 2;
    public static final int TYPE_TAPPED = 3;
    public static final int TYPE_PINCH = 4;
    public static final int TYPE_SEMI = 5;
    public static final int MIN_ARTIFICIAL_OFFSET = -24;
    public static final int MAX_ARTIFICIAL_OFFSET = 24;
    public static final int MAX_TAPPED_OFFSET = 24;
    private int type;
    private int data;

    public HarmonicEffect(int n) {
        this(n, 0);
    }

    public HarmonicEffect(int n, int n2) {
        this.type = n;
        this.data = n2;
    }

    public int getData() {
        return this.data;
    }

    public void setData(int n) {
        this.data = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean isNatural() {
        return this.type == 1;
    }

    public boolean isArtificial() {
        return this.type == 2;
    }

    public boolean isTapped() {
        return this.type == 3;
    }

    public boolean isPinch() {
        return this.type == 4;
    }

    public boolean isSemi() {
        return this.type == 5;
    }

    public Object clone() {
        HarmonicEffect harmonicEffect = new HarmonicEffect(this.type, this.data);
        return harmonicEffect;
    }
}

