/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Lyric;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class SongTrack
implements Serializable {
    public static final int MAX_OFFSET = 24;
    public static final int MIN_OFFSET = -24;
    private int number;
    private SongChannel channel;
    private String name;
    private List measures;
    private List strings;
    private RGBColor color;
    private int offset;
    private Lyric lyrics;

    public SongTrack(int n, String string, SongChannel songChannel, List list, List list2, int n2, RGBColor rGBColor, Lyric lyric) {
        this.number = n;
        this.name = string;
        this.channel = songChannel;
        this.measures = list;
        this.strings = list2;
        this.color = rGBColor;
        this.offset = n2;
        this.lyrics = lyric;
    }

    public SongTrack(int n, String string, SongChannel songChannel, List list, List list2, int n2, RGBColor rGBColor) {
        this(n, string, songChannel, list, list2, n2, rGBColor, new Lyric());
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public List getMeasures() {
        return this.measures;
    }

    public void setMeasures(List list) {
        this.measures = list;
    }

    public SongChannel getChannel() {
        return this.channel;
    }

    public void setChannel(SongChannel songChannel) {
        this.channel = songChannel;
    }

    public List getStrings() {
        return this.strings;
    }

    public void setStrings(List list) {
        this.strings = list;
    }

    public RGBColor getColor() {
        return this.color;
    }

    public void setColor(RGBColor rGBColor) {
        this.color = rGBColor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public Lyric getLyrics() {
        return this.lyrics;
    }

    public void setLyrics(Lyric lyric) {
        this.lyrics = lyric;
    }

    public InstrumentString getString(int n) {
        return (InstrumentString)this.strings.get(n - 1);
    }

    public int stringCount() {
        return this.strings.size();
    }

    public boolean isPercussionTrack() {
        return this.getChannel().isPercusionChannel();
    }

    public void makeEqual(SongTrack songTrack, List list) {
        songTrack = (SongTrack)songTrack.clone(list);
        this.number = songTrack.getNumber();
        this.name = songTrack.getName();
        this.channel = songTrack.getChannel();
        this.measures = songTrack.getMeasures();
        this.strings = songTrack.getStrings();
        this.color = songTrack.getColor();
    }

    public Object clone(List list) {
        int n;
        Object object;
        Object object2;
        Object object3;
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        for (int i = 0; i < this.getMeasures().size(); ++i) {
            Measure measure = (Measure)this.getMeasures().get(i);
            object3 = (TimeSignature)measure.getTimeSignature().clone();
            object2 = (Tempo)measure.getTempo().clone();
            object = new ArrayList();
            for (int j = 0; j < measure.getNotes().size(); ++j) {
                Note note = (Note)measure.getNotes().get(j);
                object.add((Note)note.clone());
            }
            ArrayList<Silence> arrayList2 = new ArrayList<Silence>();
            for (int j = 0; j < measure.getSilences().size(); ++j) {
                Silence silence = (Silence)measure.getSilences().get(j);
                arrayList2.add((Silence)silence.clone());
            }
            arrayList.add(new Measure((MeasureHeader)list.get(i), (List)object, arrayList2, measure.getClef(), measure.getKeySignature()));
        }
        ArrayList<InstrumentString> arrayList3 = new ArrayList<InstrumentString>();
        for (n = 0; n < this.getStrings().size(); ++n) {
            object3 = (InstrumentString)this.getStrings().get(n);
            arrayList3.add((InstrumentString)((InstrumentString)object3).clone());
        }
        n = this.getNumber();
        object3 = this.getName();
        object2 = (SongChannel)this.getChannel().clone();
        object = (RGBColor)this.getColor().clone();
        int n2 = this.getOffset();
        return new SongTrack(n, (String)object3, (SongChannel)object2, arrayList, arrayList3, n2, (RGBColor)object);
    }
}

