/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.models.effects.BendEffect;
import org.herac.tuxguitar.song.models.effects.GraceEffect;
import org.herac.tuxguitar.song.models.effects.HarmonicEffect;
import org.herac.tuxguitar.song.models.effects.TremoloBarEffect;
import org.herac.tuxguitar.song.models.effects.TremoloPickingEffect;
import org.herac.tuxguitar.song.models.effects.TrillEffect;

public class NoteEffect {
    private BendEffect bend;
    private TremoloBarEffect tremoloBar;
    private HarmonicEffect harmonic;
    private GraceEffect grace;
    private TrillEffect trill;
    private TremoloPickingEffect tremoloPicking;
    private boolean vibrato;
    private boolean deadNote;
    private boolean slide;
    private boolean hammer;
    private boolean ghostNote;
    private boolean accentuatedNote;
    private boolean heavyAccentuatedNote;
    private boolean palmMute;
    private boolean staccato;
    private boolean tapping;
    private boolean slapping;
    private boolean popping;
    private boolean fadeIn;

    private NoteEffect(BendEffect bendEffect, TremoloBarEffect tremoloBarEffect, HarmonicEffect harmonicEffect, GraceEffect graceEffect, TrillEffect trillEffect, TremoloPickingEffect tremoloPickingEffect, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13) {
        this.bend = bendEffect;
        this.tremoloBar = tremoloBarEffect;
        this.harmonic = harmonicEffect;
        this.grace = graceEffect;
        this.trill = trillEffect;
        this.tremoloPicking = tremoloPickingEffect;
        this.vibrato = bl;
        this.deadNote = bl2;
        this.slide = bl3;
        this.hammer = bl4;
        this.ghostNote = bl5;
        this.accentuatedNote = bl6;
        this.heavyAccentuatedNote = bl7;
        this.palmMute = bl8;
        this.staccato = bl9;
        this.tapping = bl10;
        this.slapping = bl11;
        this.popping = bl12;
        this.fadeIn = bl13;
    }

    public NoteEffect() {
        this(null, null, null, null, null, null, false, false, false, false, false, false, false, false, false, false, false, false, false);
    }

    public boolean isDeadNote() {
        return this.deadNote;
    }

    public void setDeadNote(boolean bl) {
        this.deadNote = bl;
        if (this.isDeadNote()) {
            this.tremoloBar = null;
            this.bend = null;
            this.trill = null;
            this.slide = false;
            this.hammer = false;
        }
    }

    public boolean isVibrato() {
        return this.vibrato;
    }

    public void setVibrato(boolean bl) {
        this.vibrato = bl;
        if (this.isVibrato()) {
            this.trill = null;
        }
    }

    public BendEffect getBend() {
        return this.bend;
    }

    public void setBend(BendEffect bendEffect) {
        this.bend = bendEffect;
        if (this.isBend()) {
            this.tremoloBar = null;
            this.trill = null;
            this.deadNote = false;
            this.slide = false;
            this.hammer = false;
        }
    }

    public boolean isBend() {
        return this.bend != null && !this.bend.getPoints().isEmpty();
    }

    public TremoloBarEffect getTremoloBar() {
        return this.tremoloBar;
    }

    public void setTremoloBar(TremoloBarEffect tremoloBarEffect) {
        this.tremoloBar = tremoloBarEffect;
        if (this.isTremoloBar()) {
            this.bend = null;
            this.trill = null;
            this.deadNote = false;
            this.slide = false;
            this.hammer = false;
        }
    }

    public boolean isTremoloBar() {
        return this.tremoloBar != null;
    }

    public TrillEffect getTrill() {
        return this.trill;
    }

    public void setTrill(TrillEffect trillEffect) {
        this.trill = trillEffect;
        if (this.isTrill()) {
            this.bend = null;
            this.tremoloBar = null;
            this.tremoloPicking = null;
            this.slide = false;
            this.hammer = false;
            this.deadNote = false;
            this.vibrato = false;
        }
    }

    public boolean isTrill() {
        return this.trill != null;
    }

    public TremoloPickingEffect getTremoloPicking() {
        return this.tremoloPicking;
    }

    public void setTremoloPicking(TremoloPickingEffect tremoloPickingEffect) {
        this.tremoloPicking = tremoloPickingEffect;
        if (this.isTremoloPicking()) {
            this.trill = null;
            this.bend = null;
            this.tremoloBar = null;
            this.slide = false;
            this.hammer = false;
            this.deadNote = false;
            this.vibrato = false;
        }
    }

    public boolean isTremoloPicking() {
        return this.tremoloPicking != null;
    }

    public boolean isHammer() {
        return this.hammer;
    }

    public void setHammer(boolean bl) {
        this.hammer = bl;
        if (this.isHammer()) {
            this.trill = null;
            this.tremoloBar = null;
            this.bend = null;
            this.deadNote = false;
            this.slide = false;
        }
    }

    public boolean isSlide() {
        return this.slide;
    }

    public void setSlide(boolean bl) {
        this.slide = bl;
        if (this.isSlide()) {
            this.trill = null;
            this.tremoloBar = null;
            this.bend = null;
            this.deadNote = false;
            this.hammer = false;
        }
    }

    public boolean isGhostNote() {
        return this.ghostNote;
    }

    public void setGhostNote(boolean bl) {
        this.ghostNote = bl;
        if (this.isGhostNote()) {
            this.accentuatedNote = false;
            this.heavyAccentuatedNote = false;
        }
    }

    public boolean isAccentuatedNote() {
        return this.accentuatedNote;
    }

    public void setAccentuatedNote(boolean bl) {
        this.accentuatedNote = bl;
        if (this.isAccentuatedNote()) {
            this.ghostNote = false;
            this.heavyAccentuatedNote = false;
        }
    }

    public boolean isHeavyAccentuatedNote() {
        return this.heavyAccentuatedNote;
    }

    public void setHeavyAccentuatedNote(boolean bl) {
        this.heavyAccentuatedNote = bl;
        if (this.isHeavyAccentuatedNote()) {
            this.ghostNote = false;
            this.accentuatedNote = false;
        }
    }

    public void setHarmonic(HarmonicEffect harmonicEffect) {
        this.harmonic = harmonicEffect;
    }

    public HarmonicEffect getHarmonic() {
        return this.harmonic;
    }

    public boolean isHarmonic() {
        return this.harmonic != null;
    }

    public GraceEffect getGrace() {
        return this.grace;
    }

    public void setGrace(GraceEffect graceEffect) {
        this.grace = graceEffect;
    }

    public boolean isGrace() {
        return this.grace != null;
    }

    public boolean isPalmMute() {
        return this.palmMute;
    }

    public void setPalmMute(boolean bl) {
        this.palmMute = bl;
        if (this.isPalmMute()) {
            this.staccato = false;
        }
    }

    public boolean isStaccato() {
        return this.staccato;
    }

    public void setStaccato(boolean bl) {
        this.staccato = bl;
        if (this.isStaccato()) {
            this.palmMute = false;
        }
    }

    public boolean isPopping() {
        return this.popping;
    }

    public void setPopping(boolean bl) {
        this.popping = bl;
        if (this.isPopping()) {
            this.tapping = false;
            this.slapping = false;
        }
    }

    public boolean isSlapping() {
        return this.slapping;
    }

    public void setSlapping(boolean bl) {
        this.slapping = bl;
        if (this.isSlapping()) {
            this.tapping = false;
            this.popping = false;
        }
    }

    public boolean isTapping() {
        return this.tapping;
    }

    public void setTapping(boolean bl) {
        this.tapping = bl;
        if (this.isTapping()) {
            this.slapping = false;
            this.popping = false;
        }
    }

    public boolean isFadeIn() {
        return this.fadeIn;
    }

    public void setFadeIn(boolean bl) {
        this.fadeIn = bl;
    }

    public boolean hasAnyEffect() {
        return this.isBend() || this.isTremoloBar() || this.isHarmonic() || this.isGrace() || this.isTrill() || this.isTremoloPicking() || this.isVibrato() || this.isDeadNote() || this.isSlide() || this.isHammer() || this.isGhostNote() || this.isAccentuatedNote() || this.isHeavyAccentuatedNote() || this.isPalmMute() || this.isStaccato() || this.isTapping() || this.isSlapping() || this.isPopping() || this.isFadeIn();
    }

    public Object clone() {
        BendEffect bendEffect = null;
        if (this.isBend()) {
            bendEffect = (BendEffect)this.bend.clone();
        }
        TremoloBarEffect tremoloBarEffect = null;
        if (this.isTremoloBar()) {
            tremoloBarEffect = (TremoloBarEffect)this.tremoloBar.clone();
        }
        HarmonicEffect harmonicEffect = null;
        if (this.isHarmonic()) {
            harmonicEffect = (HarmonicEffect)this.harmonic.clone();
        }
        GraceEffect graceEffect = null;
        if (this.isGrace()) {
            graceEffect = (GraceEffect)this.grace.clone();
        }
        TrillEffect trillEffect = null;
        if (this.isTrill()) {
            trillEffect = (TrillEffect)this.trill.clone();
        }
        TremoloPickingEffect tremoloPickingEffect = null;
        if (this.isTremoloPicking()) {
            tremoloPickingEffect = (TremoloPickingEffect)this.tremoloPicking.clone();
        }
        return new NoteEffect(bendEffect, tremoloBarEffect, harmonicEffect, graceEffect, trillEffect, tremoloPickingEffect, this.isVibrato(), this.isDeadNote(), this.isSlide(), this.isHammer(), this.isGhostNote(), this.isAccentuatedNote(), this.isHeavyAccentuatedNote(), this.isPalmMute(), this.isStaccato(), this.isTapping(), this.isSlapping(), this.isPopping(), this.isFadeIn());
    }
}

