/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import java.io.Serializable;
import org.herac.tuxguitar.song.models.Marker;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class MeasureHeader
implements Serializable {
    public static final int TRIPLET_FEEL_NONE = 1;
    public static final int TRIPLET_FEEL_EIGHTH = 2;
    public static final int TRIPLET_FEEL_SIXTEENTH = 3;
    private int number;
    private long start;
    private TimeSignature timeSignature;
    private Tempo tempo;
    private Marker marker;
    private boolean repeatStart;
    private int numberOfRepetitions;
    private int tripletFeel;
    private long startWidthRepetitions;

    public MeasureHeader(int n, long l, TimeSignature timeSignature, Tempo tempo, Marker marker, int n2, boolean bl, int n3) {
        this.number = n;
        this.start = l;
        this.timeSignature = timeSignature;
        this.tempo = tempo;
        this.marker = marker;
        this.tripletFeel = n2;
        this.repeatStart = bl;
        this.numberOfRepetitions = n3;
        this.startWidthRepetitions = this.start;
        this.checkMarker();
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int n) {
        this.number = n;
        this.checkMarker();
    }

    public int getNumberOfRepetitions() {
        return this.numberOfRepetitions;
    }

    public void setNumberOfRepetitions(int n) {
        this.numberOfRepetitions = n;
    }

    public boolean isRepeatStart() {
        return this.repeatStart;
    }

    public void setRepeatStart(boolean bl) {
        this.repeatStart = bl;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long l) {
        this.start = l;
    }

    public int getTripletFeel() {
        return this.tripletFeel;
    }

    public void setTripletFeel(int n) {
        this.tripletFeel = n;
    }

    public long getStartWidthRepetitions() {
        return this.startWidthRepetitions;
    }

    public void setStartWidthRepetitions(long l) {
        this.startWidthRepetitions = l;
    }

    public Tempo getTempo() {
        return this.tempo;
    }

    public void setTempo(Tempo tempo) {
        this.tempo = tempo;
    }

    public TimeSignature getTimeSignature() {
        return this.timeSignature;
    }

    public void setTimeSignature(TimeSignature timeSignature) {
        this.timeSignature = timeSignature;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    public boolean hasMarker() {
        return this.getMarker() != null;
    }

    private void checkMarker() {
        if (this.hasMarker()) {
            this.marker.setMeasure(this.getNumber());
        }
    }

    public long getLength() {
        return (long)this.getTimeSignature().getNumerator() * this.getTimeSignature().getDenominator().getTime();
    }

    public void makeEqual(MeasureHeader measureHeader) {
        this.start = measureHeader.getStart();
        this.timeSignature = measureHeader.getTimeSignature();
        this.tempo = measureHeader.getTempo();
        this.marker = measureHeader.getMarker();
        this.repeatStart = measureHeader.isRepeatStart();
        this.numberOfRepetitions = measureHeader.getNumberOfRepetitions();
        this.startWidthRepetitions = measureHeader.getStartWidthRepetitions();
        this.checkMarker();
    }

    public Object clone() {
        int n = this.number;
        long l = this.start;
        boolean bl = this.repeatStart;
        int n2 = this.numberOfRepetitions;
        int n3 = this.tripletFeel;
        TimeSignature timeSignature = (TimeSignature)this.timeSignature.clone();
        Tempo tempo = (Tempo)this.tempo.clone();
        Marker marker = null;
        if (this.getMarker() != null) {
            marker = (Marker)this.getMarker().clone();
            marker.setMeasure(n);
        }
        return new MeasureHeader(n, l, timeSignature, tempo, marker, n3, bl, n2);
    }
}

