/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Marker;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class Measure
implements Serializable {
    public static final int CLEF_TREBLE = 1;
    public static final int CLEF_BASS = 2;
    public static final int CLEF_TENOR = 3;
    public static final int CLEF_ALTO = 4;
    private MeasureHeader header;
    private int clef;
    private int keySignature;
    private List notes;
    private List silences;

    public Measure(MeasureHeader measureHeader, List list, List list2, int n, int n2) {
        this.header = measureHeader;
        this.notes = list;
        this.silences = list2;
        this.clef = n;
        this.keySignature = n2;
    }

    public int getClef() {
        return this.clef;
    }

    public void setClef(int n) {
        this.clef = n;
    }

    public int getKeySignature() {
        return this.keySignature;
    }

    public void setKeySignature(int n) {
        this.keySignature = n;
    }

    public List getNotes() {
        return this.notes;
    }

    public void setNotes(List list) {
        this.notes = list;
    }

    public void removeNote(Note note) {
        this.notes.remove(note);
    }

    public void addNote(Note note) {
        this.notes.add(note);
    }

    public List getSilences() {
        return this.silences;
    }

    public void setSilences(List list) {
        this.silences = list;
    }

    public void removeSilence(Silence silence) {
        this.silences.remove(silence);
    }

    public void addSilence(Silence silence) {
        this.silences.add(silence);
    }

    public MeasureHeader getHeader() {
        return this.header;
    }

    public void setHeader(MeasureHeader measureHeader) {
        this.header = measureHeader;
    }

    public int getNumber() {
        return this.header.getNumber();
    }

    public int getNumberOfRepetitions() {
        return this.header.getNumberOfRepetitions();
    }

    public long getStart() {
        return this.header.getStart();
    }

    public long getStartWidthRepetitions() {
        return this.header.getStartWidthRepetitions();
    }

    public Tempo getTempo() {
        return this.header.getTempo();
    }

    public TimeSignature getTimeSignature() {
        return this.header.getTimeSignature();
    }

    public boolean isRepeatStart() {
        return this.header.isRepeatStart();
    }

    public int getTripletFeel() {
        return this.header.getTripletFeel();
    }

    public long getLength() {
        return this.header.getLength();
    }

    public boolean hasMarker() {
        return this.header.hasMarker();
    }

    public Marker getMarker() {
        return this.header.getMarker();
    }

    public void makeEqual(Measure measure) {
        this.clef = measure.getClef();
        this.keySignature = measure.getKeySignature();
        this.notes = measure.getNotes();
        this.silences = measure.getSilences();
    }

    public Object clone(MeasureHeader measureHeader) {
        Component component;
        int n;
        int n2 = this.clef;
        int n3 = this.keySignature;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (n = 0; n < this.notes.size(); ++n) {
            component = (Note)this.notes.get(n);
            arrayList.add(((Note)component).clone());
        }
        for (n = 0; n < this.silences.size(); ++n) {
            component = (Silence)this.silences.get(n);
            arrayList2.add(((Silence)component).clone());
        }
        return new Measure(measureHeader, arrayList, arrayList2, n2, n3);
    }
}

