/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.base;

import java.util.List;
import org.herac.tuxguitar.player.base.MidiSequence;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tupleto;
import org.herac.tuxguitar.song.models.effects.BendEffect;
import org.herac.tuxguitar.song.models.effects.TremoloBarEffect;

public class MidiSequenceParser {
    private static final int DEFAULT_METRONOME_KEY = 37;
    private static final int DEFAULT_DEAD_NOTE_DURATION = 50;
    private static final int DEFAULT_BEND = 64;
    private static final float DEFAULT_BEND_SEMI_TONE = 5.5f;
    public static final int ADD_DEFAULT_CONTROLS = 1;
    public static final int ADD_MIXER_MESSAGES = 2;
    public static final int ADD_METRONOME = 4;
    public static final int ADD_TICK_MOVE_MESSAGES = 8;
    public static final int ADD_FIRST_TICK_MOVE = 16;
    public static final int DEFAULT_PLAY_FLAGS = 12;
    public static final int DEFAULT_EXPORT_FLAGS = 19;
    private SongManager manager;
    private int flags;
    private int infoTrack;
    private int metronomeTrack;
    private int fisrtTickMove;

    public MidiSequenceParser(SongManager songManager, int n) {
        this.manager = songManager;
        this.flags = n;
        this.fisrtTickMove = (int)((n & 0x10) != 0 ? -1000L : 0L);
    }

    public void parse(MidiSequence midiSequence) {
        this.infoTrack = midiSequence.getInfoTrack();
        this.metronomeTrack = midiSequence.getMetronomeTrack();
        this.addDefaultMessages(midiSequence);
        for (int i = 0; i < this.manager.getSong().getTracks().size(); ++i) {
            SongTrack songTrack = (SongTrack)this.manager.getSong().getTracks().get(i);
            this.createTrack(midiSequence, songTrack);
        }
    }

    private int infoIndex() {
        return this.infoTrack;
    }

    private int metronomeIndex() {
        return this.metronomeTrack;
    }

    private long getTick(long l) {
        return l + (long)this.fisrtTickMove;
    }

    private void createTrack(MidiSequence midiSequence, SongTrack songTrack) {
        this.addBend(midiSequence, songTrack.getNumber(), 1000L, 64, songTrack.getChannel().getChannel());
        this.addMixerValues(midiSequence, songTrack.getNumber(), songTrack.getChannel());
        boolean bl = true;
        long l = 1000L;
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        int n2 = 0;
        Measure measure = null;
        for (int i = 0; i < songTrack.getMeasures().size(); ++i) {
            Measure measure2 = (Measure)songTrack.getMeasures().get(i);
            if (songTrack.getNumber() == 1) {
                this.addTimeSignature(midiSequence, measure2, measure, l3);
                this.addTempo(midiSequence, measure2, measure, l3);
                this.addStartMoveMetaMessage(midiSequence, measure2.getStart(), l3);
                this.addMetronome(midiSequence, measure2.getHeader(), l3);
            }
            this.makeNotes(midiSequence, songTrack.getNumber(), songTrack, measure2, i, l3);
            if (measure2.isRepeatStart()) {
                n = i;
                l = measure2.getStart();
                bl = true;
            }
            if (bl && measure2.getNumberOfRepetitions() > 0) {
                if (n2 < measure2.getNumberOfRepetitions()) {
                    l2 = measure2.getStart() + measure2.getLength();
                    l3 += l2 - l;
                    i = n - 1;
                    ++n2;
                } else {
                    l = 0L;
                    n2 = 0;
                    l2 = 0L;
                    bl = false;
                }
            }
            measure = measure2;
        }
    }

    private void makeNotes(MidiSequence midiSequence, int n, SongTrack songTrack, Measure measure, int n2, long l) {
        for (int i = 0; i < measure.getNotes().size(); ++i) {
            int n3;
            int n4;
            Note note = (Note)measure.getNotes().get(i);
            if (note.isTiedNote()) continue;
            int n5 = songTrack.getOffset() + note.getValue() + ((InstrumentString)songTrack.getStrings().get(note.getString() - 1)).getValue();
            NoteData noteData = this.checkTripletFeel(measure, note, i);
            long l2 = noteData.start + l;
            long l3 = this.getRealNoteDuration(note, noteData.duration, songTrack.getMeasures(), n2, i);
            int n6 = this.getRealVelocity(note, songTrack, n2, i);
            short s = songTrack.getChannel().getChannel();
            short s2 = songTrack.getChannel().getEffectChannel();
            boolean bl = songTrack.isPercussionTrack();
            if (note.getEffect().isFadeIn()) {
                s = s2;
                this.makeFadeIn(midiSequence, n, l2, l3, songTrack.getChannel().getVolume(), s);
            }
            if (note.getEffect().isGrace() && s2 >= 0 && !bl) {
                s = s2;
                n4 = songTrack.getOffset() + note.getEffect().getGrace().getFret() + ((InstrumentString)songTrack.getStrings().get(note.getString() - 1)).getValue();
                int n7 = note.getEffect().getGrace().getDurationTime();
                int n8 = note.getEffect().getGrace().isDead() ? 50 : n7;
                n3 = note.getEffect().getGrace().getDynamic();
                if (note.getEffect().getGrace().isOnBeat() || l2 - (long)n7 < 1000L) {
                    l2 += (long)n7;
                    l3 -= (long)n7;
                }
                this.makeNote(midiSequence, n, n4, l2 - (long)n7, n8, n3, s);
            }
            if (note.getEffect().isTrill() && s2 >= 0 && !bl) {
                n4 = songTrack.getOffset() + note.getEffect().getTrill().getFret() + ((InstrumentString)songTrack.getStrings().get(note.getString() - 1)).getValue();
                long l4 = note.getEffect().getTrill().getDuration().getTime();
                n3 = 1;
                long l5 = l2;
                while (l5 + 10L < l2 + l3) {
                    if (l5 + l4 >= l2 + l3) {
                        l4 = l2 + l3 - l5 - 1L;
                    }
                    this.makeNote(midiSequence, n, n3 != 0 ? n5 : n4, l5, l4, n6, s);
                    n3 = n3 == 0 ? 1 : 0;
                    l5 += l4;
                }
                continue;
            }
            if (note.getEffect().isTremoloPicking() && s2 >= 0) {
                long l6 = note.getEffect().getTremoloPicking().getDuration().getTime();
                long l7 = l2;
                while (l7 + 10L < l2 + l3) {
                    if (l7 + l6 >= l2 + l3) {
                        l6 = l2 + l3 - l7 - 1L;
                    }
                    this.makeNote(midiSequence, n, n5, l7, l6, n6, s);
                    l7 += l6;
                }
                continue;
            }
            if (note.getEffect().isBend() && s2 >= 0 && !bl) {
                s = s2;
                this.makeBend(midiSequence, n, l2, l3, note.getEffect().getBend(), s);
            } else if (note.getEffect().isTremoloBar() && s2 >= 0 && !bl) {
                s = s2;
                this.makeTremoloBar(midiSequence, n, l2, l3, note.getEffect().getTremoloBar(), s);
            } else if (note.getEffect().isSlide() && s2 >= 0 && !bl) {
                s = s2;
                Note note2 = this.getNextNote(note, songTrack.getMeasures(), n2, i);
                this.makeSlide(midiSequence, n, note, note2, l, s);
            } else if (note.getEffect().isVibrato() && s2 >= 0 && !bl) {
                s = s2;
                this.makeVibrato(midiSequence, n, l2, l3, s);
            }
            if (note.getEffect().isHarmonic()) {
                if (note.getEffect().getHarmonic().isArtificial() && !bl) {
                    n5 = Math.min(124, n5 + note.getEffect().getHarmonic().getData());
                } else if (note.getEffect().getHarmonic().isTapped() && !bl) {
                    n5 = Math.min(124, n5 + 12 + note.getEffect().getHarmonic().getData());
                } else if (note.getEffect().getHarmonic().isPinch() && !bl) {
                    n5 = Math.min(124, n5 + 7);
                } else if (note.getEffect().getHarmonic().isSemi() && !bl) {
                    n6 = Math.max(15, n6 - 32);
                    this.makeNote(midiSequence, n, n5 + 12, l2, l3, n6, s);
                }
            }
            this.makeNote(midiSequence, n, n5, l2, l3, n6, s);
        }
    }

    private void makeNote(MidiSequence midiSequence, int n, int n2, long l, long l2, int n3, int n4) {
        midiSequence.addNoteOn(this.getTick(l), n, n4, n2, n3);
        midiSequence.addNoteOff(this.getTick(l + l2), n, n4, n2, n3);
    }

    public void addMixerValues(MidiSequence midiSequence, int n, SongChannel songChannel) {
        if ((this.flags & 2) != 0) {
            this.addMixerValues(midiSequence, n, songChannel.getChannel(), songChannel.getInstrument(), songChannel.getVolume(), songChannel.getBalance());
            if (songChannel.getChannel() != songChannel.getEffectChannel()) {
                this.addMixerValues(midiSequence, n, songChannel.getEffectChannel(), songChannel.getInstrument(), songChannel.getVolume(), songChannel.getBalance());
            }
        }
    }

    public void addMixerValues(MidiSequence midiSequence, int n, int n2, int n3, int n4, int n5) {
        midiSequence.addProgramChange(this.getTick(1000L), n, n2, n3);
        midiSequence.addControlChange(this.getTick(1000L), n, n2, 7, n4);
        midiSequence.addControlChange(this.getTick(1000L), n, n2, 10, n5);
    }

    private void addTimeSignature(MidiSequence midiSequence, Measure measure, Measure measure2, long l) {
        boolean bl = false;
        if (measure2 == null) {
            bl = true;
        } else {
            int n = measure.getTimeSignature().getNumerator();
            int n2 = measure.getTimeSignature().getDenominator().getValue();
            int n3 = measure2.getTimeSignature().getNumerator();
            int n4 = measure2.getTimeSignature().getDenominator().getValue();
            if (n != n3 || n2 != n4) {
                bl = true;
            }
        }
        if (bl) {
            midiSequence.addTimeSignature(this.getTick(measure.getStart() + l), this.infoIndex(), measure.getTimeSignature());
        }
    }

    private void addTempo(MidiSequence midiSequence, Measure measure, Measure measure2, long l) {
        boolean bl = false;
        if (measure2 == null) {
            bl = true;
        } else if (measure.getTempo().getInUSQ() != measure2.getTempo().getInUSQ()) {
            bl = true;
        }
        if (bl) {
            midiSequence.addTempoInUSQ(this.getTick(measure.getStart() + l), this.infoIndex(), (int)measure.getTempo().getInUSQ());
        }
    }

    private long getRealNoteDuration(Note note, long l, List list, int n, int n2) {
        if (note.getEffect().isDeadNote()) {
            return 50L;
        }
        ++n2;
        for (int i = n; i < list.size(); ++i) {
            Measure measure = (Measure)list.get(i);
            for (int j = n2; j < measure.getNotes().size(); ++j) {
                Note note2 = (Note)measure.getNotes().get(j);
                if (note2.equals(note) || note2.getString() != note.getString()) continue;
                if (note2.isTiedNote()) {
                    l += note2.getDuration().getTime();
                    continue;
                }
                return this.applyDurationEffects(note, l);
            }
            n2 = 0;
        }
        return this.applyDurationEffects(note, l);
    }

    private long applyDurationEffects(Note note, long l) {
        if (note.getEffect().isPalmMute()) {
            l = (long)((double)l * 75.0 / 100.0);
        } else if (note.getEffect().isStaccato()) {
            l = (long)((double)l * 50.0 / 100.0);
        }
        return l;
    }

    private int getRealVelocity(Note note, SongTrack songTrack, int n, int n2) {
        Note note2;
        int n3 = note.getVelocity();
        if (!songTrack.isPercussionTrack() && (note2 = this.getPrevNote(note, songTrack.getMeasures(), n, n2)) != null && note2.getEffect().isHammer()) {
            n3 = Math.max(15, n3 - 25);
        }
        if (note.getEffect().isGhostNote()) {
            n3 = Math.max(15, n3 - 16);
        } else if (note.getEffect().isAccentuatedNote()) {
            n3 = Math.max(15, n3 + 16);
        } else if (note.getEffect().isHeavyAccentuatedNote()) {
            n3 = Math.max(15, n3 + 32);
        }
        return n3 > 127 ? 127 : n3;
    }

    public void addMetronome(MidiSequence midiSequence, MeasureHeader measureHeader, long l) {
        if ((this.flags & 4) != 0) {
            long l2 = l + measureHeader.getStart();
            long l3 = measureHeader.getTimeSignature().getDenominator().getTime();
            for (int i = 1; i <= measureHeader.getTimeSignature().getNumerator(); ++i) {
                this.makeNote(midiSequence, this.metronomeIndex(), 37, l2, l3, 95, 9);
                l2 += l3;
            }
        }
    }

    public void addStartMoveMetaMessage(MidiSequence midiSequence, long l, long l2) {
        if ((this.flags & 8) != 0) {
            midiSequence.addTickMove(this.getTick(l + l2), this.infoIndex(), l2);
        }
    }

    public void addDefaultMessages(MidiSequence midiSequence) {
        if ((this.flags & 1) != 0) {
            for (int i = 0; i < 16; ++i) {
                midiSequence.addControlChange(this.getTick(1000L), this.infoIndex(), i, 100, 0);
                midiSequence.addControlChange(this.getTick(1000L), this.infoIndex(), i, 101, 0);
                midiSequence.addControlChange(this.getTick(1000L), this.infoIndex(), i, 6, 12);
                midiSequence.addControlChange(this.getTick(1000L), this.infoIndex(), i, 101, 0);
                midiSequence.addControlChange(this.getTick(1000L), this.infoIndex(), i, 100, 1);
                midiSequence.addControlChange(this.getTick(1000L), this.infoIndex(), i, 6, 64);
                midiSequence.addControlChange(this.getTick(1000L), this.infoIndex(), i, 100, 127);
            }
        }
    }

    private void addBend(MidiSequence midiSequence, int n, long l, int n2, int n3) {
        midiSequence.addPitchBend(this.getTick(l), n, n3, n2);
    }

    public void makeVibrato(MidiSequence midiSequence, int n, long l, long l2, int n2) {
        long l3 = l + l2;
        while (l < l3) {
            l = l + 160L > l3 ? l3 : l + 160L;
            this.addBend(midiSequence, n, l, 64, n2);
            l = l + 160L > l3 ? l3 : l + 160L;
            this.addBend(midiSequence, n, l, 65, n2);
        }
        this.addBend(midiSequence, n, l, 64, n2);
    }

    public void makeBend(MidiSequence midiSequence, int n, long l, long l2, BendEffect bendEffect, int n2) {
        List list = bendEffect.getPoints();
        for (int i = 0; i < list.size(); ++i) {
            BendEffect.BendPoint bendPoint = (BendEffect.BendPoint)list.get(i);
            long l3 = l + bendPoint.getTime(l2);
            int n3 = 64 + (int)((float)bendPoint.getValue() * 5.5f / 2.0f);
            n3 = n3 <= 127 ? n3 : 127;
            n3 = n3 >= 0 ? n3 : 0;
            this.addBend(midiSequence, n, l3, n3, n2);
            if (list.size() <= i + 1) continue;
            BendEffect.BendPoint bendPoint2 = (BendEffect.BendPoint)list.get(i + 1);
            int n4 = 64 + (int)((float)bendPoint2.getValue() * 5.5f / 2.0f);
            long l4 = l + bendPoint2.getTime(l2);
            if (n4 == n3) continue;
            double d = (l4 - l3) / (long)Math.abs(n4 - n3);
            if (n3 < n4) {
                while (n3 < n4) {
                    l3 = (long)((double)l3 + d);
                    this.addBend(midiSequence, n, l3, ++n3 <= 127 ? n3 : 127, n2);
                }
                continue;
            }
            if (n3 <= n4) continue;
            while (n3 > n4) {
                l3 = (long)((double)l3 + d);
                this.addBend(midiSequence, n, l3, --n3 >= 0 ? n3 : 0, n2);
            }
        }
        this.addBend(midiSequence, n, l + l2, 64, n2);
    }

    public void makeTremoloBar(MidiSequence midiSequence, int n, long l, long l2, TremoloBarEffect tremoloBarEffect, int n2) {
        List list = tremoloBarEffect.getPoints();
        for (int i = 0; i < list.size(); ++i) {
            TremoloBarEffect.TremoloBarPoint tremoloBarPoint = (TremoloBarEffect.TremoloBarPoint)list.get(i);
            long l3 = l + tremoloBarPoint.getTime(l2);
            int n3 = 64 + (int)((float)tremoloBarPoint.getValue() * 5.5f / 1.0f);
            n3 = n3 <= 127 ? n3 : 127;
            n3 = n3 >= 0 ? n3 : 0;
            this.addBend(midiSequence, n, l3, n3, n2);
            if (list.size() <= i + 1) continue;
            TremoloBarEffect.TremoloBarPoint tremoloBarPoint2 = (TremoloBarEffect.TremoloBarPoint)list.get(i + 1);
            int n4 = 64 + (int)((float)tremoloBarPoint2.getValue() * 5.5f / 1.0f);
            long l4 = l + tremoloBarPoint2.getTime(l2);
            if (n4 == n3) continue;
            double d = (l4 - l3) / (long)Math.abs(n4 - n3);
            if (n3 < n4) {
                while (n3 < n4) {
                    l3 = (long)((double)l3 + d);
                    this.addBend(midiSequence, n, l3, ++n3 <= 127 ? n3 : 127, n2);
                }
                continue;
            }
            if (n3 <= n4) continue;
            while (n3 > n4) {
                l3 = (long)((double)l3 + d);
                this.addBend(midiSequence, n, l3, --n3 >= 0 ? n3 : 0, n2);
            }
        }
        this.addBend(midiSequence, n, l + l2, 64, n2);
    }

    public void makeSlide(MidiSequence midiSequence, int n, Note note, Note note2, long l, int n2) {
        if (note2 != null) {
            this.makeSlide(midiSequence, n, note.getStart() + l, note.getValue(), note2.getStart() + l, note2.getValue(), n2);
            this.addBend(midiSequence, n, note2.getStart() + l, 64, n2);
        }
    }

    public void makeSlide(MidiSequence midiSequence, int n, long l, int n2, long l2, int n3, int n4) {
        long l3 = n3 - n2;
        long l4 = l2 - l;
        int n5 = (int)(l4 / 125L);
        for (int i = 1; i <= n5; ++i) {
            float f = (float)(l4 / (long)n5) * (float)i * (float)l3 / (float)l4;
            int n6 = 64 + (int)(f * 5.5f);
            this.addBend(midiSequence, n, l + l4 / (long)n5 * (long)i, n6, n4);
        }
    }

    private void makeFadeIn(MidiSequence midiSequence, int n, long l, long l2, int n2, int n3) {
        int n4 = 40;
        if (n2 > n4) {
            int n5 = (int)(l2 / 4L);
            int n6 = (int)(l2 / (long)n5);
            int n7 = (n2 - n4) / n6;
            for (long i = l; i < l + l2; i += (long)n5) {
                midiSequence.addControlChange(this.getTick(i), n, n3, 7, n4);
                n4 += n7;
            }
            midiSequence.addControlChange(this.getTick(l + l2), n, n3, 7, n2);
        }
    }

    private Note getNextNote(Note note, List list, int n, int n2) {
        ++n2;
        for (int i = n; i < list.size(); ++i) {
            Measure measure = (Measure)list.get(i);
            for (int j = n2; j < measure.getNotes().size(); ++j) {
                Note note2 = (Note)measure.getNotes().get(j);
                if (note2.getStart() <= note.getStart()) continue;
                if (note2.getString() == note.getString()) {
                    return note2;
                }
                return null;
            }
            n2 = 0;
        }
        return null;
    }

    private Note getPrevNote(Note note, List list, int n, int n2) {
        Note note2 = null;
        for (int i = n; i >= 0; --i) {
            Measure measure = (Measure)list.get(i);
            if (n2 < 0) {
                n2 = measure.getNotes().size();
            }
            for (int j = n2 - 1; j >= 0; --j) {
                Note note3 = (Note)measure.getNotes().get(j);
                if (note3.getString() != note.getString() || note3.getStart() >= note.getStart() || note2 != null && note3.getStart() <= note2.getStart()) continue;
                note2 = note3;
            }
            if (note2 != null) break;
            n2 = -1;
        }
        return note2;
    }

    private NoteData checkTripletFeel(Measure measure, Note note, int n) {
        NoteData noteData = new NoteData();
        noteData.start = note.getStart();
        noteData.duration = note.getDuration().getTime();
        if (measure.getTripletFeel() == 2) {
            if (note.getDuration().isEqual(new Duration(8, false, false, Duration.NO_TUPLETO))) {
                Note note2;
                int n2 = (int)(Math.round((double)note.getStart() / 10.0) * 10L % 1000L);
                if (n2 == 0) {
                    Note note3 = this.getNextNote(note, measure, n);
                    if (note3 != null && note3.getDuration().isEqual(new Duration(8, false, false, Duration.NO_TUPLETO))) {
                        noteData.duration = new Duration(8, false, false, new Tupleto(3, 2)).getTime() * 2L;
                    }
                } else if ((long)n2 == 500L && (note2 = this.getPrevNote(note, measure, n)) != null && note2.getDuration().isEqual(new Duration(8, false, false, Duration.NO_TUPLETO))) {
                    Duration duration = new Duration(8, false, false, new Tupleto(3, 2));
                    noteData.start = note2.getStart() + duration.getTime() * 2L;
                    noteData.duration = duration.getTime();
                }
            }
        } else if (measure.getTripletFeel() == 3 && note.getDuration().isEqual(new Duration(16, false, false, Duration.NO_TUPLETO))) {
            Note note4;
            int n3 = (int)(Math.round((double)note.getStart() / 10.0) * 10L % 500L);
            if (n3 == 0) {
                Note note5 = this.getNextNote(note, measure, n);
                if (note5 != null && note5.getDuration().isEqual(new Duration(16, false, false, Duration.NO_TUPLETO))) {
                    noteData.duration = new Duration(16, false, false, new Tupleto(3, 2)).getTime() * 2L;
                }
            } else if ((long)n3 == 250L && (note4 = this.getPrevNote(note, measure, n)) != null && note4.getDuration().isEqual(new Duration(16, false, false, Duration.NO_TUPLETO))) {
                Duration duration = new Duration(16, false, false, new Tupleto(3, 2));
                noteData.start = note4.getStart() + duration.getTime() * 2L;
                noteData.duration = duration.getTime();
            }
        }
        return noteData;
    }

    private Note getPrevNote(Note note, Measure measure, int n) {
        Note note2 = null;
        for (int i = n - 1; i >= 0; --i) {
            Note note3 = (Note)measure.getNotes().get(i);
            if (note3.getStart() >= note.getStart() || note2 != null && note3.getStart() <= note2.getStart()) continue;
            note2 = note3;
        }
        return note2;
    }

    private Note getNextNote(Note note, Measure measure, int n) {
        Note note2 = null;
        for (int i = n + 1; i < measure.getNotes().size(); ++i) {
            Note note3 = (Note)measure.getNotes().get(i);
            if (note3.getStart() <= note.getStart() || note2 != null && note3.getStart() >= note2.getStart()) continue;
            note2 = note3;
        }
        return note2;
    }

    private class NoteData {
        private long start;
        private long duration;

        private NoteData() {
        }
    }
}

