/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gp;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;

class JoinVoicesHelper {
    private Measure measure;

    public JoinVoicesHelper(Measure measure) {
        this.measure = measure;
    }

    public void process() {
        if (!this.measure.getNotes().isEmpty()) {
            long l;
            this.orderNotes();
            long l2 = this.measure.getStart();
            long l3 = this.measure.getLength();
            for (long i = ((Note)this.measure.getNotes().get(0)).getStart(); i < l2 + l3; i += l) {
                List list = this.getNotesAtBeat(i);
                l = this.getMaxLength(i);
                this.normalizeNotes(list, l);
            }
        }
    }

    private void normalizeNotes(List list, long l) {
        Duration duration = null;
        for (Note note : list) {
            long l2 = note.getDuration().getTime();
            if (l2 > l || duration != null && l2 <= duration.getTime()) continue;
            duration = note.getDuration();
        }
        if (duration == null) {
            duration = Duration.fromTime(l);
        }
        if (duration != null) {
            for (Note note : list) {
                note.setDuration((Duration)duration.clone());
            }
        }
    }

    private List getNotesAtBeat(long l) {
        ArrayList<Note> arrayList = new ArrayList<Note>();
        for (Note note : this.measure.getNotes()) {
            if (note.getStart() != l) continue;
            arrayList.add(note);
        }
        return arrayList;
    }

    private long getMaxLength(long l) {
        long l2 = -1L;
        for (Note note : this.measure.getNotes()) {
            if (note.getStart() <= l || l2 >= 0L && note.getStart() >= l2) continue;
            l2 = note.getStart();
        }
        if (l2 < 0L) {
            l2 = this.measure.getStart() + this.measure.getLength();
        }
        return l2 - l;
    }

    private void orderNotes() {
        int n = this.measure.getNotes().size();
        for (int i = 0; i < n; ++i) {
            Note note = null;
            for (int j = i; j < n; ++j) {
                Note note2 = (Note)this.measure.getNotes().get(j);
                if (note == null) {
                    note = note2;
                    continue;
                }
                if (note2.getStart() < note.getStart()) {
                    note = note2;
                    continue;
                }
                if (note2.getStart() != note.getStart() || note2.getString() >= note.getString()) continue;
                note = note2;
            }
            this.measure.getNotes().remove(note);
            this.measure.getNotes().add(i, note);
        }
    }
}

