/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.io.gp.JoinVoicesHelper;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Lyric;
import org.herac.tuxguitar.song.models.Marker;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.effects.BendEffect;
import org.herac.tuxguitar.song.models.effects.GraceEffect;
import org.herac.tuxguitar.song.models.effects.HarmonicEffect;
import org.herac.tuxguitar.song.models.effects.TremoloBarEffect;
import org.herac.tuxguitar.song.models.effects.TremoloPickingEffect;
import org.herac.tuxguitar.song.models.effects.TrillEffect;

public class GP5InputStream
extends InputStream {
    private static final String[] supportedVersions = new String[]{"FICHIER GUITAR PRO v5.00"};
    private static final int GP_BEND_SEMITONE = 50;
    private static final int GP_BEND_POSITION = 60;
    private String version;
    private InputStream inputStream;
    private int offset;

    public GP5InputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.offset = 0;
    }

    public GP5InputStream(String string) throws FileNotFoundException {
        this(new FileInputStream(new File(string)));
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public int read() throws IOException {
        ++this.offset;
        return this.inputStream.read();
    }

    private void readVersion() {
        try {
            if (this.version == null) {
                this.version = this.readStringByte(30);
            }
        }
        catch (IOException iOException) {
            this.version = "NOT_SUPPORTED";
        }
    }

    public static boolean isSupportedVersion(String string) {
        for (int i = 0; i < supportedVersions.length; ++i) {
            if (!string.equals(supportedVersions[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isSupportedVersion() {
        try {
            this.readVersion();
            return GP5InputStream.isSupportedVersion(this.version);
        }
        catch (Exception exception) {
            return false;
        }
        catch (Error error) {
            return false;
        }
    }

    public Song readSong() throws IOException, GPFormatException {
        int n;
        int n2;
        int n3;
        this.readVersion();
        if (!GP5InputStream.isSupportedVersion(this.version)) {
            throw new GPFormatException("Unsuported Version");
        }
        String string = this.readStringIntegerPlusOne();
        String string2 = this.readStringIntegerPlusOne();
        String string3 = this.readStringIntegerPlusOne();
        String string4 = this.readStringIntegerPlusOne();
        String string5 = this.readStringIntegerPlusOne();
        String string6 = this.readStringIntegerPlusOne();
        String string7 = this.readStringIntegerPlusOne();
        String string8 = this.readStringIntegerPlusOne();
        String string9 = this.readStringIntegerPlusOne();
        int n4 = this.readInt();
        String string10 = "";
        for (n3 = 0; n3 < n4; ++n3) {
            string10 = string10 + this.readStringIntegerPlusOne();
            string10 = string10 + "\n";
        }
        n3 = this.readInt();
        Lyric lyric = new Lyric(this.readInt(), this.readStringInteger());
        for (n2 = 0; n2 < 4; ++n2) {
            n = this.readInt();
            String string11 = this.readStringInteger();
        }
        this.skipBytes(30);
        for (n2 = 0; n2 < 11; ++n2) {
            this.readInt();
            this.readStringByte(0);
        }
        n2 = this.readInt();
        n = this.readByte();
        int n5 = this.readInt();
        ArrayList<SongChannel> arrayList = new ArrayList<SongChannel>();
        int[] nArray = new int[64];
        for (int i = 0; i < 64; ++i) {
            arrayList.add(new SongChannel((short)i, (short)i, (short)this.readInt(), this.toChannelShort(this.readByte()), this.toChannelShort(this.readByte()), this.toChannelShort(this.readByte()), this.toChannelShort(this.readByte()), this.toChannelShort(this.readByte()), this.toChannelShort(this.readByte()), false, false));
            byte[] byArray = new byte[]{0, 0};
            this.read(byArray);
        }
        TimeSignature timeSignature = new TimeSignature(4, new Duration(4));
        this.skipBytes(42);
        int n6 = this.readInt();
        int n7 = this.readInt();
        ArrayList<MeasureHeader> arrayList2 = new ArrayList<MeasureHeader>();
        if (n6 > 0) {
            for (int i = 0; i < n6; ++i) {
                if (i > 0) {
                    this.skipBytes(1);
                }
                MeasureHeader measureHeader = this.createMeasureHeader(i + 1, timeSignature);
                arrayList2.add(measureHeader);
            }
        }
        ArrayList<SongTrack> arrayList3 = new ArrayList<SongTrack>();
        for (int i = 1; i <= n7; ++i) {
            arrayList3.add(this.createTrack(i, arrayList, i == n3 ? lyric : new Lyric()));
        }
        this.skipBytes(2);
        long l = 1000L;
        for (int i = 0; i < n6; ++i) {
            MeasureHeader measureHeader = (MeasureHeader)arrayList2.get(i);
            Tempo tempo = new Tempo(n2);
            measureHeader.setStart(l);
            for (int j = 0; j < n7; ++j) {
                SongTrack songTrack = (SongTrack)arrayList3.get(j);
                Measure measure = new Measure(measureHeader, new ArrayList(), new ArrayList(), 1, 0);
                this.addMeasureComponents(songTrack.getStrings(), measure, songTrack.getMeasures(), tempo);
                measureHeader.setTempo(tempo);
                songTrack.getMeasures().add(measure);
                this.skipBytes(1);
            }
            n2 = tempo.getValue();
            l += measureHeader.getLength();
        }
        return new Song(string, string3, string4, string5, arrayList3, arrayList2, 10);
    }

    private long addNotes(long l, List list, List list2, List list3, Tempo tempo) throws IOException, GPFormatException {
        int n;
        int n2;
        int n3;
        NoteEffect noteEffect = new NoteEffect();
        int n4 = this.readUnsignedByte();
        if ((n4 & 0x40) != 0) {
            n3 = this.readUnsignedByte();
            boolean bl = n3 == 0;
            n2 = n3 == 2 ? 1 : 0;
        }
        n3 = (n4 & 1) != 0 ? 1 : 0;
        Duration duration = this.parseDuration(this.readByte());
        duration.setDotted(n3 != 0);
        if ((n4 & 0x20) != 0) {
            n2 = this.readInt();
            switch (n2) {
                case 3: {
                    duration.getTupleto().setEnters(3);
                    duration.getTupleto().setTimes(2);
                    break;
                }
                case 5: {
                    duration.getTupleto().setEnters(5);
                    duration.getTupleto().setTimes(4);
                    break;
                }
                case 6: {
                    duration.getTupleto().setEnters(6);
                    duration.getTupleto().setTimes(4);
                    break;
                }
                case 7: {
                    duration.getTupleto().setEnters(7);
                    duration.getTupleto().setTimes(4);
                    break;
                }
                case 9: {
                    duration.getTupleto().setEnters(9);
                    duration.getTupleto().setTimes(8);
                    break;
                }
                case 10: {
                    duration.getTupleto().setEnters(10);
                    duration.getTupleto().setTimes(8);
                    break;
                }
                case 11: {
                    duration.getTupleto().setEnters(11);
                    duration.getTupleto().setTimes(8);
                    break;
                }
                case 12: {
                    duration.getTupleto().setEnters(12);
                    duration.getTupleto().setTimes(8);
                }
            }
        }
        if ((n4 & 2) != 0) {
            this.readChordDiagram();
        }
        if ((n4 & 4) != 0) {
            String string = this.readStringIntegerPlusOne();
        }
        if ((n4 & 8) != 0) {
            this.readBeatEffects(noteEffect, duration);
        }
        if ((n4 & 0x10) != 0) {
            this.readMixChange(tempo);
        }
        int n5 = this.readUnsignedByte();
        List list4 = this.getPlayedStrings(n5, list2);
        for (n = list4.size() - 1; n >= 0; --n) {
            InstrumentString instrumentString = (InstrumentString)list4.get(n);
            Note note = this.parseNote(l, instrumentString, duration, list, list3, (NoteEffect)noteEffect.clone());
            if (note == null) continue;
            list.add(note);
        }
        this.skipBytes(1);
        n = this.readByte();
        if (n >= 8 && n < 32) {
            this.skipBytes(1);
        }
        return duration.getTime();
    }

    private List getPlayedStrings(int n, List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if ((n & 1) != 0 && list.size() > 6) {
            arrayList.add(((InstrumentString)list.get(6)).clone());
        }
        if ((n & 2) != 0 && list.size() > 5) {
            arrayList.add(((InstrumentString)list.get(5)).clone());
        }
        if ((n & 4) != 0 && list.size() > 4) {
            arrayList.add(((InstrumentString)list.get(4)).clone());
        }
        if ((n & 8) != 0 && list.size() > 3) {
            arrayList.add(((InstrumentString)list.get(3)).clone());
        }
        if ((n & 0x10) != 0 && list.size() > 2) {
            arrayList.add(((InstrumentString)list.get(2)).clone());
        }
        if ((n & 0x20) != 0 && list.size() > 1) {
            arrayList.add(((InstrumentString)list.get(1)).clone());
        }
        if ((n & 0x40) != 0 && list.size() > 0) {
            arrayList.add(((InstrumentString)list.get(0)).clone());
        }
        return arrayList;
    }

    private Duration parseDuration(byte by) {
        Duration duration = null;
        switch (by) {
            case -2: {
                duration = new Duration(1);
                break;
            }
            case -1: {
                duration = new Duration(2);
                break;
            }
            case 0: {
                duration = new Duration(4);
                break;
            }
            case 1: {
                duration = new Duration(8);
                break;
            }
            case 2: {
                duration = new Duration(16);
                break;
            }
            case 3: {
                duration = new Duration(32);
                break;
            }
            case 4: {
                duration = new Duration(64);
            }
        }
        if (duration == null) {
            duration = new Duration(4);
            System.err.println("Incorrect Duration. Forcing duration Quarter as Default.");
        }
        return duration;
    }

    private int getTiedNoteValue(int n, List list, List list2) {
        Serializable serializable;
        int n2;
        if (!list.isEmpty()) {
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                serializable = (Note)list.get(n2);
                if (((Note)serializable).getString() != n) continue;
                return ((Note)serializable).getValue();
            }
        }
        if (!list2.isEmpty()) {
            for (n2 = list2.size() - 1; n2 >= 0; --n2) {
                serializable = (Measure)list2.get(n2);
                for (int i = ((Measure)serializable).getNotes().size() - 1; i >= 0; --i) {
                    Note note = (Note)((Measure)serializable).getNotes().get(i);
                    if (note.getString() != n) continue;
                    return note.getValue();
                }
            }
        }
        return -1;
    }

    private boolean readBoolean() throws IOException {
        return this.read() == 1;
    }

    private byte readByte() throws IOException {
        return (byte)this.read();
    }

    private RGBColor readColor() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        this.read();
        return new RGBColor(n, n2, n3);
    }

    private int readInt() throws IOException {
        int n = 0;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        this.read(byArray);
        n = (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        return n;
    }

    private Marker readMarker(int n) throws IOException {
        String string = this.readStringIntegerPlusOne();
        RGBColor rGBColor = this.readColor();
        return new Marker(n, string, rGBColor);
    }

    private MeasureHeader createMeasureHeader(int n, TimeSignature timeSignature) throws IOException {
        byte by;
        int n2 = this.readUnsignedByte();
        byte by2 = 0;
        if ((n2 & 1) != 0) {
            by2 = this.readByte();
        }
        byte by3 = 0;
        if ((n2 & 2) != 0) {
            by3 = this.readByte();
        }
        boolean bl = (n2 & 4) != 0;
        int n3 = 0;
        if ((n2 & 8) != 0) {
            n3 = this.readByte() - 1;
        }
        Marker marker = null;
        if ((n2 & 0x20) != 0) {
            marker = this.readMarker(n);
        }
        byte by4 = 0;
        if ((n2 & 0x10) != 0) {
            by4 = this.readByte();
        }
        if ((n2 & 0x40) != 0) {
            by = this.readByte();
            this.readByte();
        }
        if ((n2 & 0x80) != 0) {
            // empty if block
        }
        byte by5 = by = (n2 & 0x80) != 0 ? (byte)1 : 0;
        if (by2 > 0) {
            timeSignature.setNumerator(by2);
        }
        if (by3 > 0) {
            timeSignature.setDenominator(new Duration(by3));
        }
        if (by4 == 0) {
            this.skipBytes(1);
        }
        if ((n2 & 1) != 0) {
            this.skipBytes(4);
        }
        int n4 = 1;
        byte by6 = this.readByte();
        if (by6 == 1) {
            n4 = 2;
        } else if (by6 == 2) {
            n4 = 3;
        }
        return new MeasureHeader(n, 0L, (TimeSignature)timeSignature.clone(), new Tempo(120), marker, n4, bl, n3);
    }

    private void addMeasureComponents(List list, Measure measure, List list2, Tempo tempo) throws IOException, GPFormatException {
        int n;
        long l = measure.getStart();
        int n2 = this.readInt();
        for (n = 0; n < n2; ++n) {
            l += this.addNotes(l, measure.getNotes(), list, list2, tempo);
        }
        n = measure.getNotes().size();
        l = measure.getStart();
        n2 = this.readInt();
        for (int i = 0; i < n2; ++i) {
            l += this.addNotes(l, measure.getNotes(), list, list2, tempo);
        }
        if (n < measure.getNotes().size()) {
            new JoinVoicesHelper(measure).process();
        }
    }

    private Note parseNote(long l, InstrumentString instrumentString, Duration duration, List list, List list2, NoteEffect noteEffect) throws IOException {
        int n;
        int n2;
        int n3 = this.readUnsignedByte();
        noteEffect.setAccentuatedNote((n3 & 0x40) != 0);
        noteEffect.setHeavyAccentuatedNote((n3 & 2) != 0);
        noteEffect.setGhostNote((n3 & 4) != 0);
        boolean bl = false;
        boolean bl2 = false;
        if ((n3 & 0x20) != 0) {
            n2 = this.readUnsignedByte();
            bl = n2 == 2;
            noteEffect.setDeadNote(n2 == 3);
        }
        if ((n3 & 1) != 0) {
            // empty if block
        }
        n2 = 95;
        if ((n3 & 0x10) != 0) {
            n2 = 15 + 16 * this.readByte() - 16;
        }
        int n4 = 0;
        if ((n3 & 0x20) != 0) {
            n4 = this.readByte();
        }
        if ((n3 & 0x80) != 0) {
            n = this.readByte();
            byte by = this.readByte();
        }
        if ((n3 & 1) != 0) {
            this.skipBytes(8);
        }
        this.skipBytes(1);
        if ((n3 & 8) != 0) {
            this.readNoteEffects(noteEffect, duration);
        }
        n = n4;
        if (n4 >= 0 || bl) {
            if (bl) {
                n = this.getTiedNoteValue(instrumentString.getNumber(), list, list2);
            }
            return new Note(n, l, (Duration)duration.clone(), n2, instrumentString.getNumber(), bl, noteEffect);
        }
        return null;
    }

    private String readStringByte(int n) throws IOException {
        int n2 = this.readUnsignedByte();
        byte[] byArray = n != 0 ? new byte[n] : new byte[n2];
        this.read(byArray);
        n2 = n2 >= 0 ? n2 : n;
        return new String(byArray, 0, n2);
    }

    private String readStringInteger() throws IOException {
        int n = this.readInt();
        byte[] byArray = new byte[n];
        this.read(byArray);
        String string = new String(byArray);
        return string;
    }

    private String readStringIntegerPlusOne() throws IOException {
        int n = this.readInt();
        int n2 = n - 1;
        if (n2 != this.read()) {
            throw new IOException();
        }
        byte[] byArray = new byte[n2];
        this.read(byArray);
        String string = new String(byArray);
        return string;
    }

    private SongTrack createTrack(int n, List list, Lyric lyric) throws IOException {
        int n2;
        int n3;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = this.readUnsignedByte();
        boolean bl3 = (n4 & 1) != 0;
        boolean bl4 = (n4 & 2) != 0;
        boolean bl5 = (n4 & 4) != 0;
        this.skipBytes(1);
        String string = this.readStringByte(40);
        int n5 = this.readInt();
        ArrayList<InstrumentString> arrayList = new ArrayList<InstrumentString>(n5);
        for (n3 = 0; n3 < 7; ++n3) {
            n2 = this.readInt();
            if (n5 <= n3) continue;
            arrayList.add(new InstrumentString(n3 + 1, n2));
        }
        n3 = this.readInt();
        n2 = this.readInt();
        int n6 = this.readInt();
        int n7 = this.readInt();
        int n8 = this.readInt();
        RGBColor rGBColor = this.readColor();
        this.skipBytes(44);
        return new SongTrack(n, string, this.parseChannel(list, n2, n6), new ArrayList(), arrayList, n8, rGBColor, lyric);
    }

    private SongChannel parseChannel(List list, int n, int n2) {
        SongChannel songChannel = (SongChannel)list.get(n - 1);
        short s = songChannel.getInstrument();
        if (s == -1) {
            songChannel.setInstrument((short)0);
        }
        if (!songChannel.isPercusionChannel()) {
            songChannel.setEffectChannel((short)(n2 - 1));
        }
        return songChannel;
    }

    private int readUnsignedByte() throws IOException {
        return this.read();
    }

    private void readChordType() throws IOException {
        this.readUnsignedByte();
    }

    private void readRoot() throws IOException {
        this.readByte();
    }

    private void readTonalityType(int n) throws IOException {
        if (n == 1) {
            int n2 = this.readUnsignedByte();
        } else if (n == 4) {
            int n3 = this.readInt();
        }
    }

    private String readChordName() throws IOException {
        byte[] byArray = new byte[21];
        char[] cArray = new char[20];
        this.read(byArray, 0, 21);
        int n = 20;
        if (byArray[0] < n) {
            n = byArray[0];
        }
        for (int i = 1; i <= n; ++i) {
            cArray[i - 1] = (char)byArray[i];
        }
        return String.valueOf(cArray, 0, n);
    }

    private void readChordDiagram() throws IOException, GPFormatException {
        int n;
        int n2;
        int n3;
        int n4 = this.readUnsignedByte();
        if ((n4 & 1) == 0) {
            throw new GPFormatException("Cannot Read Chord Diagram");
        }
        boolean bl = this.readBoolean();
        this.skip(3L);
        this.readRoot();
        this.readChordType();
        int n5 = this.readUnsignedByte();
        int n6 = this.readInt();
        this.readTonalityType(4);
        int n7 = this.readUnsignedByte();
        String string = this.readChordName();
        this.skip(2L);
        this.readTonalityType(1);
        this.readTonalityType(1);
        this.readTonalityType(1);
        int n8 = this.readInt();
        for (n3 = 1; n3 <= 7; ++n3) {
            n2 = this.readInt();
        }
        n2 = this.readUnsignedByte();
        for (n3 = 1; n3 <= 5; ++n3) {
            n = this.readUnsignedByte();
        }
        for (n3 = 1; n3 <= 5; ++n3) {
            n = this.readUnsignedByte();
        }
        for (n3 = 1; n3 <= 5; ++n3) {
            n = this.readUnsignedByte();
        }
        long l = this.skip(8L);
        for (n3 = 1; n3 <= 7; ++n3) {
            n = this.readByte();
        }
        n = this.readBoolean() ? 1 : 0;
    }

    private void readGraceNote() throws IOException {
        this.skipBytes(5);
    }

    private void readGraceNote(NoteEffect noteEffect) throws IOException {
        byte by = this.readByte();
        int n = this.readByte();
        int n2 = this.readByte();
        byte by2 = this.readByte();
        byte by3 = this.readByte();
        boolean bl = by == 255;
        by = !bl ? by : (byte)0;
        n = 15 + 16 * n - 16;
        if (n2 == 0) {
            n2 = 0;
        } else if (n2 == 1) {
            n2 = 1;
        } else if (n2 == 2) {
            n2 = 2;
        } else if (n2 == 3) {
            n2 = 3;
        }
        noteEffect.setGrace(new GraceEffect(by, by2, n, n2, by3 > 0, bl));
    }

    private void readBend(NoteEffect noteEffect) throws IOException {
        byte by = this.readByte();
        int n = this.readInt();
        BendEffect bendEffect = new BendEffect();
        int n2 = this.readInt();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.readInt();
            int n4 = this.readInt();
            byte by2 = this.readByte();
            bendEffect.addPoint(n3 * 12 / 60, n4 * 2 / 50);
        }
        if (!bendEffect.getPoints().isEmpty()) {
            noteEffect.setBend(bendEffect);
        }
    }

    private void readTremoloBar(NoteEffect noteEffect) throws IOException {
        byte by = this.readByte();
        int n = this.readInt();
        TremoloBarEffect tremoloBarEffect = new TremoloBarEffect();
        int n2 = this.readInt();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.readInt();
            int n4 = this.readInt();
            byte by2 = this.readByte();
            tremoloBarEffect.addPoint(n3 * 12 / 60, n4 * 1 / 50);
        }
        if (!tremoloBarEffect.getPoints().isEmpty()) {
            noteEffect.setTremoloBar(tremoloBarEffect);
        }
    }

    private void readNoteEffects(NoteEffect noteEffect, Duration duration) throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        if ((n & 1) != 0) {
            this.readBend(noteEffect);
        }
        if ((n & 0x10) != 0) {
            this.readGraceNote(noteEffect);
        }
        if ((n2 & 4) != 0) {
            this.readTremoloPicking(noteEffect);
        }
        if ((n2 & 8) != 0) {
            noteEffect.setSlide(true);
            this.readByte();
        }
        if ((n2 & 0x10) != 0) {
            this.readArtificialHarmonic(noteEffect);
        }
        if ((n2 & 0x20) != 0) {
            byte by = this.readByte();
            byte by2 = this.readByte();
            if (by2 == 1) {
                noteEffect.setTrill(new TrillEffect((int)by, new Duration(16)));
            } else if (by2 == 2) {
                noteEffect.setTrill(new TrillEffect((int)by, new Duration(32)));
            } else if (by2 == 3) {
                noteEffect.setTrill(new TrillEffect((int)by, new Duration(64)));
            }
        }
        noteEffect.setHammer((n & 2) != 0);
        noteEffect.setVibrato((n2 & 0x40) != 0 || noteEffect.isVibrato());
        noteEffect.setPalmMute((n2 & 2) != 0);
        noteEffect.setStaccato((n2 & 1) != 0);
    }

    private void readBeatEffects(NoteEffect noteEffect, Duration duration) throws IOException {
        int[] nArray = new int[]{0, 0};
        nArray[0] = this.readUnsignedByte();
        nArray[1] = this.readUnsignedByte();
        noteEffect.setFadeIn((nArray[0] & 0x10) != 0);
        noteEffect.setVibrato((nArray[0] & 2) != 0);
        if ((nArray[0] & 0x20) != 0) {
            int n = this.readUnsignedByte();
            noteEffect.setTapping(n == 1);
            noteEffect.setSlapping(n == 2);
            noteEffect.setPopping(n == 3);
        }
        if ((nArray[1] & 4) != 0) {
            this.readTremoloBar(noteEffect);
        }
        if ((nArray[0] & 0x40) != 0) {
            this.readByte();
            this.readByte();
        }
        if ((nArray[1] & 1) != 0) {
            // empty if block
        }
        if ((nArray[1] & 2) != 0) {
            this.readByte();
        }
    }

    private void readMixChange(Tempo tempo) throws IOException {
        byte by;
        byte by2 = this.readByte();
        this.skipBytes(16);
        byte by3 = this.readByte();
        byte by4 = this.readByte();
        byte by5 = this.readByte();
        byte by6 = this.readByte();
        byte by7 = this.readByte();
        byte by8 = this.readByte();
        String string = this.readStringInteger();
        int n = this.readInt();
        if (by3 >= 0) {
            by = this.readByte();
        }
        if (by4 >= 0) {
            by = this.readByte();
        }
        if (by5 >= 0) {
            by = this.readByte();
        }
        if (by6 >= 0) {
            by = this.readByte();
        }
        if (by7 >= 0) {
            by = this.readByte();
        }
        if (by8 >= 0) {
            by = this.readByte();
        }
        if (n >= 0) {
            tempo.setValue(n);
            by = this.readByte();
        }
        by = this.readByte();
        this.skipBytes(1);
    }

    private void readArtificialHarmonic(NoteEffect noteEffect) throws IOException {
        byte by = this.readByte();
        if (by == 1) {
            noteEffect.setHarmonic(new HarmonicEffect(1));
        } else if (by == 2) {
            byte by2 = this.readByte();
            byte by3 = this.readByte();
            byte by4 = this.readByte();
            noteEffect.setHarmonic(new HarmonicEffect(2, 0));
        } else if (by == 3) {
            noteEffect.setHarmonic(new HarmonicEffect(3, this.readByte()));
        } else if (by == 4) {
            noteEffect.setHarmonic(new HarmonicEffect(4));
        } else if (by == 5) {
            noteEffect.setHarmonic(new HarmonicEffect(5));
        }
    }

    public void readTremoloPicking(NoteEffect noteEffect) throws IOException {
        int n = this.readUnsignedByte();
        if (n == 1) {
            noteEffect.setTremoloPicking(new TremoloPickingEffect(new Duration(8)));
        } else if (n == 2) {
            noteEffect.setTremoloPicking(new TremoloPickingEffect(new Duration(16)));
        } else if (n == 3) {
            noteEffect.setTremoloPicking(new TremoloPickingEffect(new Duration(32)));
        }
    }

    private short toChannelShort(byte by) {
        short s = by;
        return (s = (short)(s * 127 / 16)) <= 127 ? s : (short)127;
    }

    private void skipBytes(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.readByte();
        }
    }

    private void skipBytes(int n, boolean bl) throws IOException {
        System.out.println("---------");
        for (int i = 0; i < n; ++i) {
            byte by = this.readByte();
            System.out.println(by);
        }
        System.out.println("---------");
    }
}

