/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Lyric;
import org.herac.tuxguitar.song.models.Marker;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.effects.BendEffect;
import org.herac.tuxguitar.song.models.effects.GraceEffect;
import org.herac.tuxguitar.song.models.effects.HarmonicEffect;
import org.herac.tuxguitar.song.models.effects.TremoloBarEffect;
import org.herac.tuxguitar.song.models.effects.TremoloPickingEffect;
import org.herac.tuxguitar.song.models.effects.TrillEffect;

public class GP4InputStream
extends InputStream {
    private static final String[] supportedVersions = new String[]{"FICHIER GUITAR PRO v4.00", "FICHIER GUITAR PRO v4.06", "FICHIER GUITAR PRO L4.06"};
    private static final int GP_BEND_SEMITONE = 50;
    private static final int GP_BEND_POSITION = 60;
    private InputStream inputStream;
    private String version;
    private int tripletFeel;

    public GP4InputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public GP4InputStream(String string) throws FileNotFoundException {
        this(new FileInputStream(new File(string)));
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public int read() throws IOException {
        return this.inputStream.read();
    }

    private void readVersion() {
        try {
            if (this.version == null) {
                this.version = this.readStringByte(30);
            }
        }
        catch (IOException iOException) {
            this.version = "NOT_SUPPORTED";
        }
    }

    public static boolean isSupportedVersion(String string) {
        for (int i = 0; i < supportedVersions.length; ++i) {
            if (!string.equals(supportedVersions[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isSupportedVersion() {
        try {
            this.readVersion();
            return GP4InputStream.isSupportedVersion(this.version);
        }
        catch (Exception exception) {
            return false;
        }
        catch (Error error) {
            return false;
        }
    }

    public Song readSong() throws IOException, GPFormatException {
        int n;
        int n2;
        int n3;
        this.readVersion();
        if (!GP4InputStream.isSupportedVersion(this.version)) {
            throw new GPFormatException("Unsuported Version");
        }
        String string = this.readStringIntegerPlusOne();
        String string2 = this.readStringIntegerPlusOne();
        String string3 = this.readStringIntegerPlusOne();
        String string4 = this.readStringIntegerPlusOne();
        String string5 = this.readStringIntegerPlusOne();
        String string6 = this.readStringIntegerPlusOne();
        String string7 = this.readStringIntegerPlusOne();
        String string8 = this.readStringIntegerPlusOne();
        int n4 = this.readInt();
        String string9 = "";
        for (n3 = 0; n3 < n4; ++n3) {
            string9 = string9 + this.readStringIntegerPlusOne();
            string9 = string9 + "\n";
        }
        this.tripletFeel = this.readBoolean() ? 2 : 1;
        n3 = this.readInt();
        Lyric lyric = new Lyric(this.readInt(), this.readStringInteger());
        for (n2 = 0; n2 < 4; ++n2) {
            n = this.readInt();
            String string10 = this.readStringInteger();
        }
        n2 = this.readInt();
        n = this.readByte();
        int n5 = this.readInt();
        ArrayList<SongChannel> arrayList = new ArrayList<SongChannel>();
        int[] nArray = new int[64];
        for (int i = 0; i < 64; ++i) {
            arrayList.add(new SongChannel((short)i, (short)i, (short)this.readInt(), this.toChannelShort(this.readByte()), this.toChannelShort(this.readByte()), this.toChannelShort(this.readByte()), this.toChannelShort(this.readByte()), this.toChannelShort(this.readByte()), this.toChannelShort(this.readByte()), false, false));
            byte[] byArray = new byte[]{0, 0};
            this.read(byArray);
        }
        TimeSignature timeSignature = new TimeSignature(4, new Duration(4));
        int n6 = this.readInt();
        int n7 = this.readInt();
        ArrayList<MeasureHeader> arrayList2 = new ArrayList<MeasureHeader>();
        if (n6 > 0) {
            for (int i = 0; i < n6; ++i) {
                MeasureHeader measureHeader = this.createMeasureHeader(i + 1, timeSignature);
                arrayList2.add(measureHeader);
            }
        }
        ArrayList<SongTrack> arrayList3 = new ArrayList<SongTrack>();
        for (int i = 1; i <= n7; ++i) {
            SongTrack songTrack = this.createTrack(i, arrayList, i == n3 ? lyric : new Lyric());
            arrayList3.add(songTrack);
        }
        long l = 1000L;
        for (int i = 0; i < n6; ++i) {
            MeasureHeader measureHeader = (MeasureHeader)arrayList2.get(i);
            Tempo tempo = new Tempo(n2);
            measureHeader.setStart(l);
            for (int j = 0; j < n7; ++j) {
                SongTrack songTrack = (SongTrack)arrayList3.get(j);
                Measure measure = new Measure(measureHeader, new ArrayList(), new ArrayList(), 1, 0);
                this.addMeasureComponents(songTrack.getStrings(), measure, songTrack.getMeasures(), tempo);
                measureHeader.setTempo(tempo);
                songTrack.getMeasures().add(measure);
            }
            n2 = tempo.getValue();
            l += measureHeader.getLength();
        }
        return new Song(string, string3, string4, string5, arrayList3, arrayList2, 10);
    }

    private long addNotes(long l, List list, List list2, List list3, Tempo tempo) throws IOException, GPFormatException {
        int n;
        int n2;
        NoteEffect noteEffect = new NoteEffect();
        int n3 = this.readUnsignedByte();
        if ((n3 & 0x40) != 0) {
            n2 = this.readUnsignedByte();
            boolean bl = n2 == 0;
            n = n2 == 2 ? 1 : 0;
        }
        n2 = (n3 & 1) != 0 ? 1 : 0;
        Duration duration = this.parseDuration(this.readByte());
        duration.setDotted(n2 != 0);
        if ((n3 & 0x20) != 0) {
            n = this.readInt();
            switch (n) {
                case 3: {
                    duration.getTupleto().setEnters(3);
                    duration.getTupleto().setTimes(2);
                    break;
                }
                case 5: {
                    duration.getTupleto().setEnters(5);
                    duration.getTupleto().setTimes(4);
                    break;
                }
                case 6: {
                    duration.getTupleto().setEnters(6);
                    duration.getTupleto().setTimes(4);
                    break;
                }
                case 7: {
                    duration.getTupleto().setEnters(7);
                    duration.getTupleto().setTimes(4);
                    break;
                }
                case 9: {
                    duration.getTupleto().setEnters(9);
                    duration.getTupleto().setTimes(8);
                    break;
                }
                case 10: {
                    duration.getTupleto().setEnters(10);
                    duration.getTupleto().setTimes(8);
                    break;
                }
                case 11: {
                    duration.getTupleto().setEnters(11);
                    duration.getTupleto().setTimes(8);
                    break;
                }
                case 12: {
                    duration.getTupleto().setEnters(12);
                    duration.getTupleto().setTimes(8);
                }
            }
        }
        if ((n3 & 2) != 0) {
            this.readChordDiagram();
        }
        if ((n3 & 4) != 0) {
            String string = this.readStringIntegerPlusOne();
        }
        if ((n3 & 8) != 0) {
            this.readBeatEffects(noteEffect, duration);
        }
        if ((n3 & 0x10) != 0) {
            this.readMixChange(tempo);
        }
        int n4 = this.readUnsignedByte();
        List list4 = this.getPlayedStrings(n4, list2);
        for (int i = list4.size() - 1; i >= 0; --i) {
            InstrumentString instrumentString = (InstrumentString)list4.get(i);
            Note note = this.parseNote(l, instrumentString, duration, list, list3, (NoteEffect)noteEffect.clone());
            if (note == null) continue;
            list.add(note);
        }
        return duration.getTime();
    }

    private List getPlayedStrings(int n, List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if ((n & 1) != 0 && list.size() > 6) {
            arrayList.add(((InstrumentString)list.get(6)).clone());
        }
        if ((n & 2) != 0 && list.size() > 5) {
            arrayList.add(((InstrumentString)list.get(5)).clone());
        }
        if ((n & 4) != 0 && list.size() > 4) {
            arrayList.add(((InstrumentString)list.get(4)).clone());
        }
        if ((n & 8) != 0 && list.size() > 3) {
            arrayList.add(((InstrumentString)list.get(3)).clone());
        }
        if ((n & 0x10) != 0 && list.size() > 2) {
            arrayList.add(((InstrumentString)list.get(2)).clone());
        }
        if ((n & 0x20) != 0 && list.size() > 1) {
            arrayList.add(((InstrumentString)list.get(1)).clone());
        }
        if ((n & 0x40) != 0 && list.size() > 0) {
            arrayList.add(((InstrumentString)list.get(0)).clone());
        }
        return arrayList;
    }

    private Duration parseDuration(byte by) {
        Duration duration = null;
        switch (by) {
            case -2: {
                duration = new Duration(1);
                break;
            }
            case -1: {
                duration = new Duration(2);
                break;
            }
            case 0: {
                duration = new Duration(4);
                break;
            }
            case 1: {
                duration = new Duration(8);
                break;
            }
            case 2: {
                duration = new Duration(16);
                break;
            }
            case 3: {
                duration = new Duration(32);
                break;
            }
            case 4: {
                duration = new Duration(64);
            }
        }
        if (duration == null) {
            duration = new Duration(4);
            System.err.println("Incorrect Duration. Forcing duration Quarter as Default.");
        }
        return duration;
    }

    private int getTiedNoteValue(int n, List list, List list2) {
        Serializable serializable;
        int n2;
        if (!list.isEmpty()) {
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                serializable = (Note)list.get(n2);
                if (((Note)serializable).getString() != n) continue;
                return ((Note)serializable).getValue();
            }
        }
        if (!list2.isEmpty()) {
            for (n2 = list2.size() - 1; n2 >= 0; --n2) {
                serializable = (Measure)list2.get(n2);
                for (int i = ((Measure)serializable).getNotes().size() - 1; i >= 0; --i) {
                    Note note = (Note)((Measure)serializable).getNotes().get(i);
                    if (note.getString() != n) continue;
                    return note.getValue();
                }
            }
        }
        return -1;
    }

    private boolean readBoolean() throws IOException {
        return this.read() == 1;
    }

    private byte readByte() throws IOException {
        return (byte)this.read();
    }

    private RGBColor readColor() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        this.read();
        return new RGBColor(n, n2, n3);
    }

    private int readInt() throws IOException {
        int n = 0;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        this.read(byArray);
        n = (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        return n;
    }

    private Marker readMarker(int n) throws IOException {
        String string = this.readStringIntegerPlusOne();
        RGBColor rGBColor = this.readColor();
        return new Marker(n, string, rGBColor);
    }

    private MeasureHeader createMeasureHeader(int n, TimeSignature timeSignature) throws IOException {
        byte by;
        int n2 = this.readUnsignedByte();
        byte by2 = 0;
        if ((n2 & 1) != 0) {
            by2 = this.readByte();
        }
        byte by3 = 0;
        if ((n2 & 2) != 0) {
            by3 = this.readByte();
        }
        boolean bl = (n2 & 4) != 0;
        byte by4 = 0;
        if ((n2 & 8) != 0) {
            by4 = this.readByte();
        }
        byte by5 = 0;
        if ((n2 & 0x10) != 0) {
            by5 = this.readByte();
        }
        Marker marker = null;
        if ((n2 & 0x20) != 0) {
            marker = this.readMarker(n);
        }
        if ((n2 & 0x40) != 0) {
            by = this.readByte();
            this.readByte();
        }
        if ((n2 & 0x80) != 0) {
            // empty if block
        }
        byte by6 = by = (n2 & 0x80) != 0 ? (byte)1 : 0;
        if (by2 > 0) {
            timeSignature.setNumerator(by2);
        }
        if (by3 > 0) {
            timeSignature.setDenominator(new Duration(by3));
        }
        return new MeasureHeader(n, 0L, (TimeSignature)timeSignature.clone(), new Tempo(120), marker, this.tripletFeel, bl, by4);
    }

    private void addMeasureComponents(List list, Measure measure, List list2, Tempo tempo) throws IOException, GPFormatException {
        long l = measure.getStart();
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            l += this.addNotes(l, measure.getNotes(), list, list2, tempo);
        }
    }

    private Note parseNote(long l, InstrumentString instrumentString, Duration duration, List list, List list2, NoteEffect noteEffect) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.readUnsignedByte();
        boolean bl = (n4 & 2) != 0;
        noteEffect.setAccentuatedNote((n4 & 0x40) != 0);
        noteEffect.setGhostNote((n4 & 4) != 0);
        boolean bl2 = false;
        boolean bl3 = false;
        if ((n4 & 0x20) != 0) {
            n3 = this.readUnsignedByte();
            bl2 = n3 == 2;
            noteEffect.setDeadNote(n3 == 3);
        }
        if ((n4 & 1) != 0) {
            n3 = this.readByte();
            n2 = this.readByte();
        }
        n3 = 95;
        if ((n4 & 0x10) != 0) {
            n3 = 15 + 16 * this.readByte() - 16;
        }
        n2 = 0;
        if ((n4 & 0x20) != 0) {
            n2 = this.readByte();
        }
        if ((n4 & 0x80) != 0) {
            n = this.readByte();
            byte by = this.readByte();
        }
        if ((n4 & 8) != 0) {
            this.readNoteEffects(noteEffect, duration);
        }
        n = n2;
        if (n2 >= 0 || bl2) {
            if (bl2) {
                n = this.getTiedNoteValue(instrumentString.getNumber(), list, list2);
            }
            return new Note(n, l, (Duration)duration.clone(), n3, instrumentString.getNumber(), bl2, noteEffect);
        }
        return null;
    }

    private String readStringByte(int n) throws IOException {
        int n2 = this.readUnsignedByte();
        byte[] byArray = n != 0 ? new byte[n] : new byte[n2];
        this.read(byArray);
        n2 = n2 >= 0 ? n2 : n;
        return new String(byArray, 0, n2);
    }

    private String readStringInteger() throws IOException {
        int n = this.readInt();
        byte[] byArray = new byte[n];
        this.read(byArray);
        String string = new String(byArray);
        return string;
    }

    private String readStringIntegerPlusOne() throws IOException {
        int n = this.readInt();
        int n2 = n - 1;
        if (n2 != this.read()) {
            throw new IOException();
        }
        byte[] byArray = new byte[n2];
        this.read(byArray);
        String string = new String(byArray);
        return string;
    }

    private SongTrack createTrack(int n, List list, Lyric lyric) throws IOException {
        int n2;
        int n3;
        int n4 = this.readUnsignedByte();
        boolean bl = (n4 & 1) != 0;
        boolean bl2 = (n4 & 2) != 0;
        boolean bl3 = (n4 & 4) != 0;
        String string = this.readStringByte(40);
        int n5 = this.readInt();
        ArrayList<InstrumentString> arrayList = new ArrayList<InstrumentString>(n5);
        for (n3 = 0; n3 < 7; ++n3) {
            n2 = this.readInt();
            if (n5 <= n3) continue;
            arrayList.add(new InstrumentString(n3 + 1, n2));
        }
        n3 = this.readInt();
        n2 = this.readInt();
        int n6 = this.readInt();
        int n7 = this.readInt();
        int n8 = this.readInt();
        RGBColor rGBColor = this.readColor();
        return new SongTrack(n, string, this.parseChannel(list, n2, n6), new ArrayList(), arrayList, n8, rGBColor, lyric);
    }

    private SongChannel parseChannel(List list, int n, int n2) {
        SongChannel songChannel = (SongChannel)list.get(n - 1);
        short s = songChannel.getInstrument();
        if (s == -1) {
            songChannel.setInstrument((short)0);
        }
        if (!songChannel.isPercusionChannel()) {
            songChannel.setEffectChannel((short)(n2 - 1));
        }
        return songChannel;
    }

    private int readUnsignedByte() throws IOException {
        return this.read();
    }

    private void readChordType() throws IOException {
        this.readUnsignedByte();
    }

    private void readRoot() throws IOException {
        this.readByte();
    }

    private void readTonalityType(int n) throws IOException {
        if (n == 1) {
            int n2 = this.readUnsignedByte();
        } else if (n == 4) {
            int n3 = this.readInt();
        }
    }

    private String readChordName() throws IOException {
        byte[] byArray = new byte[21];
        char[] cArray = new char[20];
        this.read(byArray, 0, 21);
        int n = 20;
        if (byArray[0] < n) {
            n = byArray[0];
        }
        for (int i = 1; i <= n; ++i) {
            cArray[i - 1] = (char)byArray[i];
        }
        return String.valueOf(cArray, 0, n);
    }

    private void readChordDiagram() throws IOException, GPFormatException {
        int n = this.readUnsignedByte();
        if ((n & 1) == 0) {
            String string = this.readStringIntegerPlusOne();
            int n2 = this.readInt();
            if (n2 != 0) {
                for (int i = 0; i < 6; ++i) {
                    int n3 = this.readInt();
                }
            }
        } else {
            int n4;
            int n5;
            int n6;
            boolean bl = this.readBoolean();
            this.skip(3L);
            this.readRoot();
            this.readChordType();
            int n7 = this.readUnsignedByte();
            int n8 = this.readInt();
            this.readTonalityType(4);
            int n9 = this.readUnsignedByte();
            String string = this.readChordName();
            this.skip(2L);
            this.readTonalityType(1);
            this.readTonalityType(1);
            this.readTonalityType(1);
            int n10 = this.readInt();
            for (n6 = 1; n6 <= 7; ++n6) {
                n5 = this.readInt();
            }
            n6 = this.readUnsignedByte();
            for (n5 = 1; n5 <= 5; ++n5) {
                n4 = this.readUnsignedByte();
            }
            for (n5 = 1; n5 <= 5; ++n5) {
                n4 = this.readUnsignedByte();
            }
            for (n5 = 1; n5 <= 5; ++n5) {
                n4 = this.readUnsignedByte();
            }
            this.skip(8L);
            for (n5 = 1; n5 <= 7; ++n5) {
                n4 = this.readByte();
            }
            n5 = this.readBoolean() ? 1 : 0;
        }
    }

    private void readGraceNote(NoteEffect noteEffect) throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        int n4 = this.readUnsignedByte();
        boolean bl = n == 255;
        n = !bl ? n : 0;
        n2 = 15 + 16 * n2 - 16;
        if (n3 == 0) {
            n3 = 0;
        } else if (n3 == 1) {
            n3 = 1;
        } else if (n3 == 2) {
            n3 = 2;
        } else if (n3 == 3) {
            n3 = 3;
        }
        noteEffect.setGrace(new GraceEffect(n, n4, n2, n3, false, bl));
    }

    private void readBend(NoteEffect noteEffect, Duration duration) throws IOException {
        byte by = this.readByte();
        int n = this.readInt();
        BendEffect bendEffect = new BendEffect();
        int n2 = this.readInt();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.readInt();
            int n4 = this.readInt();
            byte by2 = this.readByte();
            bendEffect.addPoint(n3 * 12 / 60, n4 * 2 / 50);
        }
        if (!bendEffect.getPoints().isEmpty()) {
            noteEffect.setBend(bendEffect);
        }
    }

    private void readTremoloBar(NoteEffect noteEffect, Duration duration) throws IOException {
        byte by = this.readByte();
        int n = this.readInt();
        TremoloBarEffect tremoloBarEffect = new TremoloBarEffect();
        int n2 = this.readInt();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.readInt();
            int n4 = this.readInt();
            byte by2 = this.readByte();
            tremoloBarEffect.addPoint(n3 * 12 / 60, n4 * 1 / 50);
        }
        if (!tremoloBarEffect.getPoints().isEmpty()) {
            noteEffect.setTremoloBar(tremoloBarEffect);
        }
    }

    public void readTremoloPicking(NoteEffect noteEffect) throws IOException {
        int n = this.readUnsignedByte();
        if (n == 1) {
            noteEffect.setTremoloPicking(new TremoloPickingEffect(new Duration(8)));
        } else if (n == 2) {
            noteEffect.setTremoloPicking(new TremoloPickingEffect(new Duration(16)));
        } else if (n == 3) {
            noteEffect.setTremoloPicking(new TremoloPickingEffect(new Duration(32)));
        }
    }

    private void readNoteEffects(NoteEffect noteEffect, Duration duration) throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        if ((n & 1) != 0) {
            this.readBend(noteEffect, duration);
        }
        if ((n & 0x10) != 0) {
            this.readGraceNote(noteEffect);
        }
        if ((n2 & 4) != 0) {
            this.readTremoloPicking(noteEffect);
        }
        if ((n2 & 8) != 0) {
            noteEffect.setSlide(true);
            this.readByte();
        }
        if ((n2 & 0x10) != 0) {
            byte by = this.readByte();
            if (by == 1) {
                noteEffect.setHarmonic(new HarmonicEffect(1));
            } else if (by == 3) {
                noteEffect.setHarmonic(new HarmonicEffect(3));
            } else if (by == 4) {
                noteEffect.setHarmonic(new HarmonicEffect(4));
            } else if (by == 5) {
                noteEffect.setHarmonic(new HarmonicEffect(5));
            } else if (by == 15) {
                noteEffect.setHarmonic(new HarmonicEffect(2, 19));
            } else if (by == 17) {
                noteEffect.setHarmonic(new HarmonicEffect(2, 24));
            } else if (by == 22) {
                noteEffect.setHarmonic(new HarmonicEffect(2, 12));
            }
        }
        if ((n2 & 0x20) != 0) {
            byte by = this.readByte();
            byte by2 = this.readByte();
            if (by2 == 1) {
                noteEffect.setTrill(new TrillEffect((int)by, new Duration(16)));
            } else if (by2 == 2) {
                noteEffect.setTrill(new TrillEffect((int)by, new Duration(32)));
            } else if (by2 == 3) {
                noteEffect.setTrill(new TrillEffect((int)by, new Duration(64)));
            }
        }
        if ((n & 8) != 0) {
            // empty if block
        }
        noteEffect.setHammer((n & 2) != 0);
        noteEffect.setVibrato((n2 & 0x40) != 0 || noteEffect.isVibrato());
        noteEffect.setPalmMute((n2 & 2) != 0);
        noteEffect.setStaccato((n2 & 1) != 0);
    }

    private void readBeatEffects(NoteEffect noteEffect, Duration duration) throws IOException {
        int[] nArray = new int[]{0, 0};
        nArray[0] = this.readUnsignedByte();
        nArray[1] = this.readUnsignedByte();
        noteEffect.setFadeIn((nArray[0] & 0x10) != 0);
        noteEffect.setVibrato((nArray[0] & 2) != 0);
        if ((nArray[0] & 0x20) != 0) {
            int n = this.readUnsignedByte();
            noteEffect.setTapping(n == 1);
            noteEffect.setSlapping(n == 2);
            noteEffect.setPopping(n == 3);
        }
        if ((nArray[1] & 4) != 0) {
            this.readTremoloBar(noteEffect, duration);
        }
        if ((nArray[0] & 0x40) != 0) {
            this.readByte();
            this.readByte();
        }
        if ((nArray[1] & 1) != 0) {
            // empty if block
        }
        if ((nArray[1] & 2) != 0) {
            this.readByte();
        }
    }

    private void readMixChange(Tempo tempo) throws IOException {
        int n;
        int n2;
        int[] nArray = new int[8];
        int n3 = 0;
        for (n2 = 0; n2 < 7; ++n2) {
            n = this.readByte();
            if (n2 == 0 || n == -1) continue;
            nArray[n3] = n2;
            ++n3;
        }
        n = this.readInt();
        if (n != -1) {
            tempo.setValue(n);
            nArray[n3] = n2;
            ++n3;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.readByte();
        }
        int n4 = this.readUnsignedByte();
    }

    private short toChannelShort(byte by) {
        short s = by;
        return (s = (short)(s * 127 / 16)) <= 127 ? s : (short)127;
    }
}

