/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.exporter;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.herac.tuxguitar.io.exporter.ASCIIOutputStream;
import org.herac.tuxguitar.song.managers.MeasureManager;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;

public class ASCIITabOutputStream {
    private static final String[] TONIC_NAMES = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    private static final int MAX_LINE_LENGTH = 80;
    private SongManager manager;
    private PrintStream stream;
    private ASCIIOutputStream out;

    public ASCIITabOutputStream(PrintStream printStream) {
        this.stream = printStream;
    }

    public ASCIITabOutputStream(String string) throws FileNotFoundException {
        this(new PrintStream(new FileOutputStream(string)));
    }

    public void writeSong(Song song) {
        this.manager = new SongManager();
        this.manager.setSong(song);
        this.out = new ASCIIOutputStream(this.stream);
        this.drawSong();
        this.out.flush();
    }

    private void drawSong() {
        Song song = this.manager.getSong();
        this.out.drawStringLine("Title: " + song.getName());
        this.out.drawStringLine("ALbum: " + song.getAlbum());
        this.out.drawStringLine("Author: " + song.getAuthor());
        this.out.drawStringLine("Interpret: " + song.getInterpret());
        for (SongTrack songTrack : song.getTracks()) {
            this.out.nextLine();
            this.drawTrack(songTrack);
            this.out.nextLine();
        }
    }

    private void drawTrack(SongTrack songTrack) {
        int n;
        this.out.nextLine();
        this.out.drawStringLine("Track " + songTrack.getNumber() + ": " + songTrack.getName());
        String[] stringArray = new String[songTrack.getStrings().size()];
        int n2 = 1;
        for (n = 0; n < songTrack.getStrings().size(); ++n) {
            InstrumentString instrumentString = (InstrumentString)songTrack.getStrings().get(n);
            stringArray[n] = TONIC_NAMES[instrumentString.getValue() % TONIC_NAMES.length];
            n2 = Math.max(n2, stringArray[n].length());
        }
        n = 0;
        boolean bl = false;
        while (!bl) {
            this.out.nextLine();
            int n3 = n;
            for (int i = 0; i < songTrack.getStrings().size(); ++i) {
                InstrumentString instrumentString = (InstrumentString)songTrack.getStrings().get(i);
                this.out.drawTuneSegment(stringArray[i], n2);
                for (int j = n3; j < songTrack.getMeasures().size(); ++j) {
                    Measure measure = (Measure)songTrack.getMeasures().get(j);
                    this.drawMeasure(measure, instrumentString);
                    n = j + 1;
                    bl = this.manager.getTrackManager().isLastMeasure(songTrack, measure);
                    Point point = this.out.getPosition();
                    if (point.x > 80) break;
                }
                this.out.drawBarSegment();
                this.out.nextLine();
            }
            this.out.nextLine();
        }
        this.out.nextLine();
    }

    private void drawMeasure(Measure measure, InstrumentString instrumentString) {
        MeasureManager measureManager = this.manager.getMeasureManager();
        List list = measureManager.getComponents(measure);
        measureManager.orderComponents(list);
        this.out.drawBarSegment();
        this.out.drawStringSegments(1);
        Component component = this.next(list, measure.getStart(), instrumentString.getNumber());
        while (component != null) {
            int n = 0;
            if (component instanceof Note && ((Note)component).getString() == instrumentString.getNumber()) {
                Note note = (Note)component;
                n = Integer.toString(note.getValue()).length() - 1;
                this.out.drawNote(note.getValue());
            } else {
                this.out.drawStringSegments(1);
            }
            this.out.drawStringSegments(this.getDurationScaping(component.getDuration()) - n);
            component = this.next(list, component.getStart() + component.getDuration().getTime(), instrumentString.getNumber());
        }
    }

    private Component next(List list, long l, int n) {
        Component component = null;
        for (int i = 0; i < list.size(); ++i) {
            Component component2 = (Component)list.get(i);
            if (component2.getStart() >= l && (component == null || component2.getStart() < component.getStart())) {
                component = component2;
                continue;
            }
            if (component2.getStart() < l || component != null && component2.getStart() != component.getStart() || !(component2 instanceof Note) || ((Note)component2).getString() != n) continue;
            component = component2;
        }
        return component;
    }

    private int getDurationScaping(Duration duration) {
        int n = 1;
        if (duration.getValue() >= 16) {
            n = 2;
        } else if (duration.getValue() >= 8) {
            n = 3;
        } else if (duration.getValue() >= 4) {
            n = 4;
        } else if (duration.getValue() >= 2) {
            n = 5;
        } else if (duration.getValue() >= 1) {
            n = 6;
        }
        return n;
    }
}

